#include "defines.h"

#undef INST_CMP	 	/* Warren defines this when comparing */
				/* instruction traces against a working */
				/* PDP-11 */

uint8_t *ispace, *dspace;	/* Instruction and Data spaces */
extern uint16_t dwrite_base;

uint16_t regs[8];		/* general registers */
uint16_t stacks[4];		/* stack pointers */
uint16_t psw;			/* processor status word */
uint16_t sr;                    /* switch register */
uint16_t ir;			/* current instruction register */
uint16_t *adptr;		/* used in memory access macros */
uint16_t ea_addr;		/* stored address for dest modifying insts */

char *progname = NULL;		/* The program's name - used in debugging */
char realfilename[500];		/* These 2 are used on filename translation */
char *rfn;			/* to the APOUT_ROOT */

FILE *dbg_file = NULL;		/* Debugging output file */
int inst_debug = 0, trap_debug = 0;	/* Debugging flags */

void
run()
{
#ifdef DEBUG
#define XYZ 10
#ifdef XYZ
  int i;
  uint16_t oldpc[XYZ], oldir[XYZ], oldval[XYZ];
#endif
#endif

    /* Run until told to stop. */

    while (1) {

	/* Fetch and execute the instruction. */

#ifdef DEBUG
	lli_word(regs[PC], ir);
	if (dspace[010050]!=53)
		i=3;
	if (inst_debug) {
           fprintf(dbg_file, "%06o  ", ir);
           fprintf(dbg_file, "%o %o %o %o %o %o %o %o  ",
                regs[0], regs[1], regs[2], regs[3],
                regs[4], regs[5], regs[6], regs[7]);
           fprintf(dbg_file, "%06o\n", psw | 0170000);
	}
#ifdef XYZ
	for (i=1; i<XYZ; i++)
	 { oldpc[i-1]= oldpc[i]; oldir[i-1]= oldir[i]; oldval[i-1]= oldval[i]; }
	oldpc[XYZ-1]= regs[PC]; oldir[XYZ-1]= ir; oldval[XYZ-1]= dspace[010050];
#endif
	regs[PC] += 2; itab[ir >> 6] ();
#else
	/* When not debugging, we can manually unroll this inner loop */
	lli_word(regs[PC], ir); regs[PC] += 2; itab[ir >> 6] ();
	lli_word(regs[PC], ir); regs[PC] += 2; itab[ir >> 6] ();
	lli_word(regs[PC], ir); regs[PC] += 2; itab[ir >> 6] ();
	lli_word(regs[PC], ir); regs[PC] += 2; itab[ir >> 6] ();
	lli_word(regs[PC], ir); regs[PC] += 2; itab[ir >> 6] ();
	lli_word(regs[PC], ir); regs[PC] += 2; itab[ir >> 6] ();
	lli_word(regs[PC], ir); regs[PC] += 2; itab[ir >> 6] ();
	lli_word(regs[PC], ir); regs[PC] += 2; itab[ir >> 6] ();
	lli_word(regs[PC], ir); regs[PC] += 2; itab[ir >> 6] ();
#endif
    }
}

int
main(int argc, char **argv)
{
#ifdef INST_CMP
    char *envp[2] = {
	/* "PATH=:/bin:/usr/bin:/etc:/usr/lbin", */
	"PATH=:/bin:/usr/bin:/abcdefghrlbin",
	"HOME=/"
    };
    int envc = 2;
#else
	/* For now, we set the environment statically. Eventually */
	/* there will be code to get some environment variables */
    char *envp[3] = {
	"PATH=:/bin:/usr/bin:/usr/games",
	"HOME=/",
	"TERM=vt05"
    };
    int envc = 3;
#endif

    if (argc < 2) {
	fprintf(stderr, "Usage: apout [-debug] [-trap] v7_binary\n");
	exit(1);
    }
    if (!strcmp(argv[1], "-debug")) { inst_debug = 1; argc--; argv++; }
    if (!strcmp(argv[1], "-trap")) { trap_debug = 1; argc--; argv++; }
    if (inst_debug|trap_debug) dbg_file = fopen("apout.dbg", "w");

    signal(SIGBUS, bus_error);	/* Catch all bus errors here */

    sim_init();			/* Initialise the CPU */

    if (load_a_out(argv[1]) == -1) {
	fprintf(stderr, "Apout - couldn't load %s\n", argv[1]);
	exit(1);
    }
				/* Set the translation to a fictitious */
				/* root filesystem */
    if ((rfn = getenv("APOUT_ROOT"))) {
	strcpy(realfilename, rfn);
	rfn = realfilename;
	rfn += strlen(realfilename);
    } else {
	fprintf(stderr,
		"APOUT_ROOT env variable not set before running apout\n");
	exit(1);
    }
    argc--;
    argv++;
    set_arg_env(argc, argv, envc, envp, 0);

    run();			/* and run the binary */
    exit(0);
}


/* sim_init() - Initialize the cpu registers. */

void
sim_init()
{
    int x;

    for (x = 0; x < 8; ++x) { regs[x] = 0; }
    ir = 0; psw = 0; sr = 0;

#ifdef INST_CMP
    regs[0]= 005162; regs[1]= 034742;
#endif
}


void
set_arg_env(int argc, char **argv, int envc, char **envp, int oldexec)
{
    int i, posn, len;
    int eposn[MAX_ARGS];
    int aposn[MAX_ARGS];

    /* Set up the program's name -- used for debugging */
    if (progname) free(progname);
    progname = strdup(argv[0]);

    if (argc > MAX_ARGS) argc = MAX_ARGS;
    if (envc > MAX_ARGS) envc = MAX_ARGS;

    /* Now build the arguments and pointers on the stack; see the Sixth */
    /* and Seventh Edition manuals for a description of the layout */
	
    posn = PDP_MEM_SIZE - 2;
    sl_word(posn, 0);		/* Put a NULL on top of stack */

    if (!oldexec)
	for (i = envc - 1; i != -1; i--) {	/* For each env string */
	    len = strlen(envp[i]) + 1;		/* get its length */
#ifndef INST_CMP
	    if (len & 1 == 1) len++;		/* Make len divisible by 2 */
#endif
	    posn -= len;
	    memcpy(&dspace[posn], envp[i], len);
	    eposn[i] = posn;
	}

    for (i = argc - 1; i != -1; i--) {	/* For each arg string */
	len = strlen(argv[i]) + 1;	/* get its length */
#ifndef INST_CMP
	if (len & 1 == 1) len++;	/* Make len divisible by 2 */
#endif
	posn -= len;
	memcpy(&dspace[posn], argv[i], len);
	aposn[i] = posn;
    }

    if (!oldexec) {			/* For each env string */
	for (i = envc - 1; i != -1; i--) {
	    posn -= 2;
	    sl_word(posn, eposn[i]);	/* put a pointer to the string */
	}
	posn -= 2;
    }
#ifdef INST_CMP
    posn -= 2;
#endif
    				/* Put a NULL or -1 before arg pointers */
    if (oldexec) sl_word(posn, -1)
    else sl_word(posn, 0);

    for (i = argc - 1; i != -1; i--) {	/* For each arg string */
	posn -= 2;
	sl_word(posn, aposn[i]);	/* put a pointer to the string */
    }
    posn -= 2;
    sl_word(posn, argc);		/* Save the count of args */
    regs[SP] = posn;			/* and initialise the PC */
}

void
bus_error()
{
    fprintf(stderr, "Apout - bus error at PC 0%06o\n", regs[PC]);
    exit(1);
}

void
seg_fault()
{
    fprintf(stderr, "Apout - segmentation fault at PC 0%06o\n", regs[PC]);
    exit(1);
}
