/* Copyright (c)1994-2000 Begemot Computer Associates. All rights reserved.
 * See the file COPYRIGHT for details of redistribution and use. */
/* $Id: qna_regs.h,v 1.6 2000/03/04 08:03:31 hbb Exp $ */

typedef struct qna	qna_t;
typedef struct bdesc	bdesc_t;

struct qna {
	ushort	qna_addr[2];
	ushort	qna_rbdl[2];
	ushort	qna_tbdl[2];
	ushort	qna_vec;
	ushort	qna_csr;
};

# define QNA_RI		0100000		/* receive interrupt request */
# define QNA_CA		0020000		/* carrier */
# define QNA_OK		0010000		/* fuse ok */
# define QNA_SE		0002000		/* sanity timer enable */
# define QNA_EL		0001000		/* external loopback */
# define QNA_IL		0000400		/* internal loopback off */
# define QNA_XI		0000200		/* transmit interrupt request */
# define QNA_IE		0000100		/* interrupt enable */
# define QNA_RL		0000040		/* receive list invalid */
# define QNA_XL		0000020		/* transmit list invalid */
# define QNA_BD		0000010		/* boot/diag rom */
# define QNA_NI		0000004		/* non-existent memory */
# define QNA_SR		0000002		/* software reset */
# define QNA_RE		0000001		/* receiver enable */

struct bdesc {
	ushort	bd_flag;
	ushort	bd_desc;
	ushort	bd_addr;
	ushort	bd_len;
	ushort	bd_stat1;
	ushort	bd_stat2;
};

# define BD_VALID	0100000		/* buffer/address valid */
# define BD_CHAIN	0040000		/* chained buffer */
# define BD_EOM		0020000		/* end of message */
# define BD_SETUP	0010000		/* setup packet */
# define BD_LBYTE	0000200		/* low byte only termination */
# define BD_HBYTE	0000100		/* high byte only start */
# define BD_USED	0040000		/* used buffer */
# define BD_ERROR	0040000		/* error */
# define BD_LOSS	0010000		/* loss of carrier */
# define BD_NOCAR	0004000		/* no carrier */
# define BD_STE16	0002000		/* 4 minute sanity timer */
# define BD_ABORT	0001000		/* excessive collosions */
# define BD_FAIL	0000400		/* heartbeat failure */
# define BD_COUNT	0000360		/* collision count */
# define BD_ESETUP	0020000		/* looped back setup */
# define BD_DISCARD	0010000		/* */
# define BD_RUNT	0004000		/* runt packet */
# define BD_RBLH	0003400		/* receive packet length 8:10 */
# define BD_FRAME	0000004		/* frame alignment error */
# define BD_CRCERR	0000002		/* crc error */
# define BD_OVF		0000001		/* epp overflow */
# define BD_RBLL	0000377		/* receive packet length 0:7 */
