/* Copyright (c)1997 Begemot Computer Associates. All rights reserved.
 * See the file COPYRIGHT for details of redistribution and use. */
/*
 * $Id: cstrd.c,v 1.4 1997/12/01 10:04:40 hbb Exp $
 */
# include <stdio.h>
# include <string.h>
# include <ctype.h>
# include "begemot.h"

# define GROW 100


char *
cstrd(char *ptr, char delim, size_t ilen)
{
	size_t alloc, len;
	char *str;
	unsigned char c;

	alloc = GROW;
	len = 0;
	str = xalloc(alloc);

	while(ilen--) {
		if(len + 5 > alloc) {
			alloc += GROW;
			str = xrealloc(str, alloc);
		}
		c = *((unsigned char *)ptr)++;
		if(!isascii(c)) {
			sprintf(&str[len], "\\x%02x", (unsigned)c);
			len += 4;

		} else if(isprint(c)) {
			if(c == '\\' || c == (unsigned char)delim)
				str[len++] = '\\';

			str[len++] = c;

		} else {
			str[len++] = '\\';
			switch(c) {

			  case '\a':
				str[len++] = 'a';
				break;

			  case '\b':
				str[len++] = 'b';
				break;

			  case '\f':
				str[len++] = 'f';
				break;

			  case '\n':
				str[len++] = 'n';
				break;

			  case '\r':
				str[len++] = 'r';
				break;

			  case '\t':
				str[len++] = 't';
				break;

			  case '\v':
				str[len++] = 'v';
				break;

			  default:
				sprintf(&str[len], "x%02x", (unsigned)c);
				len += 3;
				break;
			}
		}
	}

	if(alloc == len) {
		alloc++;
		str = xrealloc(str, alloc);
	}
	str[len] = '\0';

	return str;
}

# ifdef TEST

# include <unistd.h>

int
main(int argc, char *argv[])
{
	int ret;
	char buf[512], *str;

	if((ret = read(0, buf, 512)) > 0) {
		str = cstrd(buf, ret);
		printf("\"%s\"\n", str);
	}

	return 0;
}

# endif
