'\"
'\" Copyright (c)1997 Begemot Computer Associates. All rights reserved.
'\" See the file COPYRIGHT for details of redistribution and use.
'\"
'\" $Id: panic.man,v 1.9 1998/04/28 11:46:39 hbb Exp $
'\"
.TH panic l "31 May 1996" "BEGEMOT" "BEGEMOT Library"
.SH NAME
panic, warn \- print error or warning message and eventualy exit
.SH SYNOPSIS
.nf
.LP
.B "# include <begemot.h>"
.LP
.BI "volatile void panic(const char *" "fmt" ", ...);"
.LP
.BI "volatile void bug(const char *" "fmt" ", ...);"
.LP
.BI "void error(const char *" "fmt" ", ...);"
.LP
.BI "void warn(const char *" "fmt" ", ...);"
.LP
.BI "void inform(const char *" "fmt" ", ...);"
.LP
.B "int geterrorcnt();"
.LP
.B "int getwarncnt();"
.LP
.BI "void set_errmode(int" " mode" ");"
.LP
.BI "void set_argv0(char *" "argv0" ");"
.fi
.SH DESCRIPTION
The functions
.BR panic , " bug" , " error" , " warn" " and " inform
are used to print messages in a standardized format to
.BR stderr .
.P
.B panic
should be used, when the program encounters an error of that kind, that
it's better to stop the program. It calles
.BR exit (3)
with a value of
.IR 1 .
If the environment variable
.B BEGEMOT_ABORT
is set, the program calls
.BR abort (3)
instead.
.B error
on the other hand should be used, when there is a severe error,
but the program can continue (but the user should expect bad things).
.B error
returns to the caller.
.B bug
should be used, if the program encounters an error, that is obviously a
programming error. A good example is putting
.B bug
in the default case of a switch statement, if it 'should not happen'.
.B warn
can be called if there may be an error and it's better to inform the user
about it.
.B inform
is called to print informative messages.
.P
There are also
.BR v -versions
of this functions, which take a
.B "va_list"
as second argument.
.P
There are two message formats: a simple one and a complicated one. The
simple one is the default. It consists of one of the words
.IR panic , " error" , " warning" , " info" " or " bug ,
followed by a colon, the formatted message and a new-line. For the complicated
format this is prefixed with the program name, which can be set with
.BR set_argv0 .
If it is not set, nothing is printed.
The name is followed by the program's pid, the current time.
.P
The mode can be selected with
.BR set_errmode .
An argument of zero selects the simple mode, non-zero values
the complicated one. This setting may be overriden with the environment
variable
.BR "BEGEMOT_ERR" .
.P
It is often not simple to decide which of these functions to call in a certain situation. If the program
comes in a situation, where continuation will most probably make things worse, then call
.BR panic .
Examples of this are: memory cannot be allocated (exhaustion of virtual memory under UNIX is in almost
all cases the outcome of a bug), a critical file cannot be found.
A warning should be issued, if the program cannot decide what the user's indentation was, but continuation will
do no harm. The error function should be called, if the program can not continue as needed, but manual
user actions can correct things. If the program finds, for example, after a long computation, that it cannot
write the output to the desired file because of protection, it may write the output to /tmp and give the
user a hint where to find it.
.P
The calls to
.B error
and
.B warn
are counted. These counts can be retrieved with
.B geterrorcnt
and
.BR getwarncnt .
.SH "RETURN VALUE"
.B panic
and
.B bug
never return.
.BR warn ,
.B error
and
.B inform
return nothing.
.B geterrorcnt
and
.B getwarncnt
return the respective counts. This may be wrong if the functions are
called more the 4 billion times.
.SH "ENVIRONMENT"
.TP
BEGEMOT_ERR
Overrides the format mode.
.TP
BEGEMOT_ABORT
Generate a core dump on call to
.BR panic .
.SH "SEE ALSO"
.BR exit (2),
.BR abort (3),
.BR fprintf (3),
.BR vfprintf (3)
.BR stdarg (3)
.SH AUTHOR
Harti B. Brandt
