#!/bin/sh

# This script modifies the kernel sources in /usr/src/sys to install
# Ethernet Tunnel Driver (TAP)
#
# It is intended to be run in device driver installation directory.
#
# This works for FreeBSD 3.2
#
# Maksim Yevmenkin 	evmax@earthlink.net	 October 1999
#			m_evmenkin@yahoo.com

  uid=`id -u`
 kdir=`uname -v | sed s/.*://g`
kname=`echo $kdir | awk -F'/' '{printf $NF}'`
kcomp=`echo $kdir | awk -F'/' '{printf $(NF-1)}'`
 ksys=`echo $kdir | sed s/\\\/$kcomp\\\/$kname//g`
 knet=$ksys/net
 kmod=$ksys/modules
karch=`uname -m`
kconf=$ksys/$karch/conf
 dsrc='if_tap.c if_tap.h if_tapvar.h'
dtemp='TAP.template'

if [ $uid != 0 ]; then 
	echo You must be a root to install driver
	exit
fi

echo Coping source files to $knet directory...
for s in $dsrc; do
	echo cp $s $knet
	cp $s $knet
done
echo

echo Creating entry in $ksys/modules directory...
if [ ! -d $ksys/modules/if_tap ]; then
	echo mkdir $ksys/modules/if_tap
	mkdir $ksys/modules/if_tap
fi
echo Copying Makefile into $ksys/modules/if_tap directory...
echo cp Makefile.kmodule $ksys/modules/if_tap/Makefile
cp Makefile.kmodule $ksys/modules/if_tap/Makefile
echo

echo Patching files.i386 file in $kconf directory...
echo 'patch $kconf/files.i386 < files.i386.diff'
patch $kconf/files.i386 < files.i386.diff
echo

echo Copying device driver entry template...
echo cp $dtemp $kconf
cp $dtemp $kconf
echo

echo Patching MAKEDEV.local in /dev directory...
echo 'patch /dev/MAKEDEV.local < MAKEDEV.local.diff'
patch /dev/MAKEDEV.local < MAKEDEV.local.diff
echo

echo Done. 
echo
echo To activate driver
echo - add entry to the kernel configuration file. See $dtemp for details
echo - do config KERNEL_CONFIG_FILE_NAME
echo - build and install new kernel
echo - reboot
echo
