/* p11 - pdp11 emulator; Copyright (C) 1994 Hartmut Brandt, Joerg Micheel 
 * see the file LICENSE for further information */

# include <string.h>

/*
 * getfields library functions
 * written from scratch after looking at the man-page from plan9
 * not very tested yet and poorly implemented, just to work
 */
static char *delim = " \t";

char *setfields(char *new)
{
	char *ret = delim;
	delim = new;
	return ret;
}

int
getfields(char *line, char **tab, int max)
{
	int cnt = 0;
	char *d;

	while(*line && cnt < max) {
		*tab++ = line;
		cnt++;

		if((d = strpbrk(line, delim)) == 0)
			break;

		*d++ = 0;
		line = d;
	}

	if(cnt < max)
		*tab = 0;
	return cnt;
}

int
getmfields(char *line, char **tab, int max)
{
	int cnt = 0;
	char *d;
	int skip;

	line += strspn(line, delim);
	while(*line && cnt < max) {
		*tab++ = line;
		cnt++;

		if((d = strpbrk(line, delim)) == 0)
			break;

		*d++ = 0;
		skip = strspn(d, delim);
		line = d + skip;
	}

	if(cnt < max)
		*tab = 0;
	return cnt;
}
