/* p11 - pdp11 emulator; Copyright (C) 1994 Hartmut Brandt, Joerg Micheel 
 * see the file LICENSE for further information */

/*
 * i386 floating point operations
 * implemented in as because gcc doesn't know about extended doubles
 *
 * there is a problem with bsdi 1.0 here, because on signaling the systems
 * reset the 387 control word to default (53 bit).
 * so we set before each operation the control word and hope we will not
 * be interrupted (block all signals each time isn't a good idea, I think)
 *
 */
# define InitFp()	/* sigprocmask(block all signals) */ \
			asm("fldcw %0" :: "m"(0xF37));
# define EndFp()	/* sigprocmask(enable all signals) */

/* 
 * add S to A
 * sub S from A
 * mul A by S
 * divide A by S (S is already checked for 0)
 * the limits of the host float should be sufficient not
 * to produce any errors.
 */
# define AddF(A,S)	asm("fldt %2; fldt %0; faddp; fstpt %0; fwait"	\
				: "=m"(A) : "0"(A), "m"(S))
# define SubF(A,S)	asm("fldt %2; fldt %0; fsubp; fstpt %0; fwait"	\
				: "=m"(A) : "0"(A), "m"(S))
# define MulF(A,S)	asm("fldt %2; fldt %0; fmulp; fstpt %0; fwait"	\
				: "=m"(A) : "0"(A), "m"(S))
# define DivF(A,S)	asm("fldt %2; fldt %0; fdivp; fstpt %0; fwait"	\
				: "=m"(A) : "0"(A), "m"(S))

/*
 * separate A in fractional part F and integral part I
 */
# define ModF(A,F,I)	asm("fldt %2; frndint; fstpt %1; \
			     fldt %1; fldt %2; fsubp; fstpt %0; fwait" \
				: "=m"(F), "=m"(I) : "m"(A))
/*
 * check if S is zero
 */
# define IsZ(S)		({int _r; asm("fldt %1; fldz; fucompp; fnstsw %0; fwait" \
				: "=a"(_r) : "m"(S)); \
			  (_r & 0x4500) == 0x4000;})

/*
 * check if S is negativ
 */
# define IsN(S)		((S).s)


/*
 * convert long to float
 */
# define CnvL(A,L)	asm("pushl %1; fildl (%%esp); add $4,%%esp; fstpt %0; fwait" \
				: "=m"(A) : "g"(L))

/*
 * chop float to long, range already checked
 * chop already set by InitFp
 * &L makes sure L doesn't go into a register
 */
# define CnvF2L(S,L)	asm("fldt %1; fistpl %0; fwait" \
				: "=m"(L) : "m"(S), "r"(&(L)));


/*
 * return K so that 2^K <= A < 2^(K+1)
 * (A may not be 0 here)
 */
# define FrExp(A)	((A).e - EXP_OFF)



/*
 * i386 temporary float format
 */
struct Float {
	unsigned	ml : 32;	/* low mant */
	unsigned	mh : 32;	/* high mant, high bit is 1 */
	unsigned	e : 15;		/* expo offset 0x3fff */
	unsigned	s : 1;		/* sign */
};
# define EXP_OFF	0x3fff


/*
 * return i386 temp float mantissa as 64 bit fixed point value with
 * point right after the most significant bit and 1.0 > m >= 0.5
 */
# define GetMant(P)	((((UQuad)(P)->mh & 0x7FFFFFFF) << 32) | (UQuad)(P)->ml)
# define GetExp(P)	((int)(sshort)(P)->e - EXP_OFF + 1)
# define GetSign(P)	(P)->s

/*
 * rebuild i386 temp float
 */
# define SetMant(H,M)	(((H)->mh = ((M) >> 32) | 0x80000000), (H)->ml = (M))
# define SetExp(H,E)	((H)->e = (E) - 1 + EXP_OFF)
# define SetSign(H,S)	((H)->s = (S))



/*
 * covert internal float to double, just for printing and debuging
 */
static double
mkd(Float *f)
{
	static double	dd;

	asm("fldt %1 ; fstpl %0 ; fwait" : "=m"(dd) : "m"(*f));
	return dd;
	printf("%.16e", dd);
}


/*
 * convert pdp float to double for printing
 * precision may be lost and over/underflow may occure
 */
static double
mkdouble(PDP_Float *f, int d)
{
	Float h;

	unfold(f, &h, d);
	return mkd(&h);
}


/*
 * dump an i386 temp float
 */
static void
dmpflt(Float *f)
{
	int e = f->e - EXP_OFF;

	printf("%c ", "+-"[f->s]);
	if(f->e)
		printf(" %04x ", e & 0x7fff);
	else 
		printf("    0 ");	
	printf("%08x %08x", f->mh, f->ml);
}
