.
.s3
.lp +7 5
\fB\-h\fR	Write listing with standard tabs.
.s3
.lp +7 5
\fB\-p\fR	Prompt with `*' when taking input from the teletype.
.s3
.lp +7 5
\fB\-m\fR	When input returns to the teletype
from a lower level, repeat the prompt, if any.
.s3
.lp +7 5
\fB\-a\fR	Make
.bd \-k
implicit for included sources,
thereby protecting them from keyword substitutions.
.s3
.lp +7 5
\fB\-c\fR	List control lines on diagnostic output.
.s3
.lp +7 5
\fB\-d\fR	Extend the current set of keyword
definitions by adding those active at the end of
included sources.
.i0
.s3
Control lines are input lines
which begin with `~'.
In the default mode
.bd +ir,
they are interpreted as commands to
.it send.
Normally they are
detected immediately and
read literally.
The
.bd \-s
flag forces
keyword substitutions to be made
before control lines
are intercepted and interpreted.
Arguments appearing in control lines are handled
exactly like the command arguments to
.it send,
except that they are processed
at a nested level of input.
.s3
The two possible formats for a control line are:#
#`~argument'# and #`~#argument#...'.
In the first case,
where the `~' is not followed by a space,
the remainder of the line
is taken as a single argument to
.it send.
In the second case,
the line is parsed
to obtain a sequence of arguments
delimited by spaces.
In this case
the quotes `\'' and `"'
may be employed to pass embedded spaces.
.s3
The interpretation of the argument `.'
is chosen so that  an input line
consisting of `~.'
is treated as a logical end-of-file.
The following example illustrates
some of the above conventions:
.s3
.lp +10 0
send \-
.br
~ argument ...
.br
~.
.i0
.s3
This sequence of three lines
is equivalent to
the command synopsis
at the beginning of this description.
In fact, the `\-' is not even required.
By convention, the
.it send
command reads standard input
if no other input source is specified.
.it Send
may therefore be employed
as a filter with side-effects.
.s3
The execution of the
.it send
command is controlled at each instant
by a current environment,
which includes
the format specification for the input source,
a default format specification for included sources,
the settings of the mode flags,
and the active set of keyword definitions.
This environment can be altered dynamically.
When a control line opens a new source of input,
the current environment is pushed onto a stack,
to be restored when input resumes
from the old source.
The initial format specification
for the new source
is taken from the first line of the file.
If none is provided, the established default is used
or, in its absence, standard tabs.
The initial mode settings
and active keywords
are copied from the old environment.
Changes made while processing
the new source
will not affect the environment
of the old source, with one exception.
Namely, if
.bd \-d
mode is set in the old environment,
the old keyword context
will be augmented by those definitions
which are active at the end of the new source.
When
.it send
begins execution,
all mode flags are reset,
and no keywords are defined.
.s3
The initial, reset state for all mode flags
is the `+' state.
In general, special processing
associated with a mode `x'
is invoked by flag \-x
and is revoked by flag +x.
Most mode settings have an immediate effect
on the processing of the current source.
Exceptions to this are the
.bd \-r
and
.bd \-i
flags,
which apply only to included source,
causing it to be processed
in an uninterpreted manner.
.s3
A keyword is an arbitrary ASCII string for which
a replacement has been defined.
The replacement may be another string or
(for IBM RJE only)
the hexadecimal code for a single 8-bit byte.
At any instant a given set of keyword definitions are active.
Input text lines are scanned,
in one pass from left to right,
and longest matches are attempted
between substrings of the line
and the active set of keywords.
Characters which do not match
are output subject to folding and
the standard translation.
Keywords
are replaced
by the specified hexadecimal code
or replacement string,
which is then output
character by character.
The expansion of tabs
and length checking,
according to the format specification
of an input source,
are delayed until
substitutions have been made in a line.
.s3
All of the keywords definitions made
in the current source
may be deleted by
setting the
.bd \-k
flag.
It then becomes possible
to reuse them,
although this is not recommended.
Setting the
.bd \-k
flag also causes keyword definitions active
at the previous source level to be ignored.
Setting the
.bd +k
flag causes keywords at the previous level to be ignored
but does not delete the definitions
made at the current level.
The
.bd =k
argument reactivates the definitions of the previous level.
.s3
A keyword may not be redefined,
except redundantly,
if it is active at some level of source input
and its replacement is not null.
Prompts for keywords
which have already been defined at some higher level
will simply cause the definitions
to be copied down to the current level;
new definitions
will not be solicited.
Only in the case where a keyword is defined by a null replacement, `A=',
is a redefinition allowed, `A=a'.
Prompts for the keyword, `=:A',
will be satisfied by either definition.
.s3
Keyword substitution is
an elementary macro facility
which is easily explained
and which appears useful enough
to warrant its inclusion in the
.it send
command.
More complex replacements are
the function of a general macro processor.
To reduce the overhead of string comparison,
it is recommended that
keywords be chosen
so that their initial characters
are unusual.
For example, let them all be upper case,
or let them all begin with an escape character.
.s3
.it Send
performs two types of error checking on input text lines.
Firstly, only ASCII graphics
and tabs
are permitted in input text.
Secondly, the length of a text line,
after substitutions have been made,
may not exceed 80 bytes for IBM or 132 bytes for UNIVAC.
The length of each line may be additionally constrained
by a size parameter
in the format specification
for an input source.
Diagnostic output provides
the location of each erroneous line,
by line number and input source,
a description of the error,
and the card image which results.
Other routine errors which are announced are
the inability to open or write files
and abnormal exits from the shell.
Normally, the occurrence of any error
causes
.it send,
before invoking the queuer,
to prompt for positive affirmation
that the suspect run stream
should be submitted.
.s3
.tr ||
The
.it hasp
subsystem, which supports IBM RJE,
operates in EBCDIC code.
The
.it send
command is therefore required to
translate ASCII characters into
EBCDIC equivalents.
The standard conversion is based on
the character set described in
`Appendix H' of
.it "IBM System/370 Principles of Operation"
(SRL GA22-7000).
Each ASCII character in the octal range 040-176
possesses a graphic equivalent
into which it is mapped,
with four exceptions:# \*v=or,
^=not, [=cents, and ]=broken-line.
In listings requested from
.it send,
and in printed output returned by
.it hasp,
the r