s must generally be converted
to a standard format,
frequently by replacing all tabs with
the appropriate number of spaces,
before they can be processed by UNIX commands.
A format specification
occurring in the first line of a text file
specifies how tabs are to be expanded in the remainder of the file.
.s3
A format specification consists of a sequence of parameters
separated by blanks and surrounded by the brackets
`<:' and `:>'.
Each parameter consists of a keyletter,
possibly followed immediately by a value.
The following parameters are recognized:
.s3
.lp +11 9
\fBt\fItabs\fR	The
.bd t
parameter specifies
the tab settings for the file.
The value of
.it tabs
must be one of the following:
.lp +16 3
1.	a list of column numbers separated by commas,
indicating tabs set at the specified columns;
.lp +16 3
2.	a `\-' followed immediately by an integer
.it n,
indicating tabs at intervals of
.it n
columns;
.lp +16 3
3.	a `\-' followed by the name of a `canned' tab specification.
.lp +11 9
	Standard tabs are specified by `t-8' or, equivalently,
`t1,9,17,25,etc'.
The canned tabs which are recognized are defined by the
.it tabs
command \-
a,a2,c,c2,c3,f,p,s,u.
.s3
.lp +11 9
\fBs\fIsize\fR	The
.bd s
parameter specifies a maximum line size.
The value of
.it size
must be an integer.
Size checking is performed after tabs have been expanded,
but before the margin is prepended.
.s3
.lp +11 9
\fBm\fImargin\fR	The
.bd m
parameter specifies a number of spaces to be
prepended to each line.
The value of
.it margin
must be an integer.
.s3
.lp +11 9
\fBd\fR	The
.bd d
parameter takes no value.
Its presence indicates that the line containing the format specification
is to be deleted from the converted file.
.s3
.lp +11 9
\fBe\fR	The
.bd e
parameter takes no value.
Its presence indicates that the current format is to prevail
only until another format specification
is encountered in the file.
.i0
.s3
Default values, which are assumed for parameters not supplied,
are `\fBt\fR-8' and `\fBm\fR0'.
If the
.bd s
parameter is not specified, no size checking is performed.
.s3
If the first line of a file does not contain a format specification,
the above defaults are assumed for the entire file.
.s3
The following is an example of a line containing a format specification:
.s3
.lp +6 0
/* <:t5,10,15 s72:> */
.i0
.s3
If a format specification can be disguised as a comment,
it is not necessary to code the
.bd d
parameter.
.s3
Several
.it "Programmer's Workbench"
commands correctly interpret the format specification for a file.
Among them is
.it gath
which
may be used to convert files to a standard format
acceptable to other UNIX commands.
.sh "SEE ALSO"
gath(PWB I), reform(PWB I), send(PWB I), tabs(PWB I)
The following is an example of a line containing a format specification:
.s3
.lp +6 0
/* <:t5,10,15 s72:> */
.i0
.s3
If a format specification can be disguised as a comment,
it is not necessary to code the
.bd d
parameter.
.s3
Several
.it "Programmer's Workbench"
commands correctly interpret the format specification for a file.
Among them is
.it gath
whi.th GATH "PWB I" 11/03/75
'
'  This information is proprietary and is the property of Bell
'  Telephone Laboratories, Incorporated.  Its reproduction or
'  disclosure to others, either orally or in writing, is pro-
'  hibited without written permission of Bell Laboratories.
'
.sh NAME
gath \- gather real and virtual files
.sh SYNOPSIS
.bd gath
[\fB\-ih\fR] file ...
.sh DESCRIPTION
.it Gath
concatenates the named files and writes them to standard output.
Tabs are expanded into spaces according to
the format specification for each file (see fspec(PWB V)).
The size limit and margin parameters of a format specification
are also respected.
Non-graphic characters other than tabs are identified
by a diagnostic message and excised.
The output of gath contains no tabs unless the
.bd \-h
flag is set, in which case it is written with standard tabs
(every eighth column).
.s3
Any line of any of the files which begins with `~'
is interpreted by
.it gath
as a control line.
A line beginning `~ ' (tilde,space)
specifies a sequence of files to be included at that point.
A line beginning `~!' specifies a UNIX command whose output
is to be collected at that point.
Setting the
.bd \-i
flag prevents control lines from being interpreted
and causes them to be output literally.
.s3
A file 