.tr #
.th SEND "PWB I" 01/12/76
'
'  This information is proprietary and is the property of Bell
'  Telephone Laboratories, Incorporated.  Its reproduction or
'  disclosure to others, either orally or in writing, is pro-
'  hibited without written permission of Bell Laboratories.
'
.sh NAME
send \- submit RJE job
.sh SYNOPSIS
.bd send
argument ...
.sh DESCRIPTION
.it Send
is a command-level interface to the RJE subsystems
.it hasp
and
.it uvac.
It allows the user
to collect input from various sources
in order to create a run stream
consisting of card images.
.it Send
creates a temporary file, with a special format,
to contain the collected run stream
and then queues the file for transmission
by invoking
.it haspqer
or
.it uvacqer,
as appropriate.
Further processing of the job is controlled by
the RJE subsystem and the host computer
to which the job is submitted.
.s3
Possible sources of input to
.it send
are:  ordinary files, standard input,
the teletype,
and the output of a command or shell file.
Each source of input is treated as a virtual file,
and no distinction is made based upon its origin.
Typical input is an ASCII text file of the sort
that is created by the editor.
An optional format specification
appearing in the first line of a file
(see fspec(PWB V)) determines the settings
according to which tabs are expanded into spaces.
In addition, lines which begin with `~'
are normally interpreted as commands
controlling the execution of
.it send.
They may be used to set or reset flags,
to define keyword substitutions,
and to open new sources of input
in the midst of the current source.
Other text lines are translated one-for-one
into card images of the run stream.
.s3
The run stream which results from this collection
is treated as one job by the RJE subsystems.
.it Send
provides a card count for the run stream,
and the queuer which is invoked
announces the position
which the job has been assigned
in the queue of jobs waiting to be transmitted.
The initial card of an IBM job
must have a `/' in the first column.
The initial card of a UNIVAC run
must be a run card,
beginning `@RUN'
or `\`run', etc.
Any cards preceeding these will be excised.
If a host computer is not specified before the first card of the runstream is output,
.it send
will select a reasonable default.
In the case of an IBM job, all cards
beginning `/*$' will be excised from the runstream,
because they are HASP command cards.
.s3
The arguments which
.it send
accepts are described below.
An argument is interpreted
according to
the first pattern which it matches.
Preceding a character with `\\'
causes it to lose its special meaning
when matching against an argument pattern.
.s3
.lp +23 21
\&.	Close the current source.
.s3
.lp +23 21
\-	Open standard input as a new source.
.s3
.lp +23 21
+	Open the teletype as a new source.
.s3
.lp +23 21
:\fIspec\fR:	Establish a default format
specification for included sources,
e.g.
:m6t-12:.
.s3
.lp +23 21
:\fImessage\fR	Print a message on the teletype.
.s3
.lp +23 21
\-:\fIprompt\fR	Open standard input
and, if it is a teletype,
print the prompt.
.s3
.lp +23 21
+:\fIprompt\fR	Open the teletype
and prompt.
.s3
.lp +23 21
\-\fIflags\fR	Set the specified mode flags,
which are described below.
.s3
.lp +23 21
+\fIflags\fR	Reset the specified flags.
.s3
.lp +23 21
=\fIflags\fR	Restore the specified flags to their state
at the previous level.
.s3
.lp +23 21
!\fIcommand\fR	Execute the specified command
via the one-line shell,
with input redirected to /dev/null
as a default.
Open the standard output of the command
as a new source.
.s3
.lp +23 21
$\fIline\fR	Collect contiguous arguments
of this form and write them
as consecutive lines
to a temporary file;
then shell the file.
Open the standard output of the shell
as a new source.
.s3
.lp +23 21
~\fIcomment\fR	Ignore this argument.
.s3
.lp +23 21
=:\fIkeyword\fR	Prompt for a definition
of the keyword from the teletype.
.s3
.lp +23 21
\fIkeyword\fR=^\fIxx\fR	Define the keyword
as a two-digit hexadecimal character code.
.s3
.lp +23 21
\fIkeyword\fR=\fIstring\fR	Define the keyword
in terms of a replacement string.
.s3
.lp +23 21
\fIhost\fR	Job is to be submitted to: \fB158\fR,\fB168\fR,\fB1110\fR.
.s3
.lp +23 21
\fIfilename\fR	Open the specified file as a new source of input.
.i0
.s3
Arguments of the form `!chdir \fIdirectory\fR'
will be trapped so that the
.it send
process can execute the specified chdir itself.
The original directory will be restored at the end
of any source which incurs a chdir.
.s3
The flags recognized by
.it send
are described in ter