/*
	Mini-UNIX File system structures
*/

#define BLOCK 512

struct super {
	int isize;		/* size of i-list				*/
	int fsize;		/* file system size				*/
	int nfree;		/* number of entries in free	*/
	int free[100];	/* free block list				*/
	int ninode;		/* number of entries in inode	*/
	int inum[100];	/* free inode list				*/
	char flock;		/* free list lock flag			*/
	char ilock;		/* free inode list lock flag	*/
	char fmod;		/* modified super block flag	*/
	int time[2];	/* last super block update		*/
};

struct inode {
	int flags;		/* various flags				*/
	char nlinks;	/* number of links to file		*/
	char uid;		/* user ID of owner				*/
	char gid;		/* group ID of owner			*/
	char size0;		/* high byte of file size		*/
	unsigned size1;	/* low word of file size		*/
	int addr[8];	/* block or device numbers		*/
	int actime[2];	/* last access date stamp		*/
	int modtime[2];	/* last update date stamp		*/
};

struct dir {
	int inum;		/* i-node of file (or 0)		*/
	char name[14];	/* file name					*/
};

		