h25567
s 00001/00001/01250
d D 1.16 81/06/17 09:37:32 root 16 15
c alter tektronics login message for small characters
e
s 00001/00000/01250
d D 1.15 81/05/18 12:39:58 root 15 14
c include types.h (used to be included by stat.h)
e
s 00003/00003/01247
d D 1.14 81/05/12 20:47:25 root 14 13
c no sys subdirectory in includes anymore
e
s 00001/00006/01249
d D 1.13 81/04/24 22:12:34 root 13 12
c rationalise use of pwclose - put it where needed
e
s 00000/00001/01255
d D 1.12 81/04/23 16:35:16 root 12 11
c removed a useless include of param.h
e
s 00014/00009/01242
d D 1.11 81/04/23 16:25:07 root 11 10
c upgraded again to be similar to the vax
c kept the changes made previously in both 70 and vax
e
s 00001/00001/01250
d D 1.10 81/03/09 10:42:48 root 10 9
c chmod tty to 620 instead of 621
e
s 00001/00001/01250
d D 1.9 81/03/06 23:08:36 root 9 8
c increase arbitrary size of homedir buffer by 32 bytes
e
s 00001/00005/01250
d D 1.8 81/03/03 17:23:09 root 8 7
c look for .mail instead of /usr/mail/froth
e
s 00002/00002/01253
d D 1.7 81/02/17 13:50:22 root 7 6
c fix up ctime/localtime calls to local spec
e
s 00004/00003/01251
d D 1.6 81/02/10 16:16:31 root 6 5
c added hi-speed tektronics type to local list
e
s 00000/00137/01254
d D 1.5 81/02/03 11:16:17 root 5 4
c removal of more useless frothing
e
s 00050/00085/01341
d D 1.4 81/02/02 18:17:06 root 4 3
c added facility for storing strings that MUST be printed out
e
s 00002/00015/01424
d D 1.3 81/02/02 11:29:23 root 3 2
c remove useless environment frothing
e
s 00023/00016/01416
d D 1.2 81/01/31 16:03:03 root 2 1
c original from elecvax 20/1/81 modified to compile even on the 70
e
s 01432/00000/00000
d D 1.1 81/01/23 13:11:19 root 1 0
e
u
U
t
T
I 1
/*
**	Getty -- adapt to terminal speed on dialup, and call login
**
**	Bugs and comments to:	Piers Lauder
**				Dept of Comp Sci
**				Sydney University
**	May '80.
*/


#include	<local-system>
I 15
#include	<types.h>
E 15
D 12
#include	<sys/param.h>
E 12
D 14
#include	<sys/stat.h>
I 2
D 5
#ifdef	BASSERVAX
E 2
#include	<sys/utsname.h>
I 2
#endif	BASSERVAX
E 5
E 2
#include	<sys/dir.h>
E 14
I 14
#include	<stat.h>
#include	<dir.h>
E 14
I 2
D 11
#include	<sys/fcntl.h>
#include	<sys/tty.h>
E 11
E 2
#include	<signal.h>
#include	<passwd.h>
#include	<setjmp.h>
I 11
D 14
#include	<sys/fcntl.h>
E 14
I 14
#include	<fcntl.h>
E 14
E 11
D 2
#include	<fcntl.h>
E 2
#include	<sgtty.h>
#include	<stdio.h>
#include	<utmp.h>
#include	<time.h>
#include	<conlim.h>
#ifdef	TTY_GROUP
#include	<ttygroup.h>
#endif
#ifdef	AUSAMSCHD
#ifndef	vax
#include	"decays.h"
#endif	vax
#endif	AUSAMSCHD


D 11
#define	PW_AGE		(30L*24L*60L*60L)	/* max. age for a password */
E 11
I 11
#define	PW_AGE		(365L*24L*60L*60L)	/* max. age for a password */
E 11
#define	NAMZ		133			/* maximum size for a login name */
#define	TIMEOUT		60			/* seconds before screen clear while waiting */
#define	MINSLEEP	2			/* 2 is minimum recommended sleep time */
#define	MAIL_SEARCH	1			/* search for mail file and anounce mail */
I 11
#define	MAILSZ		32			/* only announce mail if size greater than this */
E 11
#define	CON_ID		':'			/* prefix for network host name */


D 2
readonly char	systemid[]	= SYSTEMID;
readonly char	motd[]		= "/etc/motd";
readonly char	maildir[]	= "/usr/mail/";
readonly char	ttydir[]	= "/dev/";
readonly char	bin_con[]	= "/bin/con";
E 2
I 2
char	systemid[]	= SYSTEMID;
char	motd[]		= "/etc/motd";
I 11
char	maildir[]	= "./";
E 11
D 8
char	maildir[]	= "/usr/mail/";
E 8
char	ttydir[]	= "/dev/";
char	bin_con[]	= "/bin/con";
E 2

/*
**	Environment variables
*/

D 2
readonly char	home[]		= "HOME=";
E 2
I 2
char	home[]		= "HOME=";
E 2
D 9
char	homedir[(sizeof home)+32];
E 9
I 9
char	homedir[(sizeof home)+64];
E 9
D 2
readonly char	shellv[]	= "SHELL=";
E 2
I 2
D 3
char	shellv[]	= "SHELL=";
E 2
char	shell[(sizeof shellv)+32];
E 3
D 2
readonly char	ttynenv[]	= "TTYNAME=";
E 2
I 2
char	ttynenv[]	= "TTYNAME=";
E 2
char	ttyn[(sizeof ttynenv)+LINESIZ];
D 2
readonly char	ttysenv[]	= "TTYSLOT=";
E 2
I 2
D 3
char	ttysenv[]	= "TTYSLOT=";
E 2
char	ttys[(sizeof ttysenv)+6];
D 2
readonly char	ttypenv[]	= "TERM=";
E 2
I 2
char	ttypenv[]	= "TERM=";
E 2
char	ttyp[(sizeof ttypenv)+20];
D 2
readonly char	lnamenv[]	= "LNAME=";
E 2
I 2
char	lnamenv[]	= "LNAME=";
E 2
char	lname[(sizeof lnamenv)+NAMZ];
extern
char	**environ;
char	*envinit[]	= { homedir, "PATH=:/bin:/usr/bin", /* "TZ=AEST-10AESST", */ ttyn, ttys, ttyp, lname, shell, 0 };
E 3
I 3
extern char **environ;
D 11
char	*envinit[]	= { homedir, "PATH=:/bin", ttyn, 0 };
E 11
I 11
char  *envinit[]	= { homedir, "PATH=:/bin", ttyn, 0 };
E 11
E 3


/*
**	Terminals configuration
*/

D 5
#ifdef	AGSM
E 5
#define	LOG		'#'
D 5
#define	TEKTRONICS	'g'
#define	LA36		'd'
#define	DIALUP		'u'
#define	LS120		'D'
#define	STRANSDATA	'T'
#define	TRANSDATA	't'
#define	VT52_5		'V'
#define	ELECTRIC	'S'
#define	QUME		'q'
#define	TELERAY		'W'
#define	COPS10		'8'	/* at 19200 baud */
#endif	AGSM

#ifdef	BASSER
#define	LOG		'#'
#define	FASTLOG		'*'
#define	TEKTRONICS	'T'
#define	LA36		'l'
/* #define	CDC713		'c' */
#define	DIABLO		('d'|T_STOPS)
#define	SDIABLO		('D'|T_STOPS)
/* #define	IMLAC		'i' */
/* #define	ASR33		'-' */
#define	NCR260		'N'
#define	ADM1_A		'a'
#define	TTY43		'3'
#define	VC404		'4'
#define	STEL1061	'5'
#define	TELERAY1061	'6'
#define	MTEL1061	't'
#define	FTEL1061	'7'
#define	TEL1062		'8'
#define	TVI920		'v'
#define	TVI912		'V'
#define	DIAL_IN		'0'
#endif	BASSER

#ifdef	EECF
#define	LOG		'#'
E 5
#define	FASTLOG		'4'
#define	VT05		'v'
#define	TEK4014		'T'
I 6
#define	TEKTRONICS	't'
E 6
#define	LA36		'd'
#define	ELECTRIC	'S'
#define	QUME5		'Q'
I 11
#define	LA120		'D'
E 11
D 4
#define	LA120		'D'
E 4
#define	DIALUP		'u'
D 4
#define	TELERAY		'W'
E 4
D 5
#endif	EECF
E 5


char	nlbel[]		= "\r\n\007";
D 2
readonly char	dumb[]		= "dumb";
E 2
I 2
D 5
char	dumb[]		= "dumb";
E 5
I 4
char	null[]		= "";
E 4
E 2


/*
**	Itab - terminal configuration table
*/

D 2
readonly struct	tab
E 2
I 2
struct	tab
E 2
{
	char	tname;		/* this table name */
	char	nname;		/* successor table name */
	short	iflags;		/* initial flags */
	short	fflags;		/* final flags */
	char	ispeed;		/* input speed */
	char	ospeed;		/* output speed */
D 4
	char	*message;	/* login message */
	char	*type;		/* terminal type */
E 4
I 4
	char	*lmesg;		/* login message */
	char	*pmesg;		/* anything that MUST be printed each time */
E 4
}
	itab[] =
{
#ifdef	DIAL_IN
/* table DIAL_IN-1 300,110 */
  {
	DIAL_IN, 1,
	ANYP+XTABS+CRMOD+CBREAK+HUPCL, ANYP+ECHO+XTABS+HUPCL,
	B300, B300,
D 4
	"\n\r\033;\007",
	"dialin"
E 4
I 4
	"\n\r\033;\007", null
E 4
  },

  {
	1, DIAL_IN,
	ANYP+XTABS+CRMOD+CBREAK+HUPCL, ANYP+ECHO+XTABS+HUPCL,
	B110, B110,
D 4
	nlbel,
	"dialin"
E 4
I 4
	nlbel, null
E 4
  },
# ifdef	TTY37

  {
	2, DIAL_IN,
	EVENP+XTABS+CRMOD+CBREAK+NL1+CR1+HUPCL, EVENP+ECHO+FF1+CR1+TAB1+NL1+HUPCL,
	B150, B150,
D 4
	"\n\r\033:\006\006\017",
	"37"
E 4
I 4
	"\n\r\033:\006\006\017", null
E 4
  },
# endif	TTY37
#endif	DIAL_IN
#ifdef	ASR33

/* table ASR33 -- ASR33 110 */
  {
	ASR33, ASR33,
	ANYP+XTABS+CRMOD+CBREAK+NL1+CR1, ANYP+ECHO+CRMOD+XTABS+CR1+LCASE,
	B110, B110,
D 4
	nlbel,
	"33"
E 4
I 4
	nlbel, null
E 4
  },
#endif
#ifdef	IBM2741

/* table IBM2741 -- 134_5 */
  {
	IBM2741, IBM2741,
	EVENP+CBREAK+NL1, EVENP+NL1,
	B134_5, B134_5,
D 4
	"\n",
	"2741"
E 4
I 4
	"\n", null
E 4
  },
#endif
#ifdef	VT05

/* table VT05 -- vt05 */
  {
	VT05,VT05,
	ANYP+XTABS+CRMOD+CBREAK+NL2, ANYP+NL2+ECHO+CRMOD,
	B2400, B2400,
D 4
	"\035\035\035\035\037\037\037\037",
	"vt05"
E 4
I 4
	"\035\035\035\035\037\037\037\037", null
E 4
  },
#endif
#ifdef	LOG

/* table LOG -- LOG device twixt here and remote UNIX sites .... */
  {
	LOG, LOG,
	ANYP+XTABS+CRMOD+CBREAK, ANYP+ECHO+XTABS+CRMOD,
D 5
#	ifdef	BASSER
		B1200, B1200,
#	else
E 5
D 11
		B4800, B4800,
E 11
I 11
	B4800, B4800,
E 11
D 5
#	endif	BASSER
E 5
D 4
	nlbel,
	"log"
E 4
I 4
	nlbel, null
E 4
  },
#endif
#ifdef	FASTLOG

/* table FASTLOG -- FASTLOG device */
  {
	FASTLOG, FASTLOG,
	ANYP+XTABS+CRMOD+CBREAK+NL1, ANYP+ECHO+XTABS+CRMOD+NL1,
D 5
#	ifdef	BASSER
	B2400, B2400,
#	else	BASSER
E 5
	B9600, B9600,
D 5
#	endif	BASSER
E 5
D 4
	nlbel,
	"log"
E 4
I 4
	nlbel, null
E 4
  },
#endif
#ifdef	LA36

/* table LA36 -- LA36 */
  {
	LA36, LA36,
	ANYP+XTABS+CRMOD+CBREAK, ANYP+XTABS+ECHO+CRMOD,
	B300, B300,
D 4
	nlbel,
	"la36"
E 4
I 4
	nlbel, null
E 4
  },
#endif	LA36
#ifdef	TTY43

/* table TTY43 -- TTY43 */
  {
	TTY43, TTY43,
	EVENP+XTABS+CRMOD+CBREAK, EVENP+XTABS+ECHO+CRMOD,
	B300, B300,
D 4
	nlbel,
	"43"
E 4
I 4
	nlbel, null
E 4
  },
#endif	TTY43
#ifdef	DIALUP

/* table DIALUP -- DIALUP */
  {
	DIALUP, DIALUP,
	ANYP+XTABS+CRMOD+CBREAK, ANYP+XTABS+ECHO+CRMOD,
	B300, B300,
D 4
	nlbel,
	dumb
E 4
I 4
	nlbel, null
E 4
  },
#endif
#ifdef	LS120

/* table LS120 -- LS120 */
  {
	LS120, LS120,
	ANYP+XTABS+CRMOD+CBREAK, ANYP+NL1+CR1+XTABS+ECHO+CRMOD,
	B1200, B1200,
D 4
	nlbel,
	dumb
E 4
I 4
	nlbel, null
E 4
  },
#endif
#ifdef	LA120

/* table LA120 -- LA120 */
  {
	LA120, LA120,
	ANYP+XTABS+CRMOD+CBREAK, ANYP+XTABS+ECHO+CRMOD,
	B1200, B1200,
D 4
	nlbel,
	dumb
E 4
I 4
	nlbel, null
E 4
  },
#endif
#ifdef	VT52_5

/* table VT52_5 -- vt52/5 */
  {
	VT52_5, VT52_5,
	ANYP+XTABS+CRMOD+CBREAK, ANYP+ECHO+CRMOD,
	B4800, B4800,
D 4
	nlbel,
	"vt52"
E 4
I 4
	nlbel, null
E 4
  },
#endif
#ifdef	COPS10

/* table COPS10 -- for COPS10 at 19200 */
  {
	COPS10, COPS10,
	ANYP+XTABS+CRMOD+CBREAK, ANYP+ECHO+CRMOD+XTABS,
	EXTB, EXTB,
D 4
	nlbel,
	vc404
E 4
I 4
	nlbel, null
E 4
  },
#endif
#ifdef	TELERAY

/* table TELERAY -- for TELERAY at 4800 */
  {
	TELERAY, TELERAY,
	ANYP+XTABS+CRMOD+CBREAK, ANYP+ECHO+CRMOD+XTABS,
	B4800, B4800,
D 4
	nlbel,
	dumb
E 4
I 4
	nlbel, null
E 4
  },
#endif
#ifdef	ELECTRIC

/* table ELECTRIC -- for ELECTRIC at 2400 */
  {
	ELECTRIC, ELECTRIC,
	ANYP+XTABS+CRMOD+CBREAK, ANYP+ECHO+CRMOD+XTABS,
	B2400, B2400,
D 4
	"\035\037\07",
	"serge"
E 4
I 4
	"\035\037\07", null
E 4
  },
#endif
#ifdef	DIABLO

/* table DIABLO-'D' -- Diablo Hyterm at 1200-300 baud */
#define	FLOWCNTRL	0	/* NO FLOW CONTROL */
#define	T_STOPS		0200		/* set tab stops on login */
  {
	DIABLO, SDIABLO,
	EVENP+XTABS+CRMOD+CBREAK+FLOWCNTRL, EVENP+FLOWCNTRL+CRMOD+ECHO,
	B1200, B1200,
D 4
	"\0332\033\t\001\0339\033B",
	"1620"
E 4
I 4
	"\0332\033\t\001\0339\033B", null
E 4
  },

  {
	SDIABLO, DIABLO,
	EVENP+XTABS+CRMOD+CBREAK, EVENP+CRMOD+ECHO,
	B300, B300,
D 4
	diablostr,
	diablo
E 4
I 4
	diablostr, null
E 4
  },
#endif
#ifdef	IMLAC

/* table IMLAC-9-10 -- IMLAC 9600-4800-300 baud */
  {
	IMLAC, 9,
	ANYP+XTABS+CRMOD+CBREAK, ANYP+XTABS,
	B9600, B9600,
D 4
	nlbel,
	"imlac"
E 4
I 4
	nlbel, null
E 4
  },

  {
	9, 10,
	ANYP+XTABS+CRMOD+CBREAK, ANYP+XTABS,
	B4800, B4800,
D 4
	nlbel,
	imlac
E 4
I 4
	nlbel, null
E 4
  },

  {
	10, IMLAC,
	ANYP+XTABS+CRMOD+CBREAK, ANYP+XTABS,
	B300, B300,
D 4
	nlbel,
	imlac
E 4
I 4
	nlbel, null
E 4
  },
#endif
#ifdef	NCR260

/* table NCR260 -- NCR260 needs inverted case and special delays */
  {
	NCR260, NCR260,
	EVENP+XTABS+CRMOD+CBREAK+CR2+INVCASE, EVENP+XTABS+ECHO+CRMOD+CR2+INVCASE,
	B300, B300,
D 4
	nlbel,
	"ncr"
E 4
I 4
	nlbel, null
E 4
  },
#endif	NCR260
#ifdef	ADM1_A

/* table ADM1_A -- ADM1_A needs special delays */
  {
	ADM1_A, ADM1_A,
	EVENP+XTABS+CRMOD+CBREAK+NL1, EVENP+XTABS+ECHO+CRMOD+NL1,
	B9600, B9600,
D 4
	"\033*\007",
	"adm1-a"
E 4
I 4
	"\033*\007", null
E 4
  },
#endif	ADM1_A
#ifdef	CDC713

/* table CDC713 -- CDC713 */
  {
	CDC713, CDC713,
	EVENP+XTABS+CRMOD+CBREAK, EVENP+XTABS+ECHO+CRMOD,
	B300, B300,
D 4
	"\030\007",
	"cdc713"
E 4
I 4
	"\030\007", null
E 4
  },
#endif	CDC713
#ifdef	TEKTRONICS

D 6
/* table TEKTRONICS -- tektronics at 4800bd */
E 6
I 6
/* table TEKTRONICS -- tektronics at 9600bd */
E 6
  {
	TEKTRONICS, TEKTRONICS,
D 6
	EVENP+XTABS+CRMOD+CBREAK+FF1, EVENP+CRMOD+XTABS+FF1+LCASE+ECHO,
	B4800, B4800,
E 6
I 6
	ANYP+XTABS+CRMOD+CBREAK+FF1, ANYP+CRMOD+XTABS+FF1+LCASE+ECHO,
	B9600, B9600,
E 6
D 4
	"\033\014\007",
	"4006"
E 4
I 4
D 16
	"\033\014\007", null
E 16
I 16
	"\033;\033\014\007", null
E 16
E 4
  },
#endif
#ifdef	TEK4014

/* table TEK4014 -- tektronics at 1200bd */
  {
	TEK4014, TEK4014,
	ANYP+XTABS+CRMOD+CBREAK+FF1, ANYP+CRMOD+XTABS+FF1+ECHO,
	B1200, B1200,
D 4
	"\033;\033\014\007",
	"4014"
E 4
I 4
	"\033;\033\014\007", null
E 4
  },
#endif
#ifdef	QUME

/* table QUME -- qume sprint printer at 300bd */
  {
	QUME, QUME,
	ANYP+XTABS+CRMOD+CBREAK, ANYP+ECHO+CRMOD+XTABS,
	B600, B600,
D 4
	nlbel,
	"qume-3"
E 4
I 4
	nlbel, null
E 4
  },
#endif
#ifdef	QUME5

/* table QUME5 -- qume sprint printer at 1200bd */
  {
	QUME5, QUME5,
	ANYP+XTABS+CRMOD+CBREAK, ANYP+ECHO+CRMOD,
	B1200, B1200,
D 4
	"\r\033\037\013\0332\033(08,16,24,32,40,48,56,64,72,80,88,96,A4,B2,C0,C8,D6,E4,F2.\n\007",
E 4
I 4
	"\r\n\007", "\033\037\013\0332\033(08,16,24,32,40,48,56,64,72,80,88,96,A4,B2,C0,C8,D6,E4,F2.",
E 4
		/* set to 12-pitch; clear tabs; set tabs every 8 */
D 4
	"qume-5"
E 4
  },
#endif
#ifdef	TRANSDATA

/* table TRANSDATA-'z' -- transdata at 300-2400bd */
  {
	STRANSDATA, TRANSDATA,
	EVENP+XTABS+CRMOD+CBREAK, EVENP+ECHO+CRMOD+XTABS,
	B300, B300,
D 4
	nlbel,
	dumb
E 4
I 4
	nlbel, null
E 4
  },
  {
	TRANSDATA, STRANSDATA,
	EVENP+XTABS+CRMOD+CBREAK, EVENP+ECHO+CRMOD+XTABS,
	B2400, B2400,
D 4
	nlbel,
	dumb
E 4
I 4
	nlbel, null
E 4
  },
#endif	TRANSDATA
#ifdef	VC404

/* table VC404 -- VC404 */
  {
	VC404, VC404,
	EVENP+XTABS+CRMOD+CBREAK+FF1, EVENP+XTABS+ECHO+CRMOD,
	B9600, B9600,
D 4
	"\030\014\007",
	"vc404"
E 4
I 4
	"\030\014\007", null
E 4
  },
#endif	VC404
#ifdef	TELERAY1061

/* table TELERAY1061 -- 1061 @ 2400 baud */
  {
	TELERAY1061, TELERAY1061,
	EVENP+XTABS+CRMOD+CBREAK, EVENP+ECHO+CRMOD,
	B2400, B2400,
D 4
	"\014\007",
	"t1061"
E 4
I 4
	"\014\007", null
E 4
  },
#endif	TELERAY1061
#ifdef	STEL1061

/* table STEL1061 -- 1061 @ 1200 baud */
  {
	STEL1061, STEL1061,
	EVENP+XTABS+CRMOD+CBREAK, EVENP+ECHO+CRMOD,
	B1200, B1200,
D 4
	"\014\007",
	t1061
E 4
I 4
	"\014\007", null
E 4
  },
#endif	STEL1061
#ifdef	MTEL1061

/* table MTEL1061 -- 1061 @ 4800 baud */
  {
	MTEL1061, MTEL1061,
	EVENP+XTABS+CRMOD+CBREAK, EVENP+ECHO+CRMOD,
	B4800, B4800,
D 4
	"\014\007",
	t1061
E 4
I 4
	"\014\007", null
E 4
  },
#endif	MTEL1061
#ifdef	FTEL1061

/* table FTEL1061 -- 1061 @ 9600 baud */
  {
	FTEL1061, FTEL1061,
	EVENP+XTABS+CRMOD+CBREAK, EVENP+ECHO+CRMOD,
	B9600, B9600,
D 4
	"\014\007",
	t1061
E 4
I 4
	"\014\007", null
E 4
  },
#endif	FTEL1061
#ifdef	TEL1062

/* table TEL1062 -- 1062 @ 2400 baud */
  {
	TEL1062, TEL1062,
	EVENP+XTABS+CRMOD+CBREAK, EVENP+ECHO+CRMOD,
	B2400, B2400,
	"\014\007\033G        \033F        \033F        \033F        \033F        \033F        \033F        \033F        \033F        \033F\r",
D 4
	"t1062"
E 4
I 4
	null
E 4
  },
#endif	TEL1062
#ifdef	TVI920

/* table TVI920 -- tvi920 @ 9600 baud */
  {
	TVI920, TVI920,
	EVENP+XTABS+CRMOD+CBREAK, EVENP+ECHO+CRMOD,
	B9600, B9600,
	"\032\007\0332        \0331        \0331        \0331        \0331        \0331        \0331        \0331        \0331        \0331\r",
D 4
	"tvi920"
E 4
I 4
	null
E 4
  },
#endif	TVI920
#ifdef	TVI912

/* table TVI912 -- tvi912 @ 9600 baud */
  {
	TVI912, TVI912,
	EVENP+XTABS+CRMOD+CBREAK, EVENP+ECHO+CRMOD,
	B9600, B9600,
	"\032\007\0332        \0331        \0331        \0331        \0331        \0331        \0331        \0331        \0331        \0331\r",
D 4
	"tvi912"
E 4
I 4
	null
E 4
  },
#endif	TVI912
};

#define	NITAB	(sizeof itab/sizeof itab[0])


/*
**	Miscellaneous data
*/

char		name[NAMZ];
short		upper;
short		lower;
struct sgttyb	tmode;
D 5
/*struct tchars	tchars	= { '\177', '\034', '\021', '\023', '\004', '\377' }; */
E 5
struct stat	ttystat;
char		*ttyname;
short		utmpslot;
char		*utmpaslot;
#ifdef	TTY_GROUP
unsigned	ttygmask;	/* store tty group mask for current terminal here */
#endif	TTY_GROUP

D 2
readonly char	utmpf[]	= UTMPF;
readonly char	wtmpf[]	= WTMPF;
E 2
I 2
char	utmpf[]	= UTMPF;
char	wtmpf[]	= WTMPF;
E 2
struct	pwent	pe;
struct	uwtmp	uwtmp;
struct	utmp	utmp;
char		shellname[DIRSIZ + 2];
jmp_buf		catchbuf;
char		timeout;

#define	EVR_DATA	1
#include	<evr.h>

D 5
/*
**	Limits to be announced
*/

E 5
union tlimu
{
	char	tl_vc;
	short	tl_vs;
	long	tl_vl;
};

D 5
struct tlim
{
	char *		tl_s;
	union tlimu *	tl_val;
	int		tl_size;
}
	tell_lim[] =
{
	 {"%ld disk units", (union tlimu *)&pe.pw_limits.l_dlimit, sizeof pe.pw_limits.l_dlimit}
	,{"%ld processes", (union tlimu *)&pe.pw_limits.l_plimit, sizeof pe.pw_limits.l_plimit}
	,{"max pages/process %ld", (union tlimu *)&pe.pw_limits.l_mplimit, sizeof pe.pw_limits.l_mplimit}
	,{"memory limit %ld pages", (union tlimu *)&pe.pw_limits.l_mlimit, sizeof pe.pw_limits.l_mlimit}
	,{"%ld printer pages/week", (union tlimu *)&pe.pw_pages, sizeof pe.pw_pages}
	,{"%ld printer pages used", (union tlimu *)&pe.pw_pgused, sizeof pe.pw_pgused}
};
#define		NTELL	(sizeof tell_lim/sizeof tell_lim[0])

long		tlmasks[] =
{
	 0
	,0xffl
	,0xffffl
	,0xffffffl	/* ?! */
	,0xffffffffl
};

E 5
D 11
extern char	_sobuf[];
E 11
extern char *	sbrk();
extern char *	strcpy();
extern char *	strncpy();
extern char *	strcat();
extern char *	strncat();
extern char *	strrchr();
extern char *	ctime();
extern time_t	time();
#define		NULLSTR		(char *)0





/*
**	Getty
*/

main(argc, argv)
	int			argc;
	char			**argv;
{
	register struct tab	*tabp;
	register		tname;
	register		i;
I 2
D 5
#ifdef	BASSERVAX
E 2
	struct utsname		utsname;
I 2
#endif	BASSERVAX
E 5
E 2
	int			catchalrm();
I 11
	char			outbuf[BUFSIZ];
E 11

	tname = *argv[1];
	ttyname = argv[2];
	utmpaslot = argv[3];
	utmpslot = atoi(argv[3]);
D 11
	setbuf(stdout, _sobuf);
E 11
I 11
	setbuf(stdout, outbuf);
E 11

#	ifdef	TTY_GROUP
	if ( argc == 5 )
	{
		ttygmask = 0177777; /* assume all unless find matching group */
		for ( i = 0 ; i < NTTYGROUPS ; i++ )
			if ( *argv[4] == tty_groups[i].tg_char )
			{
				ttygmask = tty_groups[i].tg_mask;
				break;
			}
	}
	else
#	else	TTY_GROUP
	if ( argc != 4 )
#	endif	TTY_GROUP
	{
		sleep(10);
		exit(1);	/* init had better not call getty wrongly */
	}

	sbrk(SSIZ);		/* initial strings area */
	fstat(0, &ttystat);	/* get dev of tty */
I 2
D 5
#ifdef	BASSERVAX
E 2
	uname(&utsname);	/* get version */
I 2
#endif	BASSERVAX
E 5
E 2

	for (;;)
	{
		for ( tabp = itab ; tabp < &itab[NITAB] ; tabp++ )
#			ifndef	T_STOPS
			if ( tabp->tname == tname )
#			else
			if ( (tabp->tname & 0177) == tname )
#			endif	T_STOPS
				break;

		if ( tabp >= &itab[NITAB] )
			tabp = itab;

		tmode.sg_ispeed = tabp->ispeed;
		tmode.sg_ospeed = tabp->ospeed;
		tmode.sg_flags = tabp->iflags;
		tmode.sg_erase = 0;
		tmode.sg_kill = 0;

		stty(0, &tmode);

D 5
#ifdef	BASSERVAX
		printf("%s%s %s/%s\r\nLogin: "
D 4
			,tabp->message
E 4
I 4
			,tabp->lmesg
E 4
			,systemid
			,utsname.sysname
			,utsname.release
		      );
#else
E 5
D 4
		printf("%s%s login: ", tabp->message, systemid);
E 4
I 4
		printf("%s%s login: ", tabp->lmesg, systemid);
E 4
D 5
#endif	BASSERVAX
E 5

		if ( tabp->ospeed >= B1200 )
			if ( setjmp(catchbuf) == 0 )
			{
				signal(SIGALRM, catchalrm);
				timeout++;
			}
			else
D 4
				printf("%s", tabp->message);
E 4
I 4
				printf("%s", tabp->lmesg);
E 4

		if ( getname() )
		{
			tmode.sg_flags = tabp->fflags;
			if ( upper )
				tmode.sg_flags |= LCASE;
			if ( lower )
				tmode.sg_flags &= ~LCASE;
D 5
#			ifdef	BASSER
			tmode.sg_erase = tmode.sg_flags&LCASE ? '#' : CERASE;
#			else
E 5
			tmode.sg_erase = CERASE;
D 5
#			endif	BASSER
E 5
			tmode.sg_kill = CKILL;
			stty(0, &tmode);
#			ifdef	T_STOPS
			if ( tabp->tname & T_STOPS )	/* set tab stops */
			{
				for ( i = 9 ; i < 0200 ; i += 8 )
					printf("\033\t%c\0331", i);
				putchar('\n');
			}
#			endif	T_STOPS

			if ( name[0] == CON_ID ) /* this should really be done by a 'net getty' */
				con(&name[1]);
			else
D 4
				login(tabp->type);
E 4
I 4
				login(tabp->pmesg);
E 4
			fflush(stdout);
			sleep(MINSLEEP);
			continue;
		}
		sleep(MINSLEEP);
		tname = tabp->nname & 0177;
	}
}



catchalrm()
{
	timeout = 0;
	alarm(0);
	longjmp(catchbuf, 1);
}



/*
**	getname reads name from tty doing erase and kill processing
*/

getname()
{
	register char *	np;
	register	c;
	char		cs;

	upper = 0;
	lower = 0;
	np = name;
	do
	{
		fflush(stdout);
		if ( timeout )
			alarm(TIMEOUT);
		while ( read(0, &cs, 1) <= 0 )
			sleep(MINSLEEP);
		if ( timeout )
			alarm(0);
		if ( (c = cs&0177) == 0 || c == CEOT )
			return 0;
		putchar(c);
		if ( c>='a' && c <='z' )
			lower++;
		else if ( c >= 'A' && c <= 'Z' )
		{
			upper++;
			c += 'a'-'A';
		}
		else
		if ( c == CERASE )
		{
			if ( np > name )
				np--;
			if ( lower && CERASE == '\b' )
				printf(" \b");
			continue;
		}
		else
		if ( c == CKILL )
		{
			np = name;
			continue;
		}
		*np++ = c;
	}
	while
		( c != '\n' && c != '\r' && np <= &name[NAMZ] );

	*--np = 0;
	if ( np == name )
		return 0;
	return 1;
}



/*
**	If netname not NETID, exec "con" to find next host.
*/

con(netname)
	char *	netname;
{
	if ( strcmp(netname, NETID) == 0 )
		return;

	pe.pw_uid = NETUID;
	if ( getpwlog(&pe, (char *)0, 0) == PWERROR )
	{
		printf("net uid unknown!.\n");
		return;
	}

	if ( !(pe.pw_tmask & ttygmask) )
	{
		printf("network access denied.\n");
		return;
	}

	admin(netname, time((long *)0), 0);
	user(netname);
	pwclose();
	fflush(stdout);
	execl(bin_con, bin_con+5, netname, (char *)0);
	perror(bin_con);
	printf("exec failed!\n");
}



/*
**	Login - returns to getty on failure
*/

D 4
login(ttype)
	char *		ttype;
E 4
I 4
login(s)
char *s;
E 4
{
	register char	*np;
	register	i;
	time_t		ttime;

	/*
	**	extract user particulars from password file
	*/
	pe.pw_strings[LNAME] = name;
	{
		register	t;
		extern char	end;

		for ( t = sbrk(0)-&end, i = SSIZ ; ; t += SSIZ )
		{
			if ( t < i && sbrk(SSIZ) == (char*)SYSERROR )
			{
				perror("memory");
				brk(&end);
D 13
				pwclose();
E 13
				goto out;
			}
			if ( (i = getpwuid(&pe, &end, t)) == PWERROR )
			{
D 5
#ifdef	BASSERVAX
				/*
				**	User not found, but don't let on
				*/
				pe.pw_pword[0] = '-';
				pe.pw_pword[1] = 0;	/* impossible encryption */
				break;
#else
E 5
				printf("Who?\n");
				return(0);
D 5
#endif	BASSERVAX
E 5
			}
			if ( i < t )
				break;
		}

D 13
		pwclose();
E 13
	}

	/*
	**	if password is non-null, verify it
	*/
I 4

	printf(s);	/* critical string, if any */
E 4
	if ( *(np = pe.pw_pword) )
	{
		register char	*namep;
		int		sflags;
		char		pwbuf[PASSWDZ];
		extern char *	crypt();

		sflags = tmode.sg_flags;
		if ( sflags & ECHO )
		{
			tmode.sg_flags &= ~ ECHO;
			stty(0, &tmode);
		}
		printf("Password: ");
		fflush(stdout);
		if ( setjmp(catchbuf) )
		{
			printf("timeout\n");
			return;
		}
		else
		{
			signal(SIGALRM, catchalrm);
			alarm(TIMEOUT);
		}
		namep = pwbuf;
		while ( (i = read(0, namep, 1)) == 1 && *namep != '\n')
			if (namep < &pwbuf[PASSWDZ-1])
			{
				alarm(TIMEOUT);
				namep++;
			}
			else
			{
				alarm(0);
				printf("\ntoo long!\n");
				return;
			}
		alarm(0);
		if ( i <= 0 )
			return;
		*namep = '\0';
		if ( sflags & ECHO )
		{
			tmode.sg_flags = sflags;
			stty(0, &tmode);
		}
		putchar('\n');
		namep = crypt(pwbuf, np);
		for ( i = 0 ; i<CRYPTLEN ; i++ )
			if ( *namep++ != *np++ )
			{
				printf("Wrong password.\n");
				return;
			}
	}

	/*
	**	Set up environment
	*/

	strncat(strcpy(homedir, home), pe.pw_strings[DIRPATH], (sizeof homedir)-(sizeof home));
	strcat(strcpy(ttyn, ttynenv), ttyname);
D 3
	strcat(strcpy(ttys, ttysenv), utmpaslot);
	strcat(strcpy(lname, lnamenv), name);
	strcat(strcpy(ttyp, ttypenv), ttype);
E 3
	environ = envinit;

	/*
	**	copy the message-of-the-day to keep the user guessing...
	*/
	if ((i = open(motd, 0)) != SYSERROR)
	{
		char	mbuf[128];
		extern	catch();

		if ( setjmp(catchbuf) )
			putchar('\n');
		else
		{
			fflush(stdout);
			signal(SIGINT, catch);
			while ( write(1, mbuf, read(i, mbuf, sizeof mbuf)) == sizeof mbuf );
		}
		signal(SIGINT, SIG_IGN);
		close(i);
	}

	ttime = time((long*)0);

	if ( pe.pw_limits.l_uid )
	{
		if ( pe.pw_limits.l_flags & NOLOGIN )
		{
			printf("Login denied:- \"%s\"\n", evr[pe.pw_reason>=EVR_N?0:pe.pw_reason]);
			printf("Please consult the duty tutor\n");
			goto out;
		}

#		ifdef	TTY_GROUP
		if ( !(pe.pw_tmask&ttygmask) )
		{
			printf("You are not authorized to use this terminal\n");
			goto out;
		};

#		endif	TTY_GROUP
		if ( pe.pw_limits.l_flags & CONNECTLIM )
		{
			register	j;
			register	c;
			register	k;

			for ( i = 0, k = 0 ; k < NCONLIMS && i < CLASSMASKSIZE ; i++ )
				for ( j = 0, c = pe.pw_limits.l_cmask[i] ; k < NCONLIMS && j < BITSINMASK ; j++, k++, c <<= 1 )
					if ( c & (1<<(BITSINMASK-1)) )
					{
						if ( pe.pw_contime > (k = conlims[i*BITSINMASK+j]) )
						{
							struct tm	*tp;

							printf("Connect time limit of %ld minutes exceeded by %ld minutes\n"
								,k/60
								,(pe.pw_contime-k)/60
							);
D 7
							tp = localtime(&ttime);
E 7
I 7
							tp = localtime(ttime);
E 7
							if ( tp->tm_hour >= CONINHR && tp->tm_hour < CONOUTHR
								&& tp->tm_wday >= CONINWDAY && tp->tm_wday < CONOUTWDAY )
								goto out;
						}
						else
							printf("%ld minutes connect time available\n", (k-pe.pw_contime)/60);

						k = NCONLIMS;
					}
		}

		/*
		**	get limits from system, if they already exist
		*/
		if ( limits(&pe.pw_limits, L_OTHLIM)!=SYSERROR )
		{
			printf("You already have %d process%srunning\n"
				,pe.pw_limits.l_refcount
				,pe.pw_limits.l_refcount == 1 ? " " : "es "
				);
		}
		else
		{
#			ifndef	AUSAMSCHD
			int	oldwarn = pe.pw_warn;

#			endif	AUSAMSCHD
			/*
			**	Warn user about excessive disk usage
			*/

			if ( pe.pw_limits.l_dlimit )
			{
				printf("DISK USAGE: %d units\n", pe.pw_limits.l_duse );

				if ( pe.pw_limits.l_duse > pe.pw_limits.l_dlimit )
				{
					printf("\n\t%3.3s WARNING - disc limit of %d units exceeded by %d\n"
						,&"1st2nd3rd   "[pe.pw_warn*3]
						,pe.pw_limits.l_dlimit
						,pe.pw_limits.l_duse-pe.pw_limits.l_dlimit
					      );
	
					if ( ++pe.pw_warn > NDLIMWARN
						|| pe.pw_limits.l_duse > (pe.pw_limits.l_doverflw+pe.pw_limits.l_dlimit)
					   )
					{
						printf("\t-- no more disc space allowed\n");
						pe.pw_warn = NDLIMWARN;
						pe.pw_limits.l_flags |= DLIMIT;
					}
					else
					{
						i = NDLIMWARN - pe.pw_warn;
						printf("\tyou have %d warning%sleft\n"
							,i
							,i==1?" ":"s "
						      );
						pe.pw_limits.l_flags &= ~DLIMIT;
					}
					putchar('\n');
				}
				else
				{
					pe.pw_warn = 0;
					pe.pw_limits.l_flags &= ~(DLIMIT|DAWARN);
				}

			}
			else
			{
				pe.pw_warn = 0;
				pe.pw_limits.l_flags &= ~DLIMIT;
			}

#			ifndef	AUSAMSCHD
			if ( pe.pw_warn != oldwarn )
D 13
			{
E 13
				updtpwent(&pe);
D 13
				pwclose();
			}
E 13
#			else	AUSAMSCHD

			/*
			**	Decay usage by time since last access.
#			ifndef	vax
			**	YES, it could be done better with
			**	floating point but the approx used
			**	here is pretty good and more reliable
			**	than dec FPU.
#			endif	vax
			*/

#			ifdef	vax
			if ( (i = (ttime - pe.pw_extime) / 4) > 0 )
			{
				extern double	pow();

				pe.pw_limits.l_usage = pe.pw_limits.l_usage * pow(USAGEK, (float)i);
				if ( pe.pw_limits.l_usage < MINUSAGE )
					pe.pw_limits.l_usage = MINUSAGE;
#			else	vax
			if ( (i = (ttime - pe.pw_extime) / (60*60)) >= 0 )
			{
				register unsigned	u;
				u = decays[i >= DECAYSIZ ? DECAYSIZ-1 : i ];
	
				if ( pe.pw_limits.l_usage > 0xffff )
					pe.pw_limits.l_usage = pe.pw_limits.l_usage
								- ((pe.pw_limits.l_usage / u) * i * DECAYMULT);
				else
					pe.pw_limits.l_usage = pe.pw_limits.l_usage
								- ((pe.pw_limits.l_usage * i * DECAYMULT) / u);
				if ( pe.pw_limits.l_usage < 0 )
					pe.pw_limits.l_usage = 0;
#			endif	vax
			}

			updtpwent(&pe);
D 13
			pwclose();
E 13
#			endif	AUSAMSCHD
		}
	
D 5
		/*
		**	tell limits
		*/
		{
			register struct tlim	*tlp;
			register long		val;
			register		f = 0;

			for ( tlp = tell_lim ; tlp < &tell_lim[NTELL] ; tlp++ )
				if ( val = (tlp->tl_val->tl_vl & tlmasks[tlp->tl_size]) )
				{
					if ( !f )
						printf("LIMITS: ");
					else
						if ( (f%3) == 0 )
							printf(",\n\t");
						else
							printf(", ");
					printf(tlp->tl_s, val);
					f++;
				}

			if ( f )
				printf(".\n");
		}
E 5
#		ifdef	AUSAMSCHD

		/*
		**	tell share
		*/
		{
			register float	totshare;
			extern double	gtotshare();

			totshare = gtotshare();
			totshare += pe.pw_limits.l_shares / pe.pw_limits.l_usage;
			printf("Your share is %.2f%%.\n", 100 * pe.pw_limits.l_shares / (totshare * pe.pw_limits.l_usage) );
		}
#		endif	AUSAMSCHD
	}

	/*
	**	move over to the user's home directory
	*/
	if ( chdir(pe.pw_strings[DIRPATH]) == SYSERROR )
	{
		printf("Your directory is unavailable. Please consult the duty tutor\n");
		goto out;
	}

	/*
	**	make login entries in utmp & wtmp files
	*/

	admin(name, ttime, 1);

	/*
	**	print date
	*/
D 7
	printf(ctime(&ttime));
E 7
I 7
	printf(ctime(ttime));
E 7

#	ifdef	MAIL_SEARCH
	/*
	**	tell if any mail is waiting
	*/
	{
I 11
		char		mailf[(sizeof maildir)+DIRSIZ];
E 11
D 8
		char		mailf[(sizeof maildir)+DIRSIZ];
E 8
		struct stat	statb;

D 8
		strcat(strcpy(mailf, maildir), name);

		if ( stat(mailf, &statb) != SYSERROR)
E 8
I 8
D 11
		if ( stat(".mail", &statb) != SYSERROR)
E 11
I 11
		strcat(strcpy(mailf, maildir), ".mail");

		if ( stat(mailf, &statb) != SYSERROR && statb.st_size > MAILSZ)
E 11
E 8
			printf("You have mail.\n");
	}
#	endif	MAIL_SEARCH

	nice(-100);
	nice(20);
	nice(0);
	umask(077);

	/*
	**	Now become the user (and lose root privileges)
	*/
	if ( pe.pw_limits.l_uid )
		user(name);

/*	for ( i = 3 ; i<15 ; i++ )
**		close(i);
*/

	/*
	**	Become user's shell
	*/
	if ( (pe.pw_limits.l_flags & NEWPASSWD) || (pe.pw_pword[0] != '\0' && pe.pw_limits.l_uid > COMMONUSERS && pe.pw_age < (ttime - PW_AGE)) )
	{
		printf("Your password has expired, choose another one.\n");
		np = "/bin/passwd";
	}
	else
	if ( (np = pe.pw_strings[SHELLPATH]) == 0 || *np == '\0' )
		np = "/bin/sh";

D 3
	strcat(strcpy(shell, shellv), np);
E 3

	fflush(stdout);
	signal(SIGQUIT, SIG_DFL);
	signal(SIGINT, SIG_DFL);
I 13
	pwclose();
E 13

	{
		register char *	sp;

		execl(np, strncat(strcpy(shellname, "-"), (sp = strrchr(np, '/'))==NULLSTR?np:sp+1, DIRSIZ+1), 0);
	}

	printf("No Shell! --");
	fflush(stdout);
	perror(np);
	sleep(10);
	exit(1);

out:
	fflush(stdout);
	sleep(10);
}



catch(sig)
{
	signal(sig, SIG_IGN);
	longjmp(catchbuf, sig);
}



/*
**	Make admin. entries in utmp and wtmp files,
**	give user control of tty.
*/

admin(lname, ttime, others)
	char *		lname;
	time_t		ttime;
	int		others;
{
	register char	*np;
	{
		register char	*namep;
		register	i;

		for ( i = (sizeof utmp.ut_name)+1 , np = utmp.ut_name , namep = lname ; --i && (*np++ = *namep++) ; );
		if ( !i && *namep )	/* name too big for field */
			utmp.ut_name[0] = '\0';

		strncpy(utmp.ut_line, ttyname, sizeof utmp.ut_line);
	}

	utmp.ut_ttyid = ttystat.st_rdev;
	utmp.ut_uid = pe.pw_limits.l_uid;
	utmp.ut_time = ttime;
	utmp.ut_pgrp = getpid();

	uwtmp.uw_type = U_TYPE;
	if ( ttystat.st_rdev )
		np = ttyname + strlen(ttyname) - 2;
	else
		np = "co";
	uwtmp.uw_ttyid[0] = *np++;
	uwtmp.uw_ttyid[1] = *np;
	uwtmp.uw_uid = pe.pw_limits.l_uid;
	uwtmp.uw_logintime = ttime;

	{
		register	f;

		if ((f = open(utmpf, O_WRITE)) != SYSERROR)
		{
			lseek(f, (long)(utmpslot*(sizeof utmp)), 0);
			write(f, (char *)&utmp, (sizeof utmp));
			close(f);
		}

		if ((f = open(wtmpf, O_WRITE|O_APPEND)) != SYSERROR)
		{
			write(f, (char *)&uwtmp, (sizeof uwtmp));
			close(f);
		}
	}

	/*
	**	give user control of tty
	*/
	{
		char	tty[(sizeof ttydir)+(sizeof utmp.ut_line)];

		strncat(strcpy(tty, ttydir), ttyname, sizeof utmp.ut_line);

		chown(tty, pe.pw_limits.l_uid, DAEMONGID);	/* daemon processes can write to tty */
		if ( others )
D 10
			chmod(tty, 0621);	/* write by others not allowed except via "write" which knows about 'x' bit */
E 10
I 10
D 11
			chmod(tty, 0620);	/* allow write by group */
E 11
I 11
			chmod(tty, 0620);	/* write by others not allowed */
E 11
E 10
	}
}



/*
**	Become the user
*/

user(lname)
	char *		lname;
{
	if ( limits(&pe.pw_limits, L_SETLIM) == SYSERROR )
	{
		fflush(stdout);
		perror(lname);

		/*
		**	At this point we must tidy up a potential accounting mess
		*/
		{
			register	f;

			if ( (f = open(utmpf, O_WRITE))!=SYSERROR )
			{
				lseek(f, (long)(utmpslot*(sizeof utmp)), 0);
				utmp.ut_line[0] = 0;	/* flag */
				write(f, (char*)&utmp, sizeof utmp);
				close(f);
			}

			if ( (f = open(wtmpf, O_WRITE|O_APPEND))!=SYSERROR )
			{
				uwtmp.uw_type = O_TYPE;	/* instant log-off ! */
				write(f, (char*)&uwtmp, sizeof uwtmp);
				close(f);
			}
		}

		sleep(10);
		exit(1);
		return;
	}

	if ( pe.pw_limits.l_dlimit )
		ulimit(2, pe.pw_limits.l_dlimit + pe.pw_limits.l_doverflw);	/* max size of any one (sparse) file */
	setgid(pe.pw_gid);
	setuid(pe.pw_limits.l_uid);
}
E 1
