/*
 *
 *	UNIX debugger
 *
 */

#include "defs.h"


char		BADNAM[];
char		BADMAG[];

struct map	txtmap;
struct map	datmap;
struct symslave	*symvec;
int		wtflag;
int		fcor;
int		fsym;
long int	maxfile;
long int	maxstor;
long int	txtsiz;
long int	datsiz;
long int	datbas;
long int	stksiz;
char		*errflg;
int		magic;
long int	symbas;
long int	symnum;
long int	entrypt;

int		argcount;
int		signo;
unsigned	corhdr[512];
unsigned	*endhdr = &corhdr[512];

char		*symfil	= "a.out";
char		*corfil = "core";

#define TXTHDRSIZ	(sizeof(txthdr))

setsym()
{
	int relflg;
	int symval, symflg;
	struct symslave	*symptr;
	struct symtab *symp;
	unsigned txthdr[8];

	fsym = getfile(symfil, 1);
	txtmap.ufd = fsym;
	if (read(fsym, txthdr, TXTHDRSIZ) == TXTHDRSIZ)
	{
		magic = txthdr[0];
		if (magic != 0411 && magic != 0410 && magic != 0407 && magic != 0405)
			magic = 0;
		else
		{
			symnum = txthdr[4] / SYMTABSIZ;
			txtsiz = txthdr[1];
			datsiz = txthdr[2];
			symbas = txtsiz + datsiz;
			txtmap.b1 = 0;
			txtmap.e1 = (magic == 0407 ? symbas : txtsiz);
			txtmap.f1 = TXTHDRSIZ;
			txtmap.b2 = datbas = (magic == 0410 ? round(txtsiz, TXTRNDSIZ) : 0);
			txtmap.e2 = txtmap.b2 + (magic == 0407 ? symbas : datsiz);
			txtmap.f2 = TXTHDRSIZ + (magic == 0407 ? 0 : txtmap.e1);
			entrypt = txthdr[5];
			relflg = txthdr[7];
			if (relflg != 1)
				symbas =<< 1;
			symbas += TXTHDRSIZ;
			/*
			 * set up symvec
			 */
			symvec = sbrk(shorten((1 + symnum)) * sizeof (struct symslave));
			if ((symptr = symvec) == -1)
			{
				printf("%s\n", BADNAM);
				symptr = symvec = sbrk(sizeof (struct symslave));
			}
			else
			{
				symset();
				while ((symp = symget()) && errflg == 0)
				{
					symval = symp->symv;
					symflg = symp->symf;
					symptr->valslave = symval;
					if (symflg >= 041 || (symflg >= 02 && symflg <= 04))
						symptr->typslave = ((symflg & 07) >= 3 ? DSYM : (symflg & 07));
					else
						symptr->typslave = NSYM;
					symptr++;
				}
			}
			symptr->typslave = ESYM;
		}
	}
	if (magic == 0)
		txtmap.e1 = maxfile;
}

setcor()
{
	fcor = getfile(corfil, 2);
	datmap.ufd = fcor;
	if (read(fcor, corhdr, ctob(USIZE)) == ctob(USIZE))
	{
		txtsiz = corhdr->u_tsize << 6;
		datsiz = corhdr->u_dsize << 6;
		stksiz = corhdr->u_ssize << 6;
		datmap.b1 = datbas = (magic == 0410 ? round(txtsiz, TXTRNDSIZ) : 0);
		datmap.e1 = (magic == 0407 ? txtsiz : datmap.b1) + datsiz;
		datmap.f1 = ctob(USIZE);
		datmap.b2 = maxstor - stksiz;
		datmap.e2 = maxstor;
		datmap.f2 = ctob(USIZE) + (magic == 0410 ? datsiz : datmap.e1);
		if (magic && magic != corhdr[0].u_exdata.ux_mag)
		{
			register unsigned *up;

			/*
			 * try to be clever - if this is a system core file
			 * (e.g. /dev/mem), words 0, 2, 4, 6, 8, 10, 12,
			 * and 14 will contain the address of trap.
			 */
			up = (unsigned *)corhdr;
			if (up[0] != up[2] || up[4] != up[6] ||
			    up[8] != up[10] || up[12] != up[14] ||
			      up[3] != 0340 || up[5] != 0341 || up[15] != 0346)
				printf("%s\n", BADMAG);
		}
	}
	else
		datmap.e1 = maxfile;
}

create(f)
char *f;
{
	int fd;
	if ((fd = creat(f, 0644)) >= 0)
	{
		close(fd);
		return(open(f, wtflag));
	}
	else
		return(-1);
}

getfile(filnam, cnt)
char *filnam;
{
	register int fsym;

	if (!eqstr("-", filnam))
	{
		fsym = open(filnam, wtflag);
		if (fsym < 0 && argcount > cnt)
		{
			if (wtflag)
				fsym = create(filnam);
			if (fsym < 0)
				printf("cannot open `%s'\n", filnam);
		}
	}
	else
		fsym = -1;
	return(fsym);
}
