/*
**	Receive protocol handler
*/

#include	"log.h"
#include	"proto.h"
#include	"err.h"
#include	"bytes.h"
#include	"rep.h"
#include	"list.h"


rproto(local, remote)
{
	register listp		lp;
	register unsigned	seq;
	register		nextseq = 0;
	register listp		op;
	register		retrys = 0;
	int			size;
	int			count = 0;

	filesize = 0;
	starting = 1;
	strclr((char *)activelist, sizeof activelist);

	while ( (seq = (unsigned)getblk(remote, &size)) <= MAXSEQ )
		if ( (lp = inlist(seq)) == (listp)0 )
		{
			if ( seq != nextseq )
			{
#				ifdef	DEBUG
				printf("seq=%d, expected=%d\nbuf=<%.*s>\n", seq, nextseq, DATAZ, buf+HEADER);
#				endif	DEBUG
				errs[E_OUTSEQ].e_count++;
				if ( retrys++ >= NBUFS )
					return 1;
			}
			else
			{
				retrys = 0;
				if ( ++nextseq > MAXSEQ )
					nextseq = 0;
				if ( (lp = enter(seq)) == (listp)0 )
				{
					errs[E_IGNERR].e_count++;
					return 1;
				}
				if ( (op = inlist(seq==0?MAXSEQ:seq-1)) == (listp)0 )
				{
					if ( count )
					{
						errs[E_SKPSEQ].e_count++;
						return 1;
					}
					lp->l_addr = 0;
				}
				else
					lp->l_addr = op->l_addr + op->l_size;
				lp->l_size = size;

				count++;
write_l:
				if ( (crc(lp) && ++errs[E_CRC].e_count)
					|| (( lseek(local, lp->l_addr, 0) == SYSERROR
						|| write(local, (char *)buf+HEADER, size) != size
					    ) && ++errs[E_WRITE].e_count
					   )
				   )
				{
					/* errs[E_NAKS].e_count++; */
					lp->l_state = err_st;
					nak(seq, remote);
				}
				else
				{
					filesize += size;
					lp->l_state = ok_st;
					ack(seq, remote);
				}
			}
		}
		else
			if ( lp->l_state == ok_st )
				ack(seq, remote);
			else
				goto write_l;

	for ( lp = activelist ; lp < &activelist[NBUFS] ; lp++ )
		if ( lp->l_state == err_st )
			errs[E_IGNERR].e_count++;

	return seq != (unsigned)R_EOF;
}
