;;;	/ p o p / u s r / l i b / t r u t h t a b l e . p
;;;	Aaron Sloman	March 1978
;;; Given a number N, the function truthtable returns a list of lists,
;;; each being a list of N truth-values.  So if N = 1 the result is
;;; [[<true>][<false>]] whereas if N is 2, the result is
;;; [[<true> <true>][<true> <false>][<false> <true>][<false> <false>]]

;;; used in /pop/usr/lib/logic.p

function truthtable(n);
   function add(vv,ll);
	;;; given a list of combinations of truth-vvues, and a new truth-vvue
	;;; make a new list. E.g. given [ [T] [F] ] and "F", make the list
	;;; [ [F T] [F F] ]
	maplist(ll, lambda(ll); vv::ll end)
   end;

	if	n == 0
	then	[[]]
	else	vars ll;
		truthtable(n-1) ->ll;
		add(true,ll) <> add(false,ll)
	close
end;

