;;;	/ p o p / u s r / l i b / s e e l i n e s . p
;;;		by Aaron Sloman.
;;; commented version overwritten in error - 26 aug 2977
;;; see the SEELINES and PICTURES demos.
Uses database turtle;
function element (n, list);
  if	n == 1
  then	hd(list)
  else	element(n-1, tl(list))
  close;
end;
function scan (func);
  vars xmax ymax;
  element(2, fnprops(picture)) ->xmax;
  element(4, fnprops(picture)) ->ymax;
  0 ->yposition;
 vars xposition yposition;
 for	1->yposition
 step	1+yposition->yposition
 till	yposition>ymax
 then
	for	1->xposition
	step	1+xposition ->xposition
	till	xposition>xmax
	then	func()
	close
 close
end;
function here;
	[^xposition ^yposition]
end;
function  columnof (point);
  hd(point);
end;
function rowof (point);
  element(2,point);
end;
function rightdiagof (point);
  vars x y;
  dl(point) ->y ->x;
  y - x + element(2,fnprops(picture))
end;
function leftdiagof (point);
  vars x y;
  dl(point) ->y ->x;
  x + y
end;
function colhere;
  picture(xposition,yposition)
end;
function spacehere;
  colhere() == space
end;
function addtolist (key, n, item);
	vars list pattern;
	present([^key ^n ?list]) ->pattern;
	if	pattern
	then	item::list ->hd(tl(tl(pattern)))
	else	[^item] ->list;
		add([^key ^n ^list])
	close;
end;
function recordpoint (point);
	addtolist("row", rowof(point), point);
	addtolist("col", columnof(point), point);
	addtolist("leftdiag", leftdiagof(point), point);
	addtolist("rightdiag", rightdiagof(point), point);
end;
function testhere;
	unless	spacehere()
	then	recordpoint(here())
	close
end;
vars minlinelength;
3 ->minlinelength;
function toonearforline(point1,point2);
 vars x1 x2 y1 y2;
 dl(point1) ->y1 ->x1;
 dl(point2) ->y2 ->x2;
 abs(x1 -x2) < minlinelength and abs(y1 -y2) < minlinelength
end;
function nextto(point1,point2);
 vars minlinelength;
 2 ->minlinelength;
 toonearforline(point1,point2)
end;
function candidateline (end1, end2);
	unless equal(end1,end2) or toonearforline(end1,end2)
	then	[^end1 ^end2]
	close
end;
function tryfindlines (pointlist, previouspoint, previousend);
  if	pointlist==[]
  then	candidateline(previousend, previouspoint)
  elseif	nextto(hd(pointlist), previouspoint)
  then
	tryfindlines(tl(pointlist), hd(pointlist), previousend);
  else
	candidateline(previousend, previouspoint);
	tryfindlines(tl(pointlist), hd(pointlist), hd(pointlist))
  close
end;
function findendsoflines (pointlist);
	[% tryfindlines(tl(pointlist), hd(pointlist), hd(pointlist)) %]
end;
function recordline (ends, orientation);
	vars line;
	[line ^orientation ^^ends] -> line;
	add(line);
end;
function findlines (orientation);
	vars n pointlist lineends;
	foreach [^orientation ?n ?pointlist]
	then
		findendsoflines(pointlist) -> lineends;
		unless	lineends==[]
		then	applist(lineends, recordline(%orientation%))
		close;
	close;
	remove([^orientation ==]);
end;
function findalllines (orientations);
  applist(orientations, findlines)
end;
function appbetween(pt1,pt2,Markhere);
	jumpto(dl(pt1));
	Plotto(dl(pt2));
	Markhere();
end;
function recordlineatpoint;
	vars col;
	colhere() ->col;
	line :: if atom(col) then [] else col close
			->picture(xposition,yposition)
end;
function markline(end1,end2,line);
 appbetween(end1,end2,recordlineatpoint)
end;
function markalllines;
  vars lines ;
  [line ?orientation ?end1 ?end2] :: context ->lines;
  loopif (trynext(lines) ->line, line)
  then	markline(end1,end2,tl(line))
  close
end;
vars recognisejunc;
function testpointjunc;
	vars list line pt end1 end2;
	colhere() ->list;
	unless	atom(list)
	then
		vars ends middles lines;
		list ->lines;
		0 ->ends;
		0 ->middles;
		here() ->pt;
		until	list==[]
		then
			dest(list)->list ->line;
			dl(tl(line)) ->end1 ->end2;
			if	equal(pt,end1)
			or	equal(pt,end2)
			then	1 + ends ->ends
			else	1 + middles ->middles
			close
		close;
		if	ends==0 and middles==1 then exit;
		add([%recognisejunc(ends,middles),pt,lines%]);
	close
end;
function findjunctions;
	scan(testpointjunc)
end;
function seelines;
	vars x, y, x1, x2, y1, y2;
  database();
  scan(testhere);
  findalllines([row col leftdiag rightdiag]);
  markalllines();
  findjunctions();
	foreach [line row [?x1 ?y1] [?x2 ?y2]] then
		if x1 > x2 then x1, x2 -> x1 -> x2 close;
		until x1 > x2 then "-" -> picture(x1,y1); x1 + 1 -> x1 close;
	close;
	foreach [line col [?x1 ?y1] [?x2 ?y2]] then
		if y1 > y2 then y1, y2 -> y1 -> y2 close;
		until y1 > y2 then "!" -> picture(x1,y1); y1 + 1 -> y1 close;
	close;
	foreach [line rightdiag [?x1 ?y1] [?x2 ?y2]] then
		if x1 > x2 then x1, x2 -> x1 -> x2, y1, y2 -> y1 -> y2 close;
		until x1 > x2 then "/" -> picture(x1,y1); x1 + 1 -> x1; y1 + 1 -> y1 close;
	close;
	foreach [end [?x ?y] ==] then "e" -> picture(x,y) close;
	foreach [fork [?x ?y] ==] then "f" -> picture(x,y) close;
	foreach [arrow [?x ?y] ==] then "a" -> picture(x,y) close;
	foreach [cross [?x ?y] ==] then "c" -> picture(x,y) close;
	foreach [ell [?x ?y] ==] then "l" -> picture(x,y) close;
	foreach [tee [?x ?y] ==] then "t" -> picture(x,y) close;
	scan(lambda ();
		if islist(picture(xposition, yposition)) then
			"?" -> picture(xposition, yposition)
		close
	     end);
end;
vars testforside;
unless testforside.isfunc then Lib("junctions") close;
