#include	"../h/local.h"
#include "pdp00.h"
#include "pdpex.h"
#include "../h/em1.h"

/*
 * EM1 - UNIX as translator
 *
 * CONVERSION GROUP
 * PROCEDURE CALL GROUP
 * MISCELLANEOUS
 *
 */

/*
 *  op_mrk
 */

gen_mrk (n) int n; {

	switch (n) {
	case 0:
		gen2(MOV,LB,PSH);
		break;
	case 1:
		gen2(MOV,STATLB,PSH);
		break;
	case 2:
		gen2(MOV,STATLB,R0);
		gen2(MOV,statreg(REG0),PSH);
		break;
	default:
		gen2(MOV,imm(n),R0);
		extsubr(".mrk");
	}
	if (n<=2)
		gen2(MOV,LB,PSH);
	coco = fake;
}

/*
 *  op_ret,
 *  with operand 1 or 2
 */

gen_ret (op) int op; {
	char sb[MAXSTRL]; register char *s;

	stk.flags=INT;
	gen2(MOV,LB,SPX);
	if (statd == -4)
		gen2(op_cmi,POP,POP);
	else
		gen2(op_add,STATNUM,SPX);
	gen2(MOV,DYNLB,LB);
	if (fsp->type != LOCL || (op==2 && fsp->flags & IND)) {
		if (op==2)
			stk.flags=0;
		move(fsp,&stk);
	} else {
		s = sb;
		if (fsp->flags & IND)
			 *s++ = '*';
		s = strapp(s,int8(fsp->offset));
		strcpy(s,STATSPX);
		gen2(MOV,sb,PSH);
		if (op==2)
			gen2(MOV,sb,PSH);
	}
	gen1(RTS,PC);
}

/*
 *  op_blm, op_bls
 */

gen_blm(mn,op) int mn,op; {
	int flag;
	register i,tmp;
	register fake_t *ftop;
	fake_t ftemp;
	fake_t f;
	char sb[MAXSTRL]; char *s;

	if (op<=1 && mn==op_blm) {
		make_int(2,SAVE_FAKE);
		popfk(2);
		return;
	}

	if (op==4 && fsp->type!=STK && fsp>fake) {
		make_int(1,EMPTY_FAKE);	/* have an integer word to
			serve as the destination address */
		copyf(fsp--,&ftemp);
		gen_loi(4); /* load indirect the two source words */
		pshfk(&ftemp); /* load dest. address */
		gen_sti(4); /* store indirect the two words */
		return;
	}

	if (mn==op_blm)
		tmp=2;
	else
		tmp=3;
	make_int(tmp,EMPTY_FAKE);
	ftop=fsp;
	if (fsp-tmp > fake) {
		while (fsp->type!=STK && fsp>ftop-tmp)
			fsp--;
		empty_fake(ALL);
	} else
		fsp = fake;	/* cf. to_reg0  */
	reg_frame(&f);
	if (flag=(mn!=op_blm || op>=10)) { /* blm 6, blm 8: just MOVs */
		getreg(&f,ONLY_REG);
		iregs[f.index] = &f; /*: get a sob register */
		if (mn==op_blm)
			gen2(MOV,imm(op>>1),str(&f));
		else {
			move(ftop--,&f);
			gen1(ASR,str(&f));
			gen1(op_ble,F2);
		}
	}
	mv_to_reg(ftop--,ANY);	/* dst register  */
	mv_to_reg(ftop,ANY);	/* src register  */
	strcpy(sb,autinc(ftop->index));
	s = autinc((ftop+1)->index);
	if (flag) {
		plabel(TMP1);
		gen2(MOV,sb,s);
		gen2(SOB,str(&f),B1);
		if (mn==op_bls)
			plabel(TMP2);
	} else
		for(op =>> 1,i=0; i<op; i++)
			gen2(MOV,sb,s);
	clearegs();
}

/*
 *  op_lor, op_str
 */

gen_rgs (mn,n) int mn,n; {
	register char *ss;

	empty_fake(ALL);
	if (mn==op_lor) {
		switch(n) {
		case 0:
			gen2(MOV,LB,PSH);
			break;
		case 1:
			gen2(MOV,SPX,PSH);
			break;
		case 2:
			gen2(MOV,"hp",PSH);
			pputs(GLOBL); pputs("hp"); pline();
			break;
		default:
			error("illegal LOR",0);
		}
	} else {
		switch(n) {
		case 0:
			ss = ".strlb";
			break;
		case 1:
			ss = ".strsp";
			break;
		case 2:
			ss = ".strhp";
			break;
		default:
			ss=0;
			error("illegal STR",0);
		}
		if (ss)
			extsubr(ss);
	}
	coco = fake;
}

/*
 *  op_cid, op_cif
 */

cif_cid (mn) int mn; {
	register conv;
	register *p;
	fake_t f;
	float flt;

	reg_frame(&f);
	make_int(1,SAVE_FAKE);
	coco = fake;
	if (conv=(fsp->flags & CONV)) {
		if (conv==FIC) {
			mv_to_reg(fsp,ANY);
			cif_cid(mn);
		} else {
			fatal("bad frame (cif_cid).");
		}
	} else if (mn==op_cif) {
		flt = fsp->offset;
		p = iip_cast &flt;
		if (fsp->type != CONS || p[1] != 0) {	/* argh */
			fsp->flags =| IFC;
			fsp->flags =& ~INT;
			if (fsp->type==STK) {
				f.flags=0;
				getreg(&f,ONLY_REG);
				move(fsp,&f);
			}
		} else {
			fsp->flags = 0;
			fsp->offset = p[0];
		}
	} else {
		empty_fake(1);
		extsubr(".cid");
		if (fsp>fake)
			fsp--;
		stk.flags=0;
		pshfk(&stk);
		coco = fake;
	}
}

/*
 *  op_cdi, op_cdf, op_cfi, op_cfd
 */

gen_cnv (mn) int mn; {
	register conv;
	fake_t f;

	make_dbl(1);
	stk.flags = 0;
	if (conv=(fsp->flags & CONV)) {
		switch (mn) {
		case op_cdi:
		case op_cdf:
			if (conv==FDC && mn==op_cdi) {
				mn = op_cfi;
				fsp->flags =& ~(CONV|INT);
			} else
				move(fsp,&stk);
			gen_cnv(mn);
			break;
		case op_cfi:
			if (conv==IFC) {
				fsp->flags =| INT;
				fsp->flags =& ~CONV;
			} else {
				if (conv==DFC) {
					mn = op_cdi;
					fsp->flags =& ~CONV;
				} else
					move(fsp,&stk);
				gen_cnv(mn);
			}
			break;
		case op_cfd:
			if (conv==DFC) {
				fsp->flags =& ~INT;
				fsp->flags =& ~CONV;
			} else {
				if (conv==IFC) {
					fsp->flags =& ~CONV;
					cif_cid(op_cid);
				} else {
					move(fsp,&stk);
					gen_cnv(mn);
				}
			}
		}
	} else {
		if (mn==op_cdi) {
			empty_fake(2);
			extsubr(".cdi");
			if (fsp>fake)
				fsp--;
			stk.flags=INT;
			pshfk(&stk);
			coco = fsp;
		} else {
			coco = fake;
			if (mn==op_cdf)
				fsp->flags =| DFC;
			if (fsp->type==STK) {
				reg_frame(&f); f.flags = 0;
				getreg(&f,ONLY_REG);
				move(fsp,&f);
				if(mn==op_cdf)
					coco=fsp;
			}
			if (mn != op_cdf)
				fsp->flags =| (mn==op_cfi?(FIC|INT):FDC);
		}
	}
}

/*
 *  op_dup 2
 */

dupspc() {
	register line_t *fwp;
	register mnem;
	register char *s;
	fake_t tmp,f;

	make_int(1,SAVE_FAKE);
	mnem = (fwp=forward())->instr_num&0377;
	if(fwp->type1==GLOSYM) {
		f.offset=0;
		f.index = int_cast fwp->ad.ad_gp->g_name;
	} else {
		f.offset=fwp->ad.ad_i;
		f.index=0;
	}
	f.flags = INT;
	if (mnem == op_stl || mnem == op_ste) {
		if (mnem == op_stl)
			f.type = LOCL;
		else
			f.type = EXT;
		empty_to(&f);
		if (fsp->type==STK)
			gen2(MOV,TOP,str(&f));
		else {
			copyf(fsp,&tmp);
			move(fsp,&f);
			copyf(&tmp,fsp);
		}
		nextline = fwp;
	} else {
		pshfk(fsp); /* a DUP 2 in advance */
/* NB op_pad */	if(mnem==op_add || mnem==op_pad || mnem==op_adi) {
			mv_to_reg(fsp,ANY);
			s = str(fsp);
			if (mnem==op_adi) {
				if (f.offset==1)
					gen1(op_inc,s);
				else
					gen2(op_add,imm(f.offset),s);
			} else {
				gen2(op_add,s,s);
				fsp--;
				copyf(fsp+1,fsp); /* undo the DUP */
			}
			nextline = fwp;
		} else if (mnem==op_mul) {
			checkint(fsp,ODD_REG,ANY);
			genf(op_mul,fsp,fsp);
			fsp--;
			copyf(fsp+1,fsp); /* undo the DUP */
			nextline = fwp;
		} else {	/* default : */
			checkint(fsp,ANY,ANY);
			if (fsp->type&(STK|REG)){
				reg_frame(&f);
				getreg(&f,ONLY_REG);
				move(fsp,&f);
				set_reg(fsp);
				if ((fsp-1)->type == STK)
					gen1(TST,PSH);
				else
					set_reg(fsp-1);
			}
		}
	}
	coco = fsp;
}
