#include	"../h/local.h"
#include	"opt00.h"
#include	"optex.h"
#include	"../h/em1.h"

#ifdef DUMP
char	*typestr[] {"missing","const","procname","glosym","locsym","pseudo"};
char	*labstr[]  {"no","yes"};

char *itoa (n) {
	register ac;
	register char *p;

	p= &string[MAXSTRING];
	*--p = 0;
	ac = n;
	/* assert n>= 0 */
	do {
		*--p = ac % 10 + '0';
		ac =/ 10;
	} while (ac);
	*--p = '.';
	return(p);
}

char *gloname (gb) glob_t *gb; {
	register glob_t *gbp;
	register n;

	gbp=gb;
	if((gbp->g_name[0]&0377)==255) {	/* special case: */
		n = gbp->g_name[2] & 0377;
		return(itoa(n | (gbp->g_name[1] & 0177) << 8));
	} else
		return(gbp->g_name);
}

char *statstr (status) {
	register char *buf;
	register stat,n;

	n=0; stat=status&0377; buf=string;
	while(n++<19) *buf++ = ' '; *buf=0;
	if (stat&DEFINED) {
		buf = &string[0];
		*buf++ = 'd'; *buf++ = 'e'; *buf++ = 'f';
	}
	if (stat&IMPORT) {
		buf = &string[4];
		*buf++ = 'i'; *buf++ = 'm'; *buf++ = 'p';
	}
	if (stat&EXPORT) {
		buf = &string[8];
		*buf++ = 'e'; *buf++ = 'x'; *buf++ = 'p';
	}
	if (stat&OCCURRED) {
		buf = &string[12];
		*buf++ = 'o'; *buf++ = 'c'; *buf++ = 'c';
	}
	if (stat&RELOC) {
		buf = &string[16];
		*buf++ = 'r'; *buf++ = 'e'; *buf++ = 'l';
	}
	return(string);
}

char *pseuname(i) {
	register char *s;

	switch(i) {
	case ps_bss: s = &"bss"; break;
	case ps_con: s = &"con"; break;
	case ps_dic: s = &"dic"; break;
	case ps_end: s = &"end"; break;
	case ps_eof: s = &"eof"; break;
	case ps_mes: s = &"mes"; break;
	case ps_exc: s = &"exc"; break;
	case ps_exd: s = &"exd"; break;
	case ps_ima: s = &"ima"; break;
	case ps_imc: s = &"imc"; break;
	case ps_hol: s = &"hol"; break;
	case ps_let: s = &"let"; break;
	case ps_pro: s = &"pro"; break;
	case ps_rom: s = &"rom"; break;
	case ps_fwp: s = &"fwp"; break;
	default:     s = &"???";
	}
	return(s);
}

dump(n)
{
	register glob_t	*gb;
	register line_t		*ln;
	extern int pseunum();
	register locl_t	*lb;
	int i;

	if (d_flag < 1) return;
	if (n == -1 && d_flag < 2) return;
	printf("\n** EM1 optimizer  **   pass %d complete:\n",n);
	printf("%6d %4d %4d\n", (last_line - line) , subst_made, optims);
	printf("%9.9s%9.9s%8.8s\n", "instr_nr", "type","addr");
			/* no length & format info */
	for (ln = &line[0],i = 1 ; ln <= last_line ; ln++,i++)
		dumpl(i,ln);
	printf("    %8s%8s\n","labnum","defined");
			/* no minval, maxval, (binary-) labval info */
	for ( lb = loclabel ,i = 1;lb < &loclabel[oursize->n_llab] ; lb++,i++)
		if (lb->l_num)
			printf("%4d%8d  %-s\n",
				i, lb->l_num, labstr[lb->l_status&DEFINED]);
	if((d_flag==2 && pass>2) || d_flag>2) {
	printf("\t%8s%8s%8s%8s\n","g_name","value","(octal)","status");
	for (gb = globlabel,i = 0;gb < &globlabel[oursize->n_glab]; gb++, i++)
		if (gb->g_name[0])
			printf("%5d\t%8s%7d (%6o)  %s\n",i,gloname(gb),
				gb->g_val,gb->g_val,statstr(gb->g_status));
	}
	printf("\n");
}

/********
call(name,arg) {if (!d_flag) return;printf(name,arg);printf(" called\n");}
ret(name)  char *name; {if (!d_flag) return;printf("return from %s\n",name);}
********/

dumpl(i,lnp) int i; line_t *lnp;{
	register line_t *ln;
	register typ;

	ln=lnp;
	printf("%4d  %3.3s%9.9s",i,
		(typ = ln->type1) == PSEUDO ?
			pseuname(pseunum(ln->ad.ad_i)) :
			mnemon[ln->instr_num & 0377].m_name,
		typestr[ln->type1]);
	if(typ==PROCNAME || typ==GLOSYM)
		printf("  %8s",
			typ==GLOSYM?gloname(ln->ad.ad_gp):
				ln->ad.ad_pp->p_name);
	else if(typ==CONST || typ==LOCSYM)
		printf("  %8d",
			typ==LOCSYM?ln->ad.ad_lp->l_num:ln->ad.ad_i);
	putchar('\n');
}
#endif
