#include "path.h"	/* this is ../h/path.h or ../h/bootpath.h */
#include "../h/local.h"

/*
 * (c) copyright 1980 by the Vrije Universiteit, Amsterdam, The Netherlands.
 * Explicit permission is hereby granted to universities to use or duplicate
 * this program for educational or research purposes.  All other use or dup-
 * lication  by universities,  and all use or duplication by other organiza-
 * tions is expressly prohibited unless written permission has been obtained
 * from the Vrije Universiteit. Requests for such permissions may be sent to
 * 
 *      Dr. Andrew S. Tanenbaum
 *      Wiskundig Seminarium
 *      Vrije Universiteit
 *      Postbox 7161
 *      1007 MC Amsterdam
 *      The Netherlands
 * 
 * Organizations wishing to modify part of this software for subsequent sale
 * must  explicitly  apply  for  permission.  The exact arrangements will be
 * worked out on a case by case basis, but at a minimum will require the or-
 * ganization to include the following notice in all software and documenta-
 * tion based on our work:
 * 
 *           This product is based on the Pascal  system  developed  by
 *      Andrew  S.  Tanenbaum, Johan W. Stevenson and Hans van Staveren
 *      of the Vrije Universiteit, Amsterdam, The Netherlands.
 */

/*
 * put all the pieces of the pascal part of the EM1 project together
 *	author: Johan Stevenson, Vrije Universiteit, Amsterdam
 */


#ifdef C7
#define	EQ			=
#define	chp_cast		(char	*)
#define	flp_cast		(FILE	*)
#define	iip_cast		(int	*)
#define	EQ			=
typedef	struct	file		FILE;
#endif

#ifndef C7
#define	EQ			/* nothing */
#define	chp_cast		/* nothing */
#define	flp_cast		/* nothing */
#define	iip_cast		/* nothing */
#define	EQ			/* nothing */
#define	FILE			struct file
#endif

#ifndef CEM
#define	void			int
void	printf();
void	fatal();
#endif

#ifdef CEM
void	printf(());
void	fatal(());
#endif

#define	SIGHUP			1
#define	SIGINT			2
#define	SIGTERM			15
#define	SIG_DFL			0
#define	SIG_IGN			1

#define	DIRSIZ			14

int	lastpass		EQ 4;
char	*passpath[5];
char	*passflag[5];

int	argerr;
int	toterr;
int	parent;

char	*pemflag;
int	pemflen;

char	*ddflag;
char	*eeflag;
#ifdef INT_ONLY
char	*iiflag			EQ "-I";
#endif
#ifndef INT_ONLY
char	*iiflag;
#endif
char	*llflag;
char	*ooflag;
char	*ppflag;
char	*ssflag;
char	*ccflag;
char	*eflag;
char	*fflag;
char	*oflag;
char	*sflag			EQ "-sm";
char	*tflag;
char	*wflag;

#define	CALLSIZE		60
#define	LOADSIZE		50
#define	PREPSIZE		10
char	*callvector[CALLSIZE];
char	*loadvector[LOADSIZE];
char	*prepvector[PREPSIZE];
char	**loadv	EQ		loadvector;
char	**prepv EQ		prepvector;
char	**av;
int	ac;
int	fileargs;		/* number of recognized, processed args */
int	flagargs;
char	*progname;
char	*libfile;

#define	CHARSIZE		2500
#define CHARMARG		50
char	charbuf[CHARSIZE];
char	*charp			EQ charbuf;


char	*pdptail[] EQ {
	LIBPR_PATH,
	LIBEM_PATH,
#ifdef V7
	"-lm",
	"-lc",
#endif
#ifndef V7
	"-l",
#endif
	BSS_PATH,
	0
};
char	*em1tail[] EQ {
	EM1PR_PATH,
	0
};

char	*tmp_dir		EQ TMP_DIR;
char	*unique			EQ "pcXXXXXX";

#define	NULL			0
#define	EOF			(-1)
#define	BUFSIZ			512
struct	file {
	int	fd;
	int	nleft;
	char	*nextp;
	char	buff[BUFSIZ];
};
FILE	stdout;
int	infatal;	/* prevent recursion in fatal */

/*
 * forward function declarations
 */
void	finish();
void	pem();
void	opt();
void	pdp();
void	as();
void	encode();
void	decode();
#ifdef V7
void	expand();
#endif
void	lib();
int	list();
char	*flag();
char	*process();
char	*newfile();
char	*tempfile();
char	**initvector();
char	**em1vector();
char	*setsuf();
int	getsuf();
int	ffill();
int	getc();

/*
 * used library routines and data
 */
extern	char	*sys_errlist[];
extern	int	atoi();

extern	int	errno;
extern	void	exit();
extern	void	sleep();
extern	void	execv();
extern	char	*sbrk();
extern	int	read();
extern	int	write();
extern	int	close();
extern	int	open();
extern	int	creat();
extern	int	unlink();
extern	int	chdir();
extern	int	fork();
extern	int	wait();
extern	int	getpid();
extern	void	(*signal())();

#ifndef V7
extern	int	seek();
#endif
#ifdef V7
extern	long	lseek();
#define	seek(a,b,c)	lseek(a,(long)b,c)
#endif

main(argc,argv) char **argv; {
	register char *p;

	if (signal(SIGHUP,SIG_IGN) == SIG_DFL)
		if (signal(SIGHUP,finish) != SIG_IGN)
			;
	if (signal(SIGINT,SIG_IGN) == SIG_DFL)
		if (signal(SIGINT,finish) != SIG_IGN)
			;
#ifdef V7
	if (signal(SIGTERM,SIG_IGN) == SIG_DFL)
		if (signal(SIGTERM,finish) != SIG_IGN)
			;
#endif
	finit(&stdout,1);
	ac = argc;
	av = argv;
	progname = *av++;
	if (--ac == 0) {
		info();
		exit(-1);
	}
	init();
	while (--ac >= 0) {
		p = *av++;
		if (*p == '-') {
			flagargs++;
			p = flag(p);
		} else {
			fileargs++;
			p = process(p);
		}
		if (p) {
			*loadv++ = p;
			if (loadv >= &loadvector[LOADSIZE])
				fatal("too many load arguments");
		}
	}
	if (ppflag || ddflag || ssflag || llflag)
		finish();
	if (fileargs == 0)
		fatal("pascal programs must have suffix .p");
	if (lastpass >= 4 && toterr == 0)
		load();
	if (lastpass >= 5 && toterr == 0)
		go();
	finish();
}

char *process(arg) char *arg; {
	register char *p,*q;
	register last;
	int fd,c,c1,suf;
	void (*func)();

	p = arg;
	argerr = 0;
	for (;;) {
		switch(c = getsuf(p)) {
		case 'p':
			c1 = '\0';
			if ((fd = open(p,0)) > 0) {
				if (read(fd,chp_cast &c1,1) != 1)
					;
				if (close(fd) != 0)
					;
			}
			if (c1 == '#') {
#ifndef V7
				fatal("No preprocessor under UNIX 6");
			}
#endif
#ifdef V7
				func = expand;
				last = (ppflag != 0);
				suf = 'i';
				break;
			}
		case 'i':
			if (c == 'i' && p == arg) {
				fileargs--;
				return(p);
			}
			if (ppflag)
				return(0);
#endif
			func = pem;
			last = (lastpass <= 1);
			suf = 'k';
			break;
		case 'e':
			if (ddflag && p != arg)
				return(0);
			func = encode;
			last = (lastpass <= 1);
			suf = 'k';
			break;
		case 's':
			if (lastpass<=2 || ssflag)
				return(0);
			func = as;
			last = (lastpass <= 3);
			suf = 'o';
			break;
		case 'l':
			if (lastpass<=2 || llflag)
				return(0);
			if (ddflag) {
				func = decode;
				last = 1;
				suf = 'e';
				break;
			}
			return(p);
		case 'k':
			if (lastpass <= 1)
				return(0);
			if (ooflag || ccflag || llflag) {
				func = opt;
				last = (lastpass <= 2);
				suf = 'm';
				break;
			}
		case 'm':
			if (lastpass <= 2)
				return(0);
			if (ccflag) {
				func = pdp;
				last = (ssflag != 0);
				suf = 's';
				break;
			}
			if (ddflag) {
				func = decode;
				last = 1;
				suf = 'e';
				break;
			}
			if (llflag) {
				if (p == arg)
					return(0);
				func = lib;
				last = 1;
				suf = 'l';
				break;
			}
		case 'o':
			return(p);
		default:
			fileargs--;
			return(p);
		}
		q = newfile(last,arg,suf);
		(*func)(p,q);
		toterr =+ argerr;
		if (argerr)
			return(0);
		donewith(p);
		p = q;
	}
}

prep(s) char *s; {

	*prepv++ = s;
	if (prepv >= &prepvector[PREPSIZE])
		fatal("too many preprocessor arguments");
}

char *flag(f) char *f; {
	register char *p;
	register c;

	p = f+1;
	switch (c = *p++) {
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
		if (*p == '=') {
			passpath[c-'1'] = p+1;
			return(0);
		}
		if (*p) {
			passflag[c-'1'] = p;
			return(0);
		}
		lastpass = c-'0';
		break;
	case 'e':
		eflag = f;
		break;
	case 'E':
		eeflag = f;
		break;
	case 'w':
		wflag = f;
		break;
	case 'r':
		lastpass = 5;
		break;
	case 'o':
		if (ac--)
			oflag = *av++;
		else
			fatal("-o flag may not be last arg");
		break;
	case 'f':
		fflag = f;
		break;
	case 't':
		tflag = f;
		break;
	case '{':
		pemflag = p;
		while (*p)
			p++;
		if (*--p == '}')
			*p++ = '\n';
		pemflen = p-pemflag;
		break;
	case 'C':
		ccflag = f;
		break;
	case 'D':
		if (*p) {
			prep(f);
			return(0);
		}
		ddflag = f;
		break;
	case 'I':
		if (*p) {
			prep(f);
			return(0);
		}
		iiflag = f;
		break;
	case 'U':
		prep(f);
		return(0);
	case 'L':
		llflag = f;
		break;
	case 'O':
		ooflag = f;
		break;
	case 'P':
		ppflag = f;
		break;
	case 'S':
		ssflag = f;
		break;
	case 's':
		if (*p == 's' || *p == 'm' || *p == 'l') {
			sflag = f;
			p++;
			break;
		}
	default:
		return(f);
	}
	if (*p)
		fatal("bad flag %s",f);
	return(0);
}

/* ------------------ calling sequences -------------------- */

pem(p,q) char *p,*q; {
	register char **v,*d; register fd;

	if (iiflag)
		v = em1vector(1,PEMI_PATH);
	else
		v = initvector(1,PEM_PATH,0);
	d = tempfile('d');
	if ((fd = creat(q,0600)) < 0)
		syserr(q);
	if (pemflag)
		if (write(fd,pemflag,pemflen) != pemflen)
			syserr(q);
	if (close(fd) != 0)
		;
	*v++ = q;
	*v++ = d;
	call(v,p,0);
	if (argerr == 0)
		if (list(p,d) < 0)
			argerr++;
	donewith(d);
}

#ifdef V7
expand(p,q) char *p,*q; {
	register char **v,**pv;

	v = callvector;
	*v++ = CPP_PATH;
	*v++ = progname;
	*v++ = p;
	*v++ = q;
	if (ppflag)
		*v++ = ppflag;
	for (pv=prepvector; pv<prepv; )
		*v++ = *pv++;
	call(v,0,0);
}
#endif

encode(p,q) char *p,*q; {
	register char **v;

	if (iiflag)
		v = em1vector(1,ENCI_PATH);
	else
		v = initvector(1,ENC_PATH,0);
	*v++ = p;
	*v++ = TABLES_PATH;
	*v++ = q;
	call(v,0,0);
}

decode(p,q) char *p,*q; {
	register char **v;

	if (iiflag)
		v = em1vector(3,DECI_PATH);
	else
		v = initvector(3,DEC_PATH,0);
	*v++ = p;
	*v++ = TABLES_PATH;
	*v++ = q;
	call(v,0,0);
}

as(p,q) char *p,*q; {
	register char **v;

	v = callvector;
	*v++ = AS_PATH;
	*v++ = progname;
	*v++ = "-o";
	*v++ = q;
	*v++ = p;
	call(v,0,0);
}

opt(p,q) char *p,*q; {
	register char **v;

	v = initvector(2,OPT_PATH,sflag);
	if (llflag) {
		*v++ = llflag;
		*v++ = libfile = tempfile('x');
	}
	*v++ = p;
	call(v,0,q);
}

pdp(p,q) char *p,*q; {
	register char **v;

	v = initvector(3,PDP_PATH,0);
	*v++ = "-o";
	*v++ = q;
	call(v,p,0);
}

lib(p,q) char *p,*q; {
	register char **v;

	v = initvector(3,LIB_PATH,0);
	*v++ = p;
	*v++ = libfile;
	call(v,0,q);
	donewith(libfile);
}

load() {
	register char **v,**lv;

	if (ccflag) {
		v = initvector(4,LD_PATH,0);
		*v++ = "-X";
		*v++ = (fflag ? FRT0_PATH : RT0_PATH);
	} else
		v = initvector(4,ASS_PATH,sflag);
	if (oflag) {
		*v++ = "-o";
		*v++ = oflag;
	}
	for (lv=loadvector; lv<loadv; )
		*v++ = *lv++;
	for (lv = (ccflag ? pdptail : em1tail); *lv; )
		*v++ = *lv++;
	call(v,0,0);
}

go() {
	register char **v;

	if (ccflag) {
		v = callvector;
		*v++ = (oflag ? oflag : "a.out");
		*v++ = progname;
	} else {
		v = initvector(5,EM1_PATH,0);
		*v++ = (oflag ? oflag : "e.out");
	}
	while ((parent = fork()) < 0)
		sleep(1);
	if (parent==0) {
		parent++;
		finish();
	}
	parent = 0;
	*v = 0;
	execv(callvector[0],callvector+1);
	syserr(callvector[0]);
}

/* ------------------- pascal listing ----------------------- */

#define MAXERNO		300
#define MAXERRLIST	10
#define	IDMAX		8
#define	FNMAX		14

struct errec {
	int	erno;
	char	mess[IDMAX];
	int	mesi;
	int	chno;
	int	lino;
	int	linr;
	int	orig;
	char	fnam[FNMAX];
};

struct	errec	curr;
struct	errec	next;

int	*index;
int	maxerno;

int	errerr;
int	errfat;

int	listline;

FILE	*inpfil		EQ NULL;
FILE	*mesfil		EQ NULL;
int	errfd;

char	*err_path	EQ ERR_PATH;

int	printline();
int	skipline();
int	errorline();
int	geterrec();
int	nexterror();

int list(p,q) char *p,*q; {
	register fd;
	if ((errfd = open(q,0)) < 0)
		syserr(q);
	if (geterrec() == 0)
		if (eeflag==0) {
			if (close(errfd) != 0)
				;
			return(0);
		}
	if (mesfil == NULL)
		mesfil = flp_cast sbrk(sizeof *mesfil);
	if (index == 0) {
		index = iip_cast sbrk(MAXERNO * sizeof index[0]);
		fillindex();
	}
	if (eeflag || eflag) {
		if (inpfil == NULL)
			inpfil = flp_cast sbrk(sizeof *inpfil);
		if ((fd = open(p,0)) < 0)
			syserr(p);
		finit(inpfil,fd);
	}
	errerr = errfat = listline = 0;
	if (eeflag)
		listfull();
	else if (eflag)
		listpartial();
	else
		listshort(p);
	if (close(errfd) != 0)
		;
	if (close(inpfil->fd) != 0)
		;
	flush();
	return(errfat ? -1 : 1);
}

listshort(p) char *p; {
	register char *s,*source;

	source = s = p;
	while (*s)
		if (*s++ == '/')
			source = s;
	while (nexterror()) {
		if (curr.fnam[0] == ' ')
			printf("%s",source);
		else
			pasprint(curr.fnam,FNMAX);
		printf(", %d: ",curr.linr);
		string(&curr);
	}
}

listfull() {

	if (nexterror())
		do {
			do {
				if (printline() == 0)
					fatal("error line number too high");
			} while (listline < curr.lino);
		} while (errorline());
	while (printline());
}

listpartial() {

	if (nexterror())
		do {
			do {
				if (((listline < curr.lino-2) ?
						skipline() : printline()) == 0)
					fatal("error line number too high");
			} while (listline < curr.lino);
		} while (errorline());
}

int printline() {
	register ch;

	if ((ch=getc(inpfil))>=0) {
		printf("%5d\t",++listline);
		do {
			putchar(ch);
			if (ch=='\n')
				return(1);
		} while((ch=getc(inpfil))>=0);
	}
	return(0);
}

int skipline() {
	register ch;

	++listline;
	while((ch=getc(inpfil))!='\n' && ch >= 0 )
		;
	return(ch == '\n');
}

int errorline() {
	register c;
	register struct errec *p,*q;
	struct	errec	lerr[MAXERRLIST];
	int	goon;

	printf("*** *** ");
	p = lerr;
	c = 0;
	do {
		if (c < curr.chno) {
			printf("%*c",curr.chno-c,'^');
			c = curr.chno;
		}
		if (p < &lerr[MAXERRLIST])
			bmove(chp_cast &curr, chp_cast p++, sizeof curr);
		goon = nexterror();
	} while (goon && curr.lino==listline);
	putchar('\n');
	for (q = &lerr; q < p; q++)
		string(q);
	putchar('\n');
	return(goon);
}

int geterrec() {
	register n;

	if ((n = read(errfd, chp_cast &next, sizeof next)) == 0) {
		next.erno = 0;
		return(0);
	}
	if (n != sizeof next)
		fatal("bad error format");
	return(1);
}

int nexterror() {

	do {	/* skip warnings if wflag */
		bmove(chp_cast &next, chp_cast &curr, sizeof next);
		if (curr.erno == 0)
			return(0);
		for (;;) {
			if (geterrec() == 0)
				break;
			if (next.lino != curr.lino || next.chno != curr.chno)
				break;
			if (curr.erno < 0 && next.erno > 0)
				/* promote warnings if they cause fatals */
				curr.erno = -curr.erno;
			if(next.mess[0] != ' ' || next.mesi != -1)
				/* give all parameterized errors */
				break;
			if(curr.mess[0] != ' ' || curr.mesi != -1)
				/* and at least a non-parameterized one */
				break;
		}
	} while (curr.erno < 0 && wflag != 0);
	return(1);
}

fillindex() {
	register *ip,n,c;

	if ((n = open(err_path,0)) < 0)
		syserr(err_path);
	finit(mesfil,n);
	ip = index;
	*ip++ = 0;
	n = 0;
	while ((c = getc(mesfil)) >= 0) {
		n++;
		if (c == '\n') {
			*ip++ = n;
			if (ip > &index[MAXERNO])
				fatal("too many errors on %s",err_path);
		}
	}
	maxerno = ip - index;
}

string(p) struct errec *p; {
	register off,n,e;

	errerr++;
	if ((e = p->erno) < 0) {
		e = -e;
		printf("Warning: ");
	} else
		errfat++;
	if (e == 0 || e >= maxerno)
		fatal("bad error number %d",e);
	off = index[e-1];
	n = index[e] - off;
	if (n >= BUFSIZ)
		n = BUFSIZ-1;
	if (seek(mesfil->fd,off,0) < 0)
		;
	if (read(mesfil->fd,mesfil->buff,n) < 0)
		;
	mesfil->buff[n] = '\0';
	print(mesfil->buff,p);
}

print(s,ep) char *s; struct errec *ep; {
	register char *p,c;

	p = s;
	while (c = *p++) {
		if (c == '%') {
			c = *p++;
			if (c == 'i')
				printf("%d", ep->mesi);
			else if (c == 's')
				pasprint(ep->mess,IDMAX);
			else
				putchar(c);
		} else
			putchar(c);
	}
}

pasprint(str,n) char *str; {
	register char *s;
	register i,c;

	s = str;
	for (i=0; i<n; i++)
		if ((c = *s++) != ' ')
			putchar(c);
}

bmove(from,to,count) char *from,*to; {
	register char *p1,*p2;
	register n;

	p1 = from; p2 = to; n = count;
	do
		*p2++ = *p1++;
	while (--n);
}

/* ------------------- miscellaneous routines --------------- */

char *basename(p) char *p; {
	register char *q;

	q = p;
	while (*q)
		if (*q++ == '/')
			p = q;
	return(p);
}

int getsuf(path) char *path; {
	register n;
	register char *p;

	p = path;
	n = 0;
	while (*p)
		if (*p++ == '/')
			n = 0;
		else
			n++;
	if (n <= DIRSIZ && n > 2 && p[-2] == '.')
		return(*--p);
	return(0);
}

char *newfile(last,old,suf) char *old; {

	if (charp > &charbuf[CHARSIZE-CHARMARG])
		fatal("charbuf overflow");
	if (last || tflag)
		return(setsuf(old,suf));
	else
		return(tempfile(suf));
}

char *setsuf(path,c) char *path; {
	register char *p,*q;

	q = basename(path);
	p = charp;
	while (*charp++ = *q++)
		;
	charp[-2] = c;
	return(p);
}

char *tempfile(suf) {
	register char *p,*q;
	register i;

	p = charp; q = tmp_dir;
	while (*p = *q++)
		p++;
	*p++ = '/';
	q = unique;
	while (*p = *q++)
		p++;
	i = fileargs;
	do
		*p++ = i % 10 + '0';
	while (i =/ 10);
	*p++ = '.'; *p++ = suf; *p++ = '\0';
	q = charp; charp = p;
	return(q);
}

call(v,in,out) char **v,*in,*out; {
	register pid;
	int	status;

	while ((parent = fork()) < 0)
		sleep(1);
	if (parent == 0) {
		if (in) {
			if (close(0) != 0)
				;
			if (open(in,0) != 0)
				syserr(in);
		}
		if (out) {
			if (close(1) != 0)
				;
			if (creat(out,0600) != 1)
				syserr(out);
		}
		*v = 0;
		execv(callvector[0],callvector+1);
		syserr(callvector[0]);
	}
	while ((pid = wait(&status)) != parent) {
		if (pid == -1)
			fatal("process %d disappeared",parent);
		fatal("unknown child %d died",pid);
	}
	if ((status & 0177) > 3) {
		if ((status & 0200) && tflag==0)
			if (unlink("core") != 0)
				;
		fatal("fatal error %d in %s. Ask an expert for help",
				status&0177,callvector[0]);
	}
	if (status & 0177400)
		argerr++;
}

char **initvector(pass,path,sizeflag) char *path; {
	register char *p,**v;
	register n;

	n = pass-1;
	v = callvector;
	if ((p = passpath[n]) == 0)
		p = path;
	*v++ = p;
	*v++ = basename(p);
	if (sizeflag)
		*v++ = sizeflag;
	if (p = passflag[n])
		*v++ = p;
	return(v);
}

char **em1vector(pass,path) char *path; {
	register char *p,**v;
	register n;

	n = pass-1;
	v = callvector;
	*v++ = EM1_PATH;
	if ((p = passpath[n]) == 0)
		p = path;
	*v++ = basename(p);
	*v++ = p;
	if (p = passflag[n])
		*v++ = p;
	return(v);
}

info() {
	register fd,n;
	char buf[BUFSIZ];

	if ((fd = open(INFO_PATH,0)) < 0)
		syserr(INFO_PATH);
	while ((n = read(fd,buf,BUFSIZ)) > 0)
		if (write(1,buf,n) != n)
			;
	if (close(fd) != 0)
		;
}

finish() {
	register char *p,*q;
	register fd;
	struct {
		int	inode;
		char	name[DIRSIZ];
	} dir;

	if (signal(SIGINT,SIG_IGN) != finish)
		;
	if (parent != 0) {
		if (chdir(tmp_dir) != 0)
			;
		fd = open(".",0);
		while (read(fd,chp_cast &dir,sizeof dir) == sizeof dir) {
			if (dir.inode == 0)
				continue;
			p = unique;
			q = dir.name;
			while (*p++ == *q++)
				if (*p == '\0') {
					if (unlink(dir.name) != 0)
						;
					break;
				}
		}
		if (close(fd) != 0)
			;
	}
	exit(toterr ? -1 : 0);
}


donewith(p) char *p; {

	if (tflag)
		return;
	if (p >= charbuf && p < &charbuf[CHARSIZE])
		if (unlink(p) != 0)
			;
}

init() {
	register char *p;
	register i,fd;

	if ((fd = open(tmp_dir,0)) < 0)
		tmp_dir = ".";
	if (close(fd) != 0)
		;
	p = unique+2;
	parent = i = getpid();
	do
		*p++ = i % 10 + '0';
	while (i =/ 10);
	*p++ = '.'; *p = '\0';
}

/* ------------------- IO routines -------------------------- */

finit(af,fd) FILE *af; {
	register FILE *f;
	/*
	 * initialize file structure
	 */
	f = af;
	f->fd = fd;
	f->nleft = 0;
	f->nextp = 0;
}

int ffill(af) FILE *af; {
	register FILE *f;
	/*
	 * read in next block
	 */
	f = af;
	f->nextp = f->buff;
	return(f->nleft = read(f->fd,f->buff,BUFSIZ) - 1);
}

int getc(af) FILE *af; {
	register FILE *f;
	/*
	 * read next character; return -1 on eof
	 */
	f = af;
	if (--f->nleft < 0)
		if (ffill(f) < 0)
			return(EOF);
	return(*(f->nextp)++ & 0377);
}

flush() {
	/*
	 * write out a (partial) filled block; fatal if error
	 */
	if (stdout.nextp)
		if (write(stdout.fd,stdout.buff,stdout.nextp-stdout.buff) < 0)
			if (infatal == 0)
				fatal("write error");
	stdout.nextp = stdout.buff;
	stdout.nleft = BUFSIZ;
}

putchar(c) {
	/*
	 * write next character
	 */
	if (--stdout.nleft < 0) {
		flush();
		--stdout.nleft;
	}
	*(stdout.nextp)++ = c;
}

syserr(s) char *s; {
	fatal("%s: %s",s,sys_errlist[errno]);
}

#ifdef CEM
/* VARARGS1 */
void fatal((s,a1,a2,a3,a4)) char *s; {
#endif
#ifndef CEM
/* VARARGS1 */
void fatal(s,a1,a2,a3,a4) char *s; {
#endif

	infatal++;
	flush();
	finit(&stdout,2);
	printf("%s: ",progname);
	printf(s,a1,a2,a3,a4);
	putchar('\n');
	flush();
	toterr++;
	finish();
}
