/*LINTLIBRARY*/

/*
 *	Argument analysing macros
 *
 *	Extended by Andrew Hume 11/80 to define what happens to ARG
 *	I have defined it as A_NULL when it reaches the end of the list
 *	This is true for L6/L7
 */

#ifndef FILE
#include	<stdio.h>
#endif
#ifndef isdigit
#include	<ctype.h>
#endif

#define	A_NULL	(char *)0
#define	A_EOA	(char *)0	/* end of args, should be -1 for L6 */

int	A_errcnt = 0;
int	A_index = 0;
int	A_done = 0;
char	*A_usage;
char	*A_rgv0;

int
A_atoi(d)
char **d;
{			/* convert string to a number */
	register int i;
	register char *p;

	p = *d;
	if (p == A_NULL || *p == '\0')
		i = -1;
	else
	{
		while (*p == ' ')
			p++;
		i = ((isdigit(*p)) ? atoi(p) : -1);
		while (isdigit(*p))
			p++;
	}
	*d = --p;
	return(i);
}

int
A_message(n, c)
register int n;
register char c;
{
	static char cc;
	static char *A_mm[] =
	{
		"%s: Usage: %s\n",
		"Warning: use of option %c is non-standard\n",
		"Option %c not recognized\n",
		"No string for option %c\n",
		"Bad number for option %c\n",
		"Too few arguments\n",
		"Too many arguments\n"
	};

again:
	if (n == 0)
	{
		if (A_usage)
			fprintf(stderr, A_mm[0], A_rgv0, A_usage);
		exit(1);
	}
	if (c != cc)
	{
		fprintf(stderr, "%s: ", A_rgv0);
		fprintf(stderr, A_mm[n], c);
		if (n > 4)
		{
			n = 0;
			goto again;
		}
		if (n > 1)
		{
			cc = c;
			A_errcnt++;
		}
	}
	return(n);
}

#define	A_MESS(n)	A_message(n, *p)

#define	A_MESS1(n)	A_message(n, ' ')

#define	A_BEGSW(k)	if(**q==k) { for(p=(*q)+1;;p++) { switch(*p) {

#define	A_ENDSW	default: if(*p) A_MESS(2); } if(*p=='\0'||A_done) break; } }

#define	A_SUFF	(A_done++,(p+1))

#define	A_NEXT	(q[1]?*(++q):(A_MESS(3),A_NULL))

#define	A_STR	((*q!=(p-1))&&A_MESS(1),((*p&&(p[1]=='\0'))?A_NEXT:A_SUFF))

#define	STANDIN	case '\0': if(*q==(p-1)) goto A_SAVE

#define	ARGBEGIN(k)	{ char **q,**qq,*p,*pp; A_rgv0 = argv[0]; argc=1;\
	for(q=qq= &argv[1];*q != A_EOA;q++) { A_done = 0; A_BEGSW(k)

#define	ARGEND	STANDIN; A_ENDSW else A_SAVE: { *(qq++) = *q; argc++; }\
	} if(A_errcnt)A_MESS1(0); *qq= A_EOA; ARGINIT; }

#define	ARGINIT	A_index = 0;

#define	ARGCOUNT(ca,cb)	{ if(argc<ca) A_mess1(5); if((cb>ca)&&(argc>cb)) A_MESS1(6); }

#define	ARG	(argv[A_index] == A_EOA? A_NULL:argv[A_index])

#define NEXTARG	(ARG? (argv[++A_index] == A_EOA ? A_NULL:argv[A_index]):A_NULL)

#define	ARGDISPLAY	{ printf("(%d) ",argc); do printf("%s ",ARG);\
	while (NEXTARG); putchar('\n'); ARGINIT; }

#define	FLAG(a,aflag)	case a: aflag++; break

#define	NUMBER(c,cnum)	case c: pp=A_STR; cnum = A_atoi(&pp);\
	if(pp[1]||cnum==-1) A_MESS(4); break

#define	STRING(s,sptr)	case s: sptr = A_STR; break

#define	USAGE	A_usage =

#define	MAIN	main(argc,argv) int argc; char *argv[];
