#include <param.h>
#include <systm.h>
#include <buf.h>
#include <tty.h>
#include <sgtty.h>
#include <conf.h>
#include <proc.h>
#include <text.h>
#include <dir.h>
#include <signal.h>
#include <user.h>
#include <file.h>
#include <inode.h>
#include <acct.h>
#include <lnode.h>
#include <map.h>
#include <mx.h>
#include <lp.h>
#include <mount.h>

int	nulldev();
int	nodev();
int	hpopen(), hpstrategy();
int	htopen(), htclose(), htstrategy();
struct	bdevsw	bdevsw[] =
{
	hpopen, nulldev, hpstrategy, 0,		/* hp = 0 */
	htopen, htclose, htstrategy, D_TAPE,	/* ht = 1 */
	0
};

int	klopen(), klclose(), klread(), klwrite(), klioctl();
struct	tty	kl_tty[];
int	mmread(), mmwrite();
int	hpread(), hpwrite();
int	htread(), htwrite();
int	dzopen(), dzclose(), dzread(), dzwrite(), dzioctl();
int	lpopen(), lpclose(), lpwrite(), lpioctl();
struct	tty	dz_tty[];
int	syopen(), syread(), sywrite(), sysioctl();
int	cropen(), crclose(), crread();
int	mxopen(), mxclose(), mxread(), mxwrite(), mxioctl();
struct	tty	mx_tty[];
int	eiopen(), eiclose(), eiread(), eiwrite();
int	bfiopen(), bficlose(), bfiread(), bfiwrite(), bfioctl();
int	bfipopen(), bfipclose(), bfipread(), bfipwrite();

struct	cdevsw	cdevsw[] =
{
	klopen,  klclose, klread, klwrite, klioctl,  kl_tty,	/* console = 0 */
	nulldev, nulldev, mmread, mmwrite, nodev,    0,		/* mem = 1 */
	syopen,  nulldev, syread, sywrite, sysioctl, 0,		/* tty = 2 */
	dzopen,  dzclose, dzread, dzwrite, dzioctl,  dz_tty,	/* dz = 3 */
	lpopen,  lpclose, nodev,  lpwrite, lpioctl,  0,		/* lp = 4 */
	cropen,  crclose, crread, nodev,   nodev,    0,		/* cr = 5 */
	hpopen,  nulldev, hpread, hpwrite, nodev,    0,		/* hp = 6 */
	htopen,  htclose, htread, htwrite, nodev,    0,		/* ht = 7 */
	mxopen,  mxclose, mxread, mxwrite, mxioctl,  mx_tty,	/* mx = 8 */
	eiopen,  eiclose, eiread, eiwrite, nodev,    0,		/* ei = 9 */
	bfiopen, bficlose, bfiread, bfiwrite, bfioctl, 0,	/* bfi-micro = 10 */
	bfipopen, bfipclose, bfipread, bfipwrite, nulldev, 0,	/* bfi-dev = 11 */
	0
};
int	rootdev	= makedev(0, 3);
int	swapdev	= makedev(0, 8);
int	pipedev = makedev(0, 7);
daddr_t	swplo	= 0;
int	nswap	= 5016;
	
struct	buf	buf[NBUF];
struct	bhash	bhash[NBHASH];
struct	file	file[NFILE];
struct	inode	inode[NINODE];
struct	proc	proc[NPROC];
struct	text	text[NTEXT];
struct	lnode	lnode[NLNODE];
struct	cblock	cfree[NCLIST];
struct	map	coremap[CMAPSIZ];	/* core allocation */
struct	map	swapmap[SMAPSIZ];	/* swap allocation */
struct	map	umap[UMAPSIZ];		/* unibus map allocation */
char		canonb[CANBSIZ];	/* buffer for erase and kill */
struct	mount	mount[NMOUNT];
struct	cblock	*cfreelist;
struct	buf	bfreelist;
struct	acct	acctbuf;
struct	inode	*acctp;

struct mx mx[] =
{
    {
	makedev(3, 37),		/* VAX 11/780 at EECF */
	EXTA,			/* speed 19.2KB */
	16,			/* nports */
    },				/* remainder initialised to zero */
    {
	makedev(3, 28),		/* 11/35 at EECF */
	B9600,			/* speed */
	8,			/* nports */
    },				/* remainder initialised to zero */
    {
	makedev(3, 27),		/* CSU */
	EXTA,			/* speed */
	5,			/* nports */
    },				/* remainder initialised to zero */
    {
	makedev(3, 38),		/* DSL 11/34 at EECF */
	EXTA,			/* speed */
	9,			/* nports */
    },				/* remainder initialised to zero */
};
short mx_nlines = 4;		/* total number of physical lines */
short mx_cnt = 38;		/* total number of virtual lines */
struct tty mx_tty[38];
struct mxflc mxflc[38];

struct lpst lp[] =
{
	{
		0177514,	/* address */
		CLOSED,		/* state */
		BMAX,		/* free buffers */
	},			/* remainder initialised to zero */
};
short nlp = 1;			/* total number of line printers */
