/*LINTLIBRARY*/

/*
**	Reads, modifies, and writes the fixed portion of the pwentry whose uid matches "pe->pw_limits.l_uid"
**	The function indicated by the "func" argument is called with the address
**	of a passwd structure to perform the modification.
**	The string section is not written and neither are the string pointers.
**	returns 1 for success, 0 for failure and PWERROR for error
*/ 

#include	<pwr.h>


getpwput(pe, func)
	struct pwent *		pe;
	int			(*func)();
{
	register struct pwent *	rp;
	register int		ri;
	struct pwent		p;
	long			t;

	ri = PWERROR;

	/*	open and lock	*/ 

	if ( pwopen( 1 ) == SYSERROR )
		return ri;

	do
	{
		/*	get address	*/ 

		rp = &p;
		if(!getutab(pe->pw_limits.l_uid, &t))
			break;
		if ( t == PWENTNULL )
			break;
		if(!getentry(rp, &t))
			break;

		/* ok got entry, now modify the contents... */

		(*func)(rp);

		/* alter entry */ 

		if(!putentry(rp, &t))
			break;

		ri = 1;
	}
	while(0);

	unlock();

	return(ri);
}
