/*
 *	this creation just reads raw tape file specified as
 *	1st argument.  it then reports on record size etc.  on
 *	double tapemark it stops.
 */ 

#include	<signal.h>
#include	<sys/param.h>
#include	<sys/stat.h>
#include	<stdio.h>

#define		MAXTP	90	/* Maximum size tape block likely to be encountered */
#define		NERR	10	/* NERR consecutive ==> giveup */

char		buf[MAXTP*BSIZE];
int		flag;
int		err;


catch(s)
int	s;
{
	signal(s, SIG_IGN);
	flag = 1;
}

main(argc, argv)
int argc;
char **argv;
{
	register	iold;
	register	i;
	register	nrec;
	register	infd;
	struct stat	sbuf;

	if ( signal(SIGINT, SIG_IGN) == SIG_DFL )
		signal(SIGINT, catch);
	if ( signal(SIGQUIT, SIG_IGN) == SIG_DFL )
		signal(SIGQUIT, catch);

	if(argc != 2)
	{
		fprintf(stderr, "Usage: taprd file\n");
		exit(2);
	}

	if((infd = open(argv[1], 0)) == -1)
	{
		perror(argv[1]);
		exit(2);
	}

	fstat(infd, &sbuf);
	if((sbuf.st_mode&S_IFMT) != S_IFCHR)
	{
		fprintf(stderr, "%s not a raw device !!\n", argv[1]);
		exit(2);
	}

	nrec = 0;
	iold = read(infd, buf, sizeof buf);
	for(;;)
	{
		nrec++;
		i = read(infd, buf, sizeof buf);
		if(i == iold && i == 0)
			goto fini;	/* considered end-of-tape */
		if ( (i==iold) && (i==-1) && (nrec==NERR) )
		{
			printf("%d consecutive errors: EOT assumed\n",NERR);
			exit(1);
		}
		if((i == iold) && !flag)
			continue;
		if(iold)
		{
			if(iold != -1)
			{
				printf("%6u. * %6o(%6u.)\n",
					nrec, iold, iold);
			}
			else
			{
				printf("%6u. *  ERR  \n", nrec);
				err++;
				if(nrec > 1)
				exit(err);
			}
		}
		else
		{
			printf("\tTM\n");
		}
		nrec = 0;
		iold = i;
		if(flag)
		{
			printf("Interrupted\n");
			return 1;
		}
	}
fini:
	printf("\tEOT\n");
	exit(err);
}
