/*
**	passwd [-v] [name]
*/

#include	<local-system>
#include	<sys/param.h>
#include	<passwd.h>
#include	<sgtty.h>
#include	<stdio.h>
#include	<signal.h>

struct	pwent pe;
struct	sgttyb tty;
int	savetty;
int	status	= 1;
int	vsuppress;	/* suppress verification of the password */

main(argc, argv)
	register	argc;
	register char	*argv[];
{
	char		sbuf[4][100];
	extern	 	finish();
	extern char *	crypt();

	signal(SIGINT, finish);
	signal(SIGQUIT, finish);
	signal(SIGALRM, finish);
	alarm( 2*60 );

	if(argc > 1 && argv[1][0] == '-' && argv[1][1] == 'v')
	{
		vsuppress ++;
		argc --;	
		argv ++;
	}

	{
		register unsigned	uid = getuid();
		register		i;
		extern			errno;

		for ( i = 0 ; i < 3 ; i++ )
			if ( !isatty(i) )
				return errno;

		if(argc < 2)
		{
			pe.pw_limits.l_uid = uid;
			if(getpwlog(&pe, (char *)0, 0) == PWERROR)
			{
				fprintf(stderr, "Cannot access password!\n");
				return(1);
			}
		}
		else
		{
			pe.pw_strings[LNAME] = argv[1];
			if ( getpwuid(&pe, (char *)0, 0) == PWERROR )
			{
				fprintf(stderr, "Who?\n");
				return(1);
			}
			if ( uid && uid != pe.pw_limits.l_uid )
			{
				fprintf(stderr, "No permission\n");
				return(1);
			}
		}

		/* echo off  */
		gtty(fileno(stdin), &tty);
		if ( (savetty = tty.sg_flags) & ECHO )
		{
			tty.sg_flags &= ~ECHO;
			stty(fileno(stdin), &tty);
		}

		if(uid == pe.pw_limits.l_uid && pe.pw_pword[0])
		{
			getstring("Old password: ", sbuf[1], sizeof sbuf[1]);
			if ( pwcmp(crypt(sbuf[1], pe.pw_pword), pe.pw_pword) )
			{
				fprintf(stderr, "Sorry.\n");
				finish();
				return status;
			}
		}
	}

	{
		register	ok;

		ok = 0;
		do
		{
			getstring("New password: ", sbuf[2], sizeof sbuf[2]);
			ok = vsuppress?1:valpasswd(sbuf[2]);
		} while(!ok);

		if( !vsuppress )
		{
			getstring("Check: ", sbuf[3], sizeof sbuf[3]);
			if(cmp(sbuf[2], sbuf[3]))
			{
				fprintf(stderr, "Try Again.\n");
				finish();
				return status;
			}
		}
	}

	alarm( 0 );

	{
		register char	*cp;
		register	i;

		if( *(cp = sbuf[2]) )
		{
			register long	salt;
			char		saltc[2];
	
			salt = time( &pe.pw_age );
			salt += getpid();
			for ( i = 0 ; i < sizeof saltc ; i++ )
			{
				register	c;

				c = ((salt>>(i*6))&077) + '.';
				if ( c > '9' )
					c += 7;
				if ( c > 'Z' )
					c += 6;
				saltc[i] = c;
			}
			cp = crypt(cp, saltc);
			for ( i = 0; i < CRYPTLEN; )
				pe.pw_pword[i++] = *cp++;
		}
		else
		{
			for ( i = 0; i < CRYPTLEN; )
				pe.pw_pword[i++] = 0;
		}

		pe.pw_limits.l_flags &= ~NEWPASSWD;

		if(updtpwent(&pe) == PWERROR)
		{
			fprintf(stderr, "Unable to change password!\n");
		}
		else
		{
/* DEBUG
			limits(&pe.pw_limits, L_CHNGLIM);
DEBUG */
			status = 0;
		}
	}

	finish();
	return status;
}




int
pwcmp(cp1, cp2)
	register char	*cp1, *cp2; 
{
	register	i = CRYPTLEN;

	do
		if(*cp1++ != *cp2++)
			return(1);
	while(--i);

	return(0);
}




int
valpasswd( s )
	register char	*s;
{
	register	flags = 0;
	register	c;
	register	n = 0;

	while ( c = *s++ )
	{
		n++;
		if ( c >= 'a' && c <= 'z' )
			flags |= 2;
		else
		if ( c >= 'A' && c <= 'Z' )
			flags |= 4;
		else
		if ( c >= '0' && c <= '9' )
			flags |= 1;
		else
			flags |= 8;
	}

	if ( flags >= 7 && n >= 4 )
		return 1;
	if ( ((flags == 2)||(flags == 4)) && n >= 6 )
		return 1;
	if ( ((flags == 3)||(flags == 5)||(flags == 6)) && n >= 5 )
		return 1;

	if ( flags == 1 )
		fprintf(stdout, "Please use at least one non-numeric character.\n");
	else
		fprintf(stdout, "Please use a longer password.\n");

	return 0;
}







getstring(s, buf, n)
	char		*s;
	char		*buf;
	int		n;
{
	register char *	ep = buf+n;
	register char *	bp;
	register	c;

loop:
	bp = buf;
	fprintf(stdout, s);

	do
		if ( (c = getchar()) == EOF )
			finish();
		else
			if ( bp < ep )
				*bp++ = (char)c;
			else
			{
				fprintf(stdout, "\nToo long!\n");
				while ( c != '\n' )
					if ( (c = getchar()) == EOF )
						finish();
				goto loop;
			}
	while(c != '\n');

	*--bp = '\0';
	fprintf(stdout, "\n");
}




int
cmp(s1, s2)
	register char	*s1, *s2;
{
	while(*s1++ == *s2++ && s1[-1]);
	return(*--s1-*--s2);
}




finish()
{
	if ( savetty & ECHO )
	{
		alarm( 0 );
		signal( SIGINT, SIG_IGN );
		signal( SIGQUIT, SIG_IGN );
		tty.sg_flags = savetty;
		stty(fileno(stdin), &tty);
	}

	exit( status );
}
