/*
 * df - report on free space and inodes on a device
 *
 *	Must be able to read the special device file ==> setuid to root
 *	Simply prints out the free blocks and inodes as recorded in the
 *	device's superblock - most of the work is in checking the arguments.
 */

#include <param.h>
#include <filsys.h>
#include <dir.h>
#include <mtab.h>
#include <stat.h>
#include <stdio.h>

int	fi;				/* file descriptor of device */
int	mtabfd;				/* file descriptor of mount table */
char	mtabf[]	= MTABF;		/* the mount table */
char	dev[]	= "/dev/";		/* where devices live */
char	prefix[DIRSIZ + 1] = "hp";	/* prepend to abbreviations */
struct	filsys sblock;			/* read superblock into here */

main(ac, av)
register char **av;
{
	register i;
	int uid;
	struct mtab mtab;
	struct stat statb;
	char outbuf[BUFSIZ];

	setbuf(stdout, outbuf);
	if ((mtabfd = open(mtabf, 0)) == -1)
	{
		perror(mtabf);
		exit(1);
	}
	if (ac <= 1)		/* no args - default to current device */
	{
		register device;

		stat("", &statb);	/* where am i? */
		device = statb.st_dev;
		chdir(dev);
		while (read(mtabfd, (char *)&mtab, sizeof mtab) == sizeof mtab)
			if (stat(mtab.m_spec, &statb) != -1 &&
			    statb.st_rdev == device)
			{
				process(mtab.m_spec);
				exit(0);
			}
		printf("Can't find you!\n");
		exit(1);
	}

	chdir(dev);

	if (ac == 2 && strcmp(av[1], "-a") == 0)
	{
		while (read(mtabfd, (char *)&mtab, sizeof mtab) == sizeof mtab)
			process(mtab.m_spec);
		exit(0);
	}

	i = strlen(prefix);	/* index to first null */
	uid = getuid();
	for (ac--, av++; ac--; av++)	/* skip command name */
	{
		/*
		 * is it an abbreviation?
		 */
		if (strlen(*av) < sizeof prefix - i)
		{
			prefix[i] = 0;
			strcat(prefix, *av);
			if (access(prefix, 0) == 0)
			{
				process(prefix);
				continue;
			}
		}
		/*
		 * strip off leading /dev (if any)
		 */
		if (strncmp(dev, *av, sizeof dev - 1) == 0)
			*av += sizeof dev - 1;
		/*
		 * is it a mounted-on directory?
		 */
		if (stat(*av, &statb) == -1)
		{
			perror(*av);
			continue;
		}
		statb.st_mode &= S_IFMT;
		if (statb.st_mode == S_IFDIR && statb.st_ino == ROOTINO)
		{
			lseek(mtabfd, 0L, 0);
			while (read(mtabfd, (char *)&mtab, sizeof mtab) == sizeof mtab)
				if (strcmp(mtab.m_file, *av) == 0)
				{
					*av = mtab.m_spec;
					break;
				}
			if (*av != mtab.m_spec)	/* oh dear didn't find it */
				printf("%s not mounted on\n", *av);
			else
				process(*av);
			continue;
		}
		if (statb.st_mode != S_IFBLK)
		{
			printf("%s not a block device\n", *av);
			continue;
		}
		if (uid)	/* if we are mortal, arg must be mounted */
		{
			lseek(mtabfd, 0L, 0);
			while (read(mtabfd, (char *)&mtab, sizeof mtab) == sizeof mtab)
				if (strcmp(mtab.m_spec, *av) == 0)
				{
					*av = mtab.m_spec;
					break;
				}
			if (*av != mtab.m_spec)
			{
				printf("%s not mounted\n", *av);
				continue;
			}
		}
		process(*av);
	}
	exit(0);
}

process(file)
char *file;
{
	fi = open(file, 0);
	if (fi == -1)		/* highly improbable, but possible */
	{
		perror(file);
		return;
	}
	lseek(fi, (long)(SUPERB << BSHIFT), 0);
	read(fi, &sblock, sizeof(sblock));	/* read the superblock */
	printf("%s: %7ld blks %5d inodes\n",
		file, sblock.s_tfree, sblock.s_tinode);
	close(fi);
}
