/*LINTLIBRARY*/
/*
**	All routines to handle the "state" file
*/

#include	<local-system>
#ifdef	Aus2
#include	<types.h>
#include	<dir.h>
#endif	Aus2
#ifdef	Aus1
#include	<dir.h>
#include	"lvl7.h"
#endif	Aus1
#include	<stdio.h>
#include	"neth.h"
#include	"netstate.h"

#define	Statefile	STATEFILE

static Nsp	nhost;		/* host found by searchg */
static long	Size;		/* file size used by searchg */
unsigned	searchg();

extern char *	ctime();

#ifdef	EBUG2
#define	EBUG1
#endif	EBUG2
#ifdef	EBUG1
#undef	Statefile
char *	Statefile	= STATEFILE;
#define	DEPTH	8
#endif	EBUG1



/*
**	Search State_stacs for "chost",
**	 return name of directly connected host
**	 on shortest path to "chost".
*/

char *
findhost(chost, size)
	char *		chost;
	long		size;		/* size of thing to be routed */
{
	register Nsp	hp;
	extern FILE *	readstate();

	if ( (Size = size) < 1000 )
		Size = 1000;	/* min size */

#	ifdef	EBUG1
	fprintf(stderr, "findhost %s, size=%u\n", chost, Size);
#	endif	EBUG1

	if ( State_stacs == NULLNSP )
		if ( readstate(0) == NULL )
			return NULLSTR;

	for ( hp = Hosts_stacs ; hp != NULLNSP ; hp = hp->ns_prev )
		if ( strncmp(chost, hp->ns_host, HOSTSIZE) == STREQUAL )
		{
#			ifndef	EBUG1
			if ( hp != Home_stac && searchg(hp) != 0 )
#			else	EBUG1
			if ( hp != Home_stac && searchg(hp, 0) != 0 )
#			endif	EBUG1
				return nhost->ns_host;
			return NULLSTR;
		}

	return NULLSTR;
}



/*
**	Set up network statistics records from contents of passed string
*/

getstats(s, date)
	char *		s;
	time_t		date;
{
	register Nsp	next, prev;
	register char *	sp;

	if ( s == NULLSTR )
		return;

	if ( (prev = New_stacs) != NULLNSP )
		do
		{
			next = prev->ns_next;
			free((char *)prev);
		}
		while
			( prev = next );

	prev = (Nsp)&New_stacs;

	while ( (sp = strchr(s, ':')) != NULLSTR && (s = strchr(sp, '@')) != NULLSTR )
	{
		while ( *++sp == ':' );
		next = nsalloc();
		strncpy(next->ns_host, sp, min(s-sp, HOSTSIZE));
		next->ns_date = (time_t)atol(s+1);
		next->ns_prev = prev==(Nsp)&New_stacs?NULLNSP:prev;
		prev->ns_next = next;

		prev = next;
	}

	if ( date )
	{
		prev->ns_next = next = nsalloc();
		Prev_stac = next->ns_prev = prev==(Nsp)&New_stacs?NULLNSP:prev;
		strncpy(next->ns_host, NETID, HOSTSIZE);
		next->ns_date = date;
	}
}



/*
**	Return TRUE if two args are connected
*/

hconnected(h1, h2, flag)
	char *		h1;
	char *		h2;
	int		flag;
{
	register Nsp	hp, np;

	if ( (hp = Hosts_stacs) == NULLNSP )
		return 0;

	for ( ; hp != NULLNSP ; hp = hp->ns_prev )
		if ( strcmp(h1, hp->ns_host) == STREQUAL )
		{
			for ( np = hp->ns_next ; np != NULLNSP && np->ns_type != host_t ; np = np->ns_next )
				if ( strcmp(h2, np->ns_host) == STREQUAL )
					return np->ns_state != NS_DN || flag;

			return 0;
		}

	return 0;
}



/*
**	Search New_stacs for match
*/

Nsp
matchNew(op)
	register Nsp	op;
{
	register Nsp	np;

	for ( np = New_stacs ; np != NULLNSP ; np = np->ns_next )
		if ( strncmp(np->ns_host, op->ns_host, HOSTSIZE) == STREQUAL )
			return np;

	return NULLNSP;
}



/*
**	Modify State_stacs with new info from New_stacs
*/

modstats(date)
	time_t		date;
{
	register Nsp	np, op, lp;
	char		lasthost[HOSTSIZE];
	extern Nsp	newhost();

	/** Search old state for matches against new **/

	lp = (Nsp)&State_stacs;		/* last pointer */
	Orglstate = NS_DN;		/* state of origin */

	for ( op = State_stacs ; op != NULLNSP ; lp = op, op = op->ns_next )
		if ( op->ns_type != nchost_t && (op->ns_type == host_t || lasthost[0] != '\0') )
		{
			if ( (np = matchNew(op)) == NULLNSP )
			{
				if ( op->ns_type == host_t )
					lasthost[0] = '\0';
			}
			else
			{
				if ( op->ns_type == host_t )
				{
					if ( np == New_stacs )
						op->ns_bytes += np->ns_bytes;
					if ( np->ns_prev != NULLNSP )
						newhost(op, np->ns_prev, nchost_t, np->ns_rate);
					if ( np->ns_next != NULLNSP )
						newhost(op, np->ns_next, nchost_t, np->ns_next->ns_rate);
					np->ns_type = host_t;
					strncpy(lasthost, op->ns_host, HOSTSIZE);
				}
				else
				{
					long	oldrate = op->ns_rate;

					if ( np->ns_prev != NULLNSP
					     && strncmp(lasthost, np->ns_prev->ns_host, HOSTSIZE) == STREQUAL )
					{
						if ( np->ns_prev == New_stacs )
							Orglstate = op->ns_state;
						op->ns_rate = np->ns_rate;
					}
					else
					if ( np->ns_next != NULLNSP
					     && strncmp(lasthost, np->ns_next->ns_host, HOSTSIZE) == STREQUAL )
						op->ns_rate = np->ns_next->ns_rate;
					op->ns_state = np->ns_state;
					if ( oldrate > op->ns_rate && op->ns_date > (date - HOUR) )
						op->ns_rate = oldrate;
				}

				if ( np->ns_date > op->ns_date )
					if ( np->ns_date < date )
						op->ns_date = np->ns_date;
					else
						op->ns_date = date;
			}
		}

	/** Search New_stacs for unmatched hosts and add to end of State_stacs **/

	for ( np = New_stacs ; np != NULLNSP ; np = np->ns_next )
		if ( np->ns_type == null_t )
		{
			/** Check it really IS new **/
			for ( op = Hosts_stacs ; op != NULLNSP ; op = op->ns_prev )
				if ( strncmp(op->ns_host, np->ns_host, HOSTSIZE ) == STREQUAL )
					break;
			if ( op != NULLNSP )
				continue;	/* exists! */
			op = newhost(lp, np, host_t, (long)0);
			if ( np->ns_prev != NULLNSP )
				newhost(lp->ns_next, np->ns_prev, nchost_t, np->ns_rate);
			if ( np->ns_next != NULLNSP )
				newhost(lp->ns_next, np->ns_next, nchost_t, np->ns_next->ns_rate);
			op->ns_date = np->ns_date<date?np->ns_date:date;
			np->ns_type = host_t;
			op->ns_prev = Hosts_stacs;	/* build Hosts_stacs */
			Hosts_stacs = op;
			if ( Home_stac == NULLNSP && strncmp(NETID, op->ns_host, HOSTSIZE) == STREQUAL )
				Home_stac = op;
		}
}



/*
**	Make a new host from copy of old and add to list after old
*/

Nsp
newhost(op, np, type, rate)
	Nsp		op, np;
	enum host_typ	type;
	long		rate;
{
	register Nsp	sp;

	/** First check this really IS new **/

	for ( sp = op ; sp != NULLNSP && (sp->ns_type != host_t || sp == op) ; sp = sp->ns_next )
		if ( strncmp(sp->ns_host, np->ns_host, HOSTSIZE) == STREQUAL )
			return NULLNSP;

	/** Make a new host **/

	sp = nsalloc();

	*sp = *np;
	sp->ns_type = type;
	sp->ns_rate = rate;
	sp->ns_next = op->ns_next;
	op->ns_next = sp;
	return sp;
}



#ifdef	EBUG1
newstate(statefile)
	char *	statefile;
{
	Statefile = statefile;
}
#endif	EBUG1



/*
**	Return name of next host connected to NETID
**	that is not mentioned in route
**	(successive calls return successive names)
*/

char *
nextup()
{
	register Nsp	hp;

	if ( Orglstate == NS_UP || Home_stac == NULLNSP )
		return NULLSTR;

	for ( hp = Home_stac->ns_next ; hp != NULLNSP && hp->ns_type != host_t ; hp = hp->ns_next )
	{
		if ( hp->ns_type == uchost_t )
			continue;
		hp->ns_type = uchost_t;	/* exclude hosts already encountered */
		if ( matchNew(hp) != NULLNSP )
			continue;
		return hp->ns_host;
	}

	return NULLSTR;
}



/*
**	Allocate enough memory to hold a "net_stac"
**	Call "neterror" on memory exhaustion
*/

Nsp
nsalloc()
{
	register Nsp		new;
	static struct net_stac	_zero_stac;

	if ( (new = (Nsp)malloc(sizeof (struct net_stac))) == NULLNSP )
		neterror("out of memory");

	*new = _zero_stac;	/* clear stac */

	return new;
}



/*
**	Return name of previous host in route
*/

char *
prevhost()
{
	if ( Prev_stac != NULLNSP )
		return Prev_stac->ns_host;

	return NULLSTR;
}



/*
**	Print statistics from New_stacs
*/

printstats(fd)
	FILE *		fd;
{
	register Nsp	next;

	if ( (next = New_stacs) != NULLNSP )
	{
		fprintf(fd, "Transmission statistics:-\n%12ld bytes from", next->ns_bytes);

		do
		{
			if ( next != New_stacs )
			{
				if ( next->ns_rate )
					fprintf(fd, " at %3ld bytes/second to", next->ns_rate);
				else
					fprintf(fd, "%23s", " to");
			}
			fprintf(fd, " host %-*.*s %.15s\n"
					,HOSTSIZE/2
					,HOSTSIZE
					,next->ns_host
					,ctime(next->ns_date)+4
				);
		}
		while
			( (next = next->ns_next) != NULLNSP );
	}
}



/*
**	Open state file, read it, and return FILE descriptor.
**	If "update" is off, file is closed.
*/

FILE *
readstate(update)
	int		update;
{
	register FILE *	fd;

	if ( (fd = fopen(Statefile, update?"r+":"r")) != NULL )
	{
		rstate(fd, &State_stacs);
		if ( update )
			rewind(fd);
		else
			fclose(fd);
		return fd;
	}

	return NULL;
}



/*
**	Read in "state" file to State_stacs
*/

rstate(fd, Stacs)
	FILE *		fd;
	Nsp *		Stacs;
{
	register Nsp	prev, next;
	register int	sep1, sep2;
	register long *	longp;
	char		temp[MAXTOK+1];

	/** Read in hosts **/

	Hosts_stacs = next = NULLNSP;
	prev = (Nsp)Stacs;

	for ( sep1 = '\n', sep2 = rtok(fd, temp) ; sep2 != EOF ; sep1 = sep2, sep2 = rtok(fd, temp) )
	{
		switch ( sep1 )
		{
		 case '\n':	if ( temp[0] == '\0' )
					continue;	/* ignore null lines */
		 case ',':	next = nsalloc();
				prev->ns_next = next;
				prev = next;
				if ( sep1 == '\n' )
				{
					if ( Home_stac == NULLNSP && strncmp(NETID, temp, HOSTSIZE) == STREQUAL )
						Home_stac = next;
					next->ns_prev = Hosts_stacs;
					Hosts_stacs = next;
					next->ns_type = host_t;
				}
				else
					next->ns_type = chost_t;
				strncpy(next->ns_host, temp, HOSTSIZE);
				continue;
		 case '@':	longp = &next->ns_date;
				break;
		 case '=':	longp = &next->ns_bytes;
				break;
		 case '*':	longp = &next->ns_rate;
				break;
		 case '\'':	if ( next != NULLNSP )
					next->ns_state = temp[0];
				continue;
		}

		if ( next != NULLNSP )
			*longp = atol(temp);
	}
}



/*
**	Read a state token (host or number) from file, and return separator
*/

rtok(fd, s)
	FILE *		fd;
	char *		s;
{
	register int	c;
	register int	n;

	for ( n = 0 ;; )
	{
		switch ( c = getc(fd) )
		{
		 case ':':	continue;

		 case '#':	c = EOF;
		 case '\n':
		 case '@':
		 case ',':
		 case '*':
		 case '=':
		 case '\'':
		 case EOF:
			*s = '\0';
			return c;
		}

		if ( n++ < MAXTOK )
			*s++ = c;
	}
}



/*
**	Search graph for shortest path to Home_stac
**	Algorithm weights DOWN hosts inversely proportional to size of thing being routed
*/

unsigned
#ifndef	EBUG1
searchg(hp)
#else	EBUG1
searchg(hp, depth)
#endif	EBUG1
	Nsp		hp;
{
	register Nsp	p1, p2;
	register unsigned d;
	register unsigned dist;
	register Nsp	shost = NULLNSP;

#	ifdef	EBUG1
	fprintf(stderr, "%*s@%s\n", depth*DEPTH, "", hp->ns_host);
#	endif	EBUG1

	hp->ns_search = hp;
	dist = (unsigned)-1;	/* MAX value */

	for ( p1 = hp->ns_next ; p1 != NULLNSP && p1->ns_type != host_t ; p1 = p1->ns_next )
	{
		if ( (p2 = p1->ns_prev) == NULLNSP )
		{
			/** connect graph **/

			for ( p2 = Hosts_stacs ; p2 != NULLNSP ; p2 = p2->ns_prev )
				if ( p2 != hp && strncmp(p1->ns_host, p2->ns_host, HOSTSIZE ) == STREQUAL )
				{
					p1->ns_prev = p2;
					break;
				}

			if ( p2 == NULLNSP )
				continue;	/* Not connected !! */
		}

#		ifdef	EBUG2
		fprintf(stderr, "%*s%s%s%s%s%s\n"
				,depth*DEPTH+(DEPTH/2)
				,""
				,p2->ns_host
				,(p2==Home_stac)?", HOME":""
				,(p2->ns_search!=NULLNSP)?", collision":""
				,(matchNew(p2)!=NULLNSP)?", match route":""
				,(p1->ns_state==NS_DN)?", DOWN":""
			);
#		endif	EBUG2

		if ( p2 == Home_stac )
		{
			nhost = hp;
			hp->ns_search = NULLNSP;
#			ifdef	EBUG1
			fprintf(stderr, "%*s%s to %s, dist=%d\n", depth*DEPTH, "", p2->ns_host, hp->ns_host, 2);
#			endif	EBUG1
			if ( p1->ns_state == NS_DN )
				return 10000 / Size + 3;
			else
				return 2;
		}

		if ( p2->ns_search != NULLNSP )
			continue;	/* already going this way */

		if ( matchNew(p2) != NULLNSP )
			continue;	/* already been this way */

#		ifndef	EBUG1
		if ( d = searchg(p2) )
#		else	EBUG1
		if ( d = searchg(p2, depth+1) )
#		endif	EBUG1
		{
			if ( p1->ns_state == NS_DN )
				d += 10000 / Size + 1;
#			ifdef	EBUG2
			fprintf(stderr, "%*sroute via %s to %s%s, dist=%d%s\n"
					,depth*DEPTH+(DEPTH/2)
					,""
					,p2->ns_host
					,hp->ns_host
					,(p1->ns_state==NS_DN)?" DOWN":""
					,d+2
					,(d<dist)?"":" (discarded)"
				);
			if ( shost != NULLNSP && d < dist )
			fprintf(stderr, "%*sdiscard route via %s to %s, dist=%d\n"
					,depth*DEPTH+(DEPTH/2)
					,""
					,shost->ns_host
					,hp->ns_host
					,dist+2
				);
#			endif	EBUG2
			if ( d < dist )
			{
				dist = d;
				shost = nhost;
			}
		}
	}

	hp->ns_search = NULLNSP;

	if ( shost != NULLNSP )
	{
		nhost = shost;
#		ifdef	EBUG1
		fprintf(stderr, "%*sroute via %s to %s, dist=%d\n", depth*DEPTH, "", shost->ns_host, hp->ns_host, dist+2);
#		endif	EBUG1
		return dist + 2;
	}

	return 0;
}



/*
**	Set rates in New_stacs by scanning dates
*/

setrates(size)
	long		size;		/* size of file */
{
	register Nsp	next, prev;

	if ( (prev = New_stacs) != NULLNSP )
		for ( ; (next = prev->ns_next) != NULLNSP ; prev = next )
		{
			register time_t	delay;

			if ( (delay = next->ns_date-prev->ns_date) <= 0
				|| (next->ns_rate = size/delay) <= 0 )
				next->ns_rate = 0;
			prev->ns_bytes = size;
		}
}



/*
**	Open "state" file, update with New info, and write.
**	Returns TRUE for success.
*/

int
upstate(s, size, date)
	char *		s;
	long		size;
	time_t		date;
{
	register FILE *	fd;

	getstats(s, date);

	if ( New_stacs == NULLNSP )
		return 1;	/* why bother ? */

	setrates(size);

	if ( (fd = readstate(1)) != NULL )
	{
		modstats(date);
		writestate(fd);
		fclose(fd);
		return 1;
	}
	return 0;
}



/*
**	Write out state file from updated statistics in State_stacs
*/

int
writestate(fd)
	FILE *		fd;
{
	register Nsp	next;
	register int	bytes = 0;

	if ( (next = State_stacs) != NULLNSP )
		do
			if ( next->ns_type == host_t )
				bytes += fprintf(fd, "\n%.*s@%ld=%ld"
							,HOSTSIZE
							,next->ns_host
							,next->ns_date
							,next->ns_bytes
						);
			else
				bytes += fprintf(fd, ",%.*s*%ld%s"
							,HOSTSIZE
							,next->ns_host
							,next->ns_rate
							,next->ns_state==NS_DN?"'D":""
						);
		while
			( (next = next->ns_next) != NULLNSP );

	bytes += fprintf(fd, "\n#\n");

	return bytes;
}
