/*LINTLIBRARY*/
/*
**	Netheader, makeheader -- control format of network header
**
**	assumes existence of a routine "neterror".
*/

#include	<local-system>
#ifdef	Aus2
#include	<types.h>
#include	<dir.h>
#endif	Aus2
#ifdef	Aus1
#include	<dir.h>
#endif	Aus1
#include	<passwd.h>
#include	<stdio.h>
#include	"net.h"
#include	"neth.h"


static short	_bytes;


int
netheader(fd)
	FILE *	fd;
{
	char	c;
	char *	getheader();

	if ( (c = getc(fd)) != SOH )
		neterror("%s: unrecognised network protocol '%c'", datname, c);

	_bytes = 1;

	desthost = getheader(fd, HOSTSIZE, US, desthost, "destination host");
	destname = getheader(fd, UNMSIZE, RS, destname, "destination user");
	orghost = getheader(fd, HOSTSIZE, US, orghost, "origin host");
	orgname = getheader(fd, UNMSIZE, RS, orgname, "origin user");
	dataction = getheader(fd, 1, US, dataction, "action");
	datname = getheader(fd, DNMSIZE, US, datname, "data name");
	actparam = getheader(fd, MAXPARAMS, RS, actparam, "parameters");
	netstats = getheader(fd, MAXSTATS, STX, netstats, "statistics");

	return _bytes;
}



char *
getheader(f, size, sep, buf, mesg)
	FILE *		f;
	register int	size;
	register char	sep;
	char *		buf;
	char *		mesg;
{
	register char *	cp;
	register	c;
	extern char	end;

	if ( buf > &end && buf < (char *)&buf )
		free(buf);

	if ( (buf = malloc((unsigned)size+1)) == (char *)0 )
		neterror("out of memory");

	for ( cp = buf ; (c = getc(f)) != sep && c != EOF && size-- ; *cp++ = c );

	if ( c != sep )
	{
		char	mesgbuf[100];

		sprintf(mesgbuf, "%%s: %s too long", mesg);
		neterror(mesgbuf, datname);
	}

	*cp++ = '\0';

	_bytes += (c = cp-buf);
	return realloc(buf, (unsigned)c);
}



/*
**	Make a header
*/

int
makeheader(fd, ltime)
	FILE *	fd;
	long	ltime;
{
	return fprintf(fd, "%c%s%c%s%c%s%c%s%c%s%c%s%c%s%c%s:%s@%ld%c"
				,SOH
				,desthost
				,US
				,destname
				,RS
				,orghost
				,US
				,orgname
				,RS
				,dataction
				,US
				,datname
				,US
				,actparam
				,RS
				,netstats
				,NETID
				,ltime
				,STX
			);
}
