;;;	/ p o p / u s r / l i b / p a r s e p o p . p
function readsymbol();
	itemread()
end;

function nextsymbol() => result;
	readsymbol() -> result;
	result :: proglist -> proglist
end;

function demand(symbol);
	unless readsymbol() == symbol then
		error(symbol,1,'not found')
	close
end;

function issyntax(symbol);
	symbol == termin
	or	isword(symbol)
	and	identprops(symbol) == "syntax"
end;

vars expression;

function parseto(closer);
	expression(closer);
	demand(closer);
end;

function expressionlist();
	if	nextsymbol() == ")"
	then	demand(")");
		[]
	else	vars tree;
		expression(",") -> tree;
		if	nextsymbol() == ")"
		then	tree :: expressionlist()
		else	demand(",");
			tree :: expressionlist()
		close
	close
end;

function primary();
	vars symbol;
	readsymbol() -> symbol;
	if	issyntax(symbol)
	then	if	symbol == "("
		then	parseto(")")
		elseif	symbol == "if"
		then	[%"cond",parseto("then"),
				parseto("else"),
				parseto("close")%]
		else	error(symbol,1,'bad primary')
		close
	elseif	nextsymbol() == "("
	then	erase(readsymbol());
		symbol :: expressionlist()
	else	symbol
	close
end;

vars operatorlist;
[* / + -  == > < -> , ) then else close ;] -> operatorlist;

function isoperator(symbol);
	member(symbol,operatorlist)
end;

function moreimportant(sym1,sym2);
	vars operatorlist;
	until	hd(operatorlist) == sym1
		or	hd(operatorlist) == sym2
	then	tl(operatorlist) -> operatorlist
	close;
	hd(operatorlist) /== sym2
end;

function expression(givenop) => ptree;
	vars intermediateop;
	primary() -> ptree;
	loopif	(nextsymbol() -> intermediateop, isoperator(intermediateop))
		and	moreimportant(intermediateop,givenop)
	then	[%readsymbol(), ptree, expression(intermediateop)%]
			-> ptree
	close
end;

function readto(closer);
	vars symbol;
	readsymbol() -> symbol;
	if	symbol == closer
	then	[]
	else	symbol :: readto(closer)
	close
end;

function statement();
	if	nextsymbol() == "vars"
	then	readsymbol() :: readto(";")
	else	parseto(";")
	close
end;

function parse() => result;
	[] -> result;
	until nextsymbol() == termin then
		result <> [%statement()%] -> result
	close;
	demand(termin)
end;
