;;;	/p o p / u s r / l i b / j u n c s . p
;;;	Aaron Sloman		January 19 1978.
;;; The function classify, when given two arguments, viz:
;;; 	a point,
;;; 	a list of connected points
;;; can classify what type of junction the point is?
;;; For example:
;;; 	classify([1 1], [[1 10] [10 1]]) =>
;;; 	** ell
;;; 	classify([1 1], [[1 10]]) =>
;;; 	** end
;;; 	classify([1 1], [[1 10] [10 10] [10 1]]) =>
;;; 	** arrow

function collinear(point1,point2,point3);
	vars x1 x2 x3 y1 y2 y3;
	dl(point1) ->y1 ->x1;
	dl(point2) ->y2 ->x2;
	dl(point3) ->y3 ->x3;
	x1 * (y2 -y3) - y1* (x2 -x3) - x3*y2 + y3*x2 = 0
end;

function Sideofline(point, dx, dy, c);
	;;; dx, dy, and c are derived from a line as in the next function.
	;;; this function returns -1, 0 or 1 depending which side of the line the
	;;; point is on, or 0 if it is on the line.
	vars x y;
	dl(point) ->y ->x;
	sign( x * dy - y * dx - c)
end;


function sideofline(point, end1, end2);
  vars x1 x2 y1 y2;
  dl(end1) ->y1 ->x1;
  dl(end2) ->y2 ->x2;
  Sideofline(point, x2 -x1, y2-y1, x1*y2 -y1*x2 )
end;

function testforside (line);
  ;;; given a line, represented by its two ends, this returns a function which,
  ;;; when applied to a point gives the result -1, 0 or 1, depending which
  ;;; side of the line the point is on. If the point is on the line, the result is 0
 ;;; Note that the order of the points on the line will make a difference to the sign of the result
  vars x1 x2 y1 y2;
  dl(hd(line)) ->y1 ->x1;
  dl(hd(tl(line))) ->y2 ->x2;
	;;; It might be wiser to put the points in a canonical order first?
  Sideofline(%x2 -x1, y2-y1, x1*y2 -y1*x2%)
end;

function allsame(list);
	;;; true if all the elements of the list are the same.
	vars testitem;
	if list==[] then true exit;
	dest(list) ->list ->testitem;
	until	list==[]
	then
		unless	hd(list)==testitem
		then	false
		exit;
		tl(list) ->list
	close;
	true
end;

operation without(l1,l2);
	;;; return elements of l1 not in l2;
    [%	until l1 == []
	then	unless member(hd(l1),l2) then hd(l1) close;
		tl(l1) ->l1
	close
    %]
end;

function Delete(item,list);
    [%
	until	list == []
	then
		unless	item = hd(list) then hd(list) close;
		tl(list) ->list;
	close
    %]
end;

function throughlines(point,otherends)=>throughs otherends;
	;;; given a point and a list of otherends return a list of the lines,
	;;; formed from two of the ends, which go through the point,
	;;; (represented as a list of two ends)
	;;; and a list of the other ends, i.e. not collinear with anything.
	;;; needed for recognising TEE, CROSS, KAY and PSI junctions.
	vars thisend rest next found;
	[] ->throughs;
	[%until otherends==[]
	then
		dest(otherends) ->otherends ->thisend;
		otherends -> rest;
		;;; see if testend is collinear with one of rest.
		false -> found;
		until rest == []
		then
			dest(rest) -> rest -> next;
			if	collinear(point, thisend, next)
			then	[%thisend,next%]::throughs ->throughs;
				Delete(next,otherends) ->otherends;
				[] -> rest;	;;; stop loop
				true ->found;
			close;
		close;
		unless found then thisend close		;;; leave for other ends list.
	close%] ->otherends;
end;

vars others;		;;; used in classify
function testmulti;
	;;; called inside recognisejunc as a last resort.
	if	allsame(maplist(others,testforside(hd(throughs))))
	then	[kay ^point ^^throughs ^^others]
	else	[psi %point % ^^throughs ^^others]
	close
end;

function testthreeway(point,otherends);
	;;;used inside recognisejunc to distinguish arrow from fork
	vars e1 e2 e3 barbs;
	dl(otherends) ->e1 ->e2 ->e3;
		;;; its an arrow if theres a line such that the other two lie on the same side of it
		;;; otherwise a fork.
	[] ->barbs;
	if	sideofline(e1,point,e3) == sideofline(e2,point,e3)
	then	e3::barbs ->barbs
	close;
	if	sideofline(e2,point,e1) == sideofline(e3,point,e1)
	then	e1::barbs ->barbs
	close;
	if	barbs==[]
	then	[fork ^point ^^otherends]
	else
		if length(barbs)==1 then e2 :: barbs -> barbs close;
			;;; it must be the other barb
		otherends without barbs -> otherends;
		[arrow ^point ^^otherends ^^barbs]
	close
end;

function recognisejunc(point, throughs, others);
	;;; throughs is a list of lines going through point,
	;;; each line being a list of two points.
	;;; others is a list of ends of lines not going through point.
	vars le lm;
	length(throughs) ->lm;
	length(others) ->le;
	;;; le is the number of lines ending at the point,
	;;; lm is the number of lines going through the point (m=middle)
	if	le==0
	then	if	lm==2
		then	[cross ^point  ^^throughs]
		else	[multicross ^point  ^^throughs ]
		close
	elseif	lm==0
	then
		if	le == 3
		then	testthreeway(point,others)
		else	[multi ^point ^^others]
		close
	elseif	lm==1
	then	if	le==1
		then	[tee ^point ^^others]<>hd(throughs)
		else	testmulti()
		close
	else	[horrible]
	close
end;

function classify(point,otherends);
  vars line throughs others;
  if tl(otherends)=[] then [end ^point]<>otherends
  elseif length(otherends) == 2 then [ell ^point] <> otherends
  else
	throughlines(point,otherends) -> others ->throughs;
	recognisejunc(point, throughs, others)
 close
end;
