;;;	/ p o p / u s r / l i b / g r a p h i c . p
;;; by Aaron Sloman. Clipping routines by Frank O'Gorman.
;;; November 1977.
;;; See also /pop/usr/lib/graphops.p
;;; modified to use new version of Newposition, with real numbers.
;;;	See /pop/usr/lib/Newposition.p		Dec 1977.
;;; modified for use at UNSW	11 Nov 1979

Uses Newposition;
vars conspoint destpoint;
cons ->conspoint;
dest ->destpoint;

vars Tektronix;
discout('/dev/ttyw') -> Tektronix;	;;; this is the Tektronix at UNSW

function goutascii c; Tektronix(c+128) end;


;;; subfile: variables - 26 7 1977

;;; now some variables representing the state of the program.
;;; ingraphmode and inalphamode record state of 4012.
;;; graphx and graphy record screen co-ordinates last transmitted while
;;; scope in graphic mode.
;;; alphax and alphay are available to record position of alphanumeric cursor
;;; on 4012. however, they are not used at present, except that
;;; greset gives them values corresponding to top left of screen.

vars ingraphmode inalphamode graphx graphy alphay alphax;


 0->graphx;
 0->graphy;
 false->ingraphmode;


;;; the next three variables remember character codes transmitted to
;;; the 4012. this enables the function gptout to make use of the internal memory
;;; of the 4012 and sometimes avoid transmitting all four characters corresponding
;;; to a pair of screen co-ordinates. (see 4012 reference manual for details).

vars lastyhi lastylo lastxhi;


;;; the next three operations are used for translating between numerical
;;; co-ordinates and the codes used by the 4012, in function gptout.


operation 5 addkey x y;
 ;;; take a five bit number and add a two bit key for bits 6 and 7.
 ;;; assume x contains five bits to be used and y
 ;;;  contains two bits for positions 7 and 6.
  logor(logand(x,8:37), y<<5)
end;

;;; now two user-definable functions for transforming co-ordinates from user's
;;; framework to screen co-ordinates and back.
;;; gtransxyout takes user co-ordinates and produces screen co-ordinates.
;;; gtransxyin takes screen co-ordinates and produces user co-ordinates.
;;; both can be given value identfn to have no effect.

vars gtransxyout gtransxyin;		;;; Defined below.


;;; subfile: gptout - 29 3 1977


;;; procedures for clipping output to tektronix 4012.


vars clipping;          ;;; used in gptout
true ->clipping;

function gxyout x y;
 ;;; this function transmits a "point" to the 4012, in the form of up to four
 ;;; character codes.
 ;;; gxyout uses the memory in the 4012 to avoid transmitting all four
 ;;;  character codes if possible.

 vars  xlobits xhibits ylobits yhibits;

  y>>5 addkey 1        ->yhibits;
  y addkey 3            ->ylobits;
  x>>5 addkey 1        ->xhibits;
  x addkey 2            ->xlobits;

 unless yhibits=lastyhi then
        yhibits.goutascii; yhibits->lastyhi
 close;

 unless ylobits=lastylo and xhibits=lastxhi then
        ylobits.goutascii; ylobits->lastylo;
 close;

 unless xhibits=lastxhi then
        xhibits.goutascii; xhibits->lastxhi;
 close;

 xlobits.goutascii;             ;;;this code must always be transmitted.
end;


vars setgraphic;			;;; defined below
vars lastx lasty;
0 -> lastx; 0 -> lasty;


vars outofbounds; false ->outofbounds;

vars gxmin gxmax gymin gymax;

0 ->gxmin; 1023 ->gxmax;
0 ->gymin; 1023 ->gymax;

function gptout y jumping;
        vars x x1 y1 x2 y2  p1out p2out bothout;
        ;;; y may be either a point data structure, in which case it
        ;;; is assumed that a function destpoint will decompose it,
        ;;; or a number, in which case it is assumed that the other
        ;;; co-ordinate is on the stack.
        if y.isnumber.not then y.destpoint -> y -> x; else -> x close;
        x -> graphx; y -> graphy;
        gtransxyout(x,y) -> y -> x;             ;;; for scale change, etc. user definable.
        lastx -> x1; lasty -> y1; x -> x2; y -> y2;

        ;;; x1 y1 are co-ordinates of starting point, p1, x2 y2 of target point p2.
        ;;; now a function to find if either point is beyond the boundary, and
        ;;; if so to replace either p1 or p2 with a point on the boundary.

        function gclip x1 y1 x2 y2 xl pred => x1 y1 x2 y2;
         ;;; pred is either > or < . xl is the co-ordinate of the boundary.
         ;;; this function can also be used with x and y co-ordinates interchanged.
                  pred(x1,xl) -> p1out;         ;;; first point out of bounds.
          pred(x2,xl) -> p2out;         ;;; target point out of bounds.
          if p2out then
                true ->outofbounds;
                if jumping then true ->p1out close
          close;

          if p1out and p2out then
                true ->bothout; x.round ->lastx; y.round ->lasty
          elseif p1out or p2out then
                ;;; find coordinates of intersection point.
                xl,
                y2 - (y2 - y1 + 0.0)*(x2-xl)/(x2 - x1);		;;; 0.0 forces use of real numbers
                ;;; assign them to initial or final point:
                if p1out then   ->y1 ->x1
                else            ->y2 ->x2
                close;
          close
        end;

     if clipping then
        false ->outofbounds;
        false ->bothout;
        ;;; test if line crosses x=gxmin boundary.
        gclip(x1,y1,x2,y2, gxmin, nonop <) ->y2 ->x2 ->y1 ->x1;
        if bothout then exit;

        ;;; test if line crosses x=gxmax boundary.
        gclip(x1,y1,x2,y2, gxmax, nonop >) ->y2 ->x2 ->y1 ->x1;
        if bothout then exit;

        ;;; now do tests for y=gymin and y=gymax

        gclip(y1,x1,y2,x2, gymin, nonop <) ->x2 ->y2 ->x1 ->y1;
        if bothout then exit;

        gclip(y1,x1,y2,x2, gymax, nonop >) ->x2 ->y2 ->x1 ->y1;
        if bothout then exit;

        ;;; prepare to draw line or jump.
        x1.round -> x1; y1.round -> y1;
        unless jumping or (x1=lastx and y1=lasty)
        then setgraphic();  gxyout(x1,y1)
        close
     close;

        x2.round -> x2; y2.round -> y2;
        gxyout(x2,y2);
        x.round -> lastx; y.round -> lasty
end;

;;; subfile: setstate - 29 3 1977


function setnullstatus;
 ;;;used by functions which alter status of 4012, before they record the change.
 false->inalphamode; false->ingraphmode;
end;


function setgraphic;
 .setnullstatus;
 true ->ingraphmode;    ;;;record new status.
 goutascii(29);         ;;;switch 4012 to graphic mode.
end;


function setalpha;
 ;;; set 4012 into alphanumeric mode, e.g. for printing characters.
 goutascii(31);
 .setnullstatus;  true->inalphamode;
end;

function gsleep n;
	popmess([%Sleep,n%])
end;

vars athome;    ;;;true immediately after greset.
 
function greset;
 ;;;used to clear screen on scope and reset it to alpha status.
 goutascii(27); goutascii(12);  ;;;transmit reset code.
 ;;;now pause to give scope time to settle down.
  gsleep(3);
 true->athome; 
 ;;;record alphanumeric cursor co-ordinates.
 0->alphax;767 ->alphay;
 .setgraphic;
end;




;;; subfile: turtle - 26 7 1977


vars xturt yturt;

function gsetturt;
 ;;; coordinate the turtle record with what's happened to the scope.
  graphx ->xposition; graphy ->yposition;
end;

function jumpto;
 ;;;takes either a point or two numbers as arguments.
 .setgraphic;
 .gsetturt;
 gptout(true);
 gsetturt();
end;

function drawto;
 ;;; argument may be a point or two numbers.
 unless ingraphmode then
  jumpto(graphx,graphy);
 close;
 gptout(false);
 gsetturt()
end;



function draw steps;
 .gsetturt;
 Newposition(steps) -> yposition ->xposition;
  drawto(xposition,yposition);
 .gsetturt;
end;

function jump steps;
 .gsetturt;
  Newposition(steps) ->yposition ->xposition;
  jumpto(xposition,yposition);
end;

;;; subfile: printing - 26 7 1977


function gprintlength wd;
  ;;; calculates number of characters needed to print a word, string or integer.
  vars n;
  function cucharout x; n+1 ->n end;
  0 ->n;
  if wd.isstring then prstring(wd) else pr(wd) close;
  n
end;


function gprintat wd;
 ;;; takes a point, or two numbers, and something to print at the location specified.
 ;;; in case cucharout has been redefined, reset it.
 vars cucharout; Tektronix -> cucharout;
 jumpto();
 setalpha();
 if wd.isstring then wd.prstring else wd.pr close;
 graphy ->alphay;
 graphx + 14*gprintlength(wd) ->alphax;
end;





;;; subfile: graphic - 30 10 1977



;;; a collection of facilities for transforming user-coordinates to screen
;;; co-ordinates, when using the graphics package.

;;; first two variables to determine scale change in horizontal and vertical
;;; directions. user co-ordinates will be multiplied by these factors to produce
;;; screen co-ordinates. if both xscale and yscale are set at 10, then the
;;; screen is 102 units wide and 79 units high, approximately.

vars gxscale gyscale;

;;; two coordinates representing position on screen of origin of user's frame.
;;; setting them to 500 and 395 puts origin in centre of screen.
;;; please try to vary these to minimise uneven wear on the scope.

vars gxorigin gyorigin;

;;; now two functions for transforming between user co-ordinates and screen
;;; co-ordinates. these are used in functions gptout and gincoords.

function gtransxyin x y;
  (x - gxorigin)/gxscale, (y - gyorigin)/gyscale
end;

function gtransxyout x y;
  if gxscale == 1 then x else x * gxscale close + gxorigin,
  if gyscale == 1 then y else y * gyscale close + gyorigin,
end;


;;; these can be redefined by the user for more complex transformations, e.g. for
;;; rotations.


;;; give default settings for the variables, unless the user has already assigned
;;; numbers to them.

unless gxorigin.isnumber then 495->gxorigin close;
unless gyorigin.isnumber then 385->gyorigin close;
unless gxscale.isnumber  then 1->gxscale close;
unless gyscale.isnumber  then 1->gyscale close;


;;; some procedures for manipulating the frame. the names should explain.

function gmirrorx;
 - gxscale ->gxscale;
end;

function gmirrory;
 - gyscale ->gyscale;
end;

function gstretchx n;
 n * gxscale -> gxscale;
end;

function gstretchy n;
 n * gyscale -> gyscale;
end;

function gstretch n;
 gstretchx(n); gstretchy(n);
end;

function gshiftby x y;
 ;;; move the users frame by x, y in screen coordinates.
 gxorigin + x -> gxorigin;
 gyorigin + y -> gyorigin;
end;

function gshiftr x;
 ;;; move user's origin by x user units, to the right.
  gxorigin + x * abs(gxscale) ->gxorigin
end;

function gshiftup y;
 ;;; move user's origin by y user units, upwards.
  gyorigin + y * abs(gyscale) ->gyorigin
end;

jumpto(0,0);

function turtle();
	greset();
	jumpto(0,0);
	0 -> heading;
end;

