;;;	/ p o p / u s r / l i b / g i n r e a d . p
;;;	A. Sloman				Jan 4th 1978
;;; facilities for reading in pictures from the tektronix 4012
vars gxscale;

Uses graphic;
 unless gxscale.isnumber then 1 ->gxscale close;


;;; the fuss in the middle of the next function is to do with
;;;  problems of noise on the line. if you dont get the cross-hairs when
;;;  expected, this is probably due to noise. typing carriage return will
;;;  output code 13 , causing appgin to cycle again.

function appgin dofn;
 vars wd i key;
 until key = `. then
   .setgin;
   .inascii ->wd; wd->key;
    forall i 1 1 5
       wd;
      if wd=13 then repeat i times .erase; close; goto l close;
     .inascii ->wd;
	l:
    close;
   .gincoords.dofn;
   .clrinputbuff;
 close;
end;

cancel wd i key dofn;


vars pictolerance; 5->pictolerance;

vars conspoint destpoint;
unless conspoint.isfunc then cons -> conspoint close;
unless destpoint.isfunc then dest -> destpoint close;

vars distance;
unless distance.isfunc then
	function distance(p1,p2);
		vars x1 y1 x2 y2;
		destpoint(p1) ->y1 ->x1;
		destpoint(p2) ->y2 ->x2;
		0.0 + (y2 - y1) ->y1;
		0.0 + (x2 - x1) ->x1;
		sqrt( x1 * x1 + y1 * y1)
	end;
close;

function ginread;
 ;;; read in a list of lists of points. when cross appears, 
;;;    set it and type a character: a dot for end of picture, a comma for
;;;    beginning of new sub-picture(i.e. do a jump, a question
;;;    mark to redo the last point, and a hash symbol to restart the
;;;    current sub-picture, from current coordinates
vars l; nil ->l;
 
  function dofn wd xin yin;
    vars pt; conspoint(xin,yin) ->pt;
    if wd= `, then l.rev;
     pt::nil ->l;
     jumpto(xin ,yin);drawto(xin,yin);
    elseif wd=`? then 
        pt ->hd(l);
        jumpto(destpoint(hd(tl(l))));
        drawto(xin,yin);
    elseif wd=`# or wd=`  and l=nil then
        pt::nil ->l;jumpto(xin,yin);drawto(xin,yin);
    elseif wd = `  then
        if atom(l) or distance(pt,hd(l)) > pictolerance/gxscale then 
                pt::l ->l;
        close;
       drawto(xin,yin);
    else .clrinputbuff; 	;;; ignore spurious signal
    close;
    if wd=`.  and l /= nil then l.rev; close;
  end;
  jumpto(graphx,graphy);
 [%appgin(dofn)%];
 .setvdu; 
end;

function helpgin;'\
space   = drawto current point\
,       = jumpto  c.p.\
?       = cancel last point\
#       = restart since last jump\
.       = finish picture\
'.prstring;
end;

function drawlist l;
 if l=nil then exit;
  jumpto(l.hd.destpoint);
  applist(l.tl, drawto)
end;

function drawpic l;
 ;;; l is a list of lists of points
 applist(l,drawlist);
 1.nl;
 .setvdu;
end;
