#include	"../h/local.h"
#include "pdp00.h"
#include "pdpex.h"
#include "../h/em1.h"

/*
 * EM1 - UNIX as translator
 *
 * make assembly_code
 * this routine calls the appropriate routine
 * or handles the EM1 instruction itself
 *
 */


make_code (alnp) line_t *alnp;{
	fake_t f;
	register fake_t *ftop;
	register mnem,off;
	line_t *fwp;
	int mnm;
	char *s;
	char sb[MAXSTRL];

	set_mode(TEXT);
	if (alnp->type1==GLOSYM) {
		f.offset=0;
		f.index = int_cast alnp->ad.ad_gp->g_name;
	} else {
		f.offset=alnp->ad.ad_i;
		f.index=0;
	}
	mnem = alnp->instr_num&0377;
	off = f.offset;
	f.type = REG;
	f.flags = INT;
	switch (mnem) {
	/*
	 * local label 'instruction' :
	 */
	case op_lab:
		empty_fake(ALL);
		plabel(locname((lbp_cast off)->l_val));
		coco = fake;
		break;
	/*
	 * LOAD GROUP :
	 */
	case op_lnc:
		f.offset = -f.offset;
	case op_loc:
		f.type = CONS;
		if (alnp->type1==PROCNAME) {
			/* very special: only for 'LOC $proname' */
			f.type=ADDREXT; /* fool things! */
			f.index = int_cast procdesc[off].p_name;
			f.offset=0;
		}
		pshfk(&f);
		break;
	case op_ldl:
		f.flags = 0;
	case op_lol:
		f.type = LOCL;
		pshfk(&f);
		break;
	case op_lde:
		f.flags = 0;
	case op_loe:
		f.type = EXT;
		pshfk(&f);
		break;
	case op_lae:
		f.type = ADDREXT;
		pshfk(&f);
		break;
	case op_lop:
		f.type = LOCL;
		f.flags =| IND;
		pshfk(&f);
		break;
	case op_lal:
		f.type = ADDRLOCL;
		pshfk(&f);
		break;
	case op_lof:
		if (off==0) {
			gen_loi(2);
			break;
		}
		make_int(1,SAVE_FAKE);
		mv_to_reg(fsp,ANY);
		fsp->offset=off;
		fsp->flags =| OFF;
		coco = fake;
		break;
	case op_lex:
		if (iregs[REG1]==FREE)
			f.index=REG1;
		else
			f.index = ANY;
		f.offset=0;
		getreg(&f,ONLY_REG);	/* 'link' register */
		s = str(&f);
		pshfk(&f); /*!*/
		coco = fsp;
		if (0 <= off && off <= 3) {
			if (off == 0)
				gen2(MOV,LB,s);
			else
				gen2(MOV,STATLB,s);
			if (off == 3)
				gen2(MOV,indreg(statd,fsp->index),s);
			if (off >= 2) {
				fsp->offset = statd;
				fsp->flags =| OFF;
				coco = fake;
			}
		} else {
			f.index = ANY;
			getreg(&f,ONLY_REG);
			gen2(MOV,LB,s);
			gen2(MOV,imm(off),str(&f)); /* count reg */
			plabel(TMP1);
			gen2(MOV,statreg(fsp->index),str(fsp));
			gen2(SOB,str(&f),B1);
		}
		break;
	case op_loi:
		gen_loi(off);
		break;
	case op_lai:
		to_reg0(0,ALL,imm(off));
		extsubr(".lai");
		break;
	case op_ldf:
		if (off) {
			f.type = CONS;
			pshfk(&f);
			add_sub(op_add);
		}
		gen_loi(4);
		break;
	case op_los:
	/*
	 * STORE GROUP
	 */
	case op_sts:
		ftop = to_reg0(2,ALL,0);
		f.index = REG2;
		move(ftop,&f);
		extsubr(mnem==op_los? ".los" : ".sts");
		iregs[REG2] = FREE;
		coco = fake;
		break;
	case op_sdf:
		if (off) {
			f.type = CONS;
			pshfk(&f);
			add_sub(op_add);
		}
		gen_sti(4);
		break;
	case op_stl:
		make_int(1,SAVE_FAKE);
		f.type = LOCL;
		goto casestore;
	case op_ste:
		make_int(1,SAVE_FAKE);
		f.type = EXT;
		goto casestore;
	case op_stp:
		make_int(1,SAVE_FAKE);
		f.flags =| IND;
		f.type = LOCL;
		goto casestore;
	case op_sdl:
	case op_sde:
		if (mnem==op_sdl)
			f.type = LOCL;
		else
			f.type = EXT;
		if (fsp->type==CONS && (fsp-1)->type==CONS
		   && fsp->flags==INT && (fsp-1)->flags==INT) {
			f.offset =+ 2;
			move(fsp--,&f);
			f.offset =- 2;
		} else {
			make_dbl(1);
			f.flags = 0;
		}
casestore:	ftop = fsp;
		if (fsp->type != STK){
			fsp--;
			if (mnem==op_stp)
				empty_fake(ALL);
			else
				empty_to(&f);
		} else if (mnem==op_stp)
			empty_fake(ALL);
		else {
			empty_to(&f);
			fsp--;
		}
		move(ftop,&f);
		coco = fake;
		break;
	case op_stf:
		make_int(2,EMPTY_FAKE);
		mv_to_reg(fsp,ANY);
		s = indreg(off,fsp->index);
		ftop = fsp--;
		if (fsp->type!=STK)
			fsp--;
		empty_fake(ALL);
		if ((--ftop)->type!=CONS || ftop->offset!=0) {
			checkint(ftop,ANY,ANY);	/* conversions! */
			gen2(MOV,str(ftop),s);
		} else
			gen1(op_zrl,s);
		clearegs();
		coco = fake;
		break;
	case op_sti:
		gen_sti(off);
		break;
	case op_sai:
		to_reg0(0,ALL,imm(off));
		extsubr(".sai");
		break;
	/*
	 * SINGLE PRECISION ARITHMETIC
	 */
	case op_add:
	case op_pad:
		add_sub(op_add);
		break;
	case op_sub:
	case op_psb:
		add_sub(op_sub);
		break;
	case op_mul:
		gen_mul();
		break;
	case op_div:
	case op_mod:
		div_mod(mnem);
		break;
	case op_shr:
	case op_shl:
	case op_rol:
	case op_ror:
		gen_ash(mnem);
		break;
	case op_neg:
	case op_inc:
	case op_dec:
	caseop_com2:
		make_int(1,SAVE_FAKE);
		mv_to_reg(fsp,ANY);
		gen1(mnem,str(fsp));
		coco = fsp;
		break;
	case op_exg:
		make_int(2,SAVE_FAKE);
		if ((fsp-1)->type == STK){
			if (fsp->type==REG)
				mv_to_reg(fsp-1,ANY);
			else
				if (fsp->type==STK){
					mv_to_reg(fsp,ANY);
					mv_to_reg(fsp-1,ANY);
				}
		}
		copyf(--fsp,&f);
		copyf(fsp+1,fsp);
		pshfk(&f);
		break;
	case op_adi:
		if (fsp->type == ADDREXT || fsp->type == ADDRLOCL)
			fsp->offset =+ off;
		else {
			if (off==1 || off== -1) {
				mnem = off==1?op_inc:op_dec;
				goto caseop_com2; /* sorry */
			}
			f.type = CONS;
			pshfk(&f);
			add_sub(op_add);
		}
		break;
	/*
	 * DOUBLE PRECISION ARITHMETIC
	 */
	case op_dad:
	case op_dsb:
	case op_dmu:
	case op_ddv:
	case op_dmd:
	case op_fif:
	case op_fef:
		empty_fake(mnem==op_fef?2:4);
		sb[0] = '.';
		strcpy(&sb[1],mnemon[mnem].m_name);
		extsubr(sb);
		if(mnem==op_fef) {
			stk.flags = INT; pshfk(&stk);
		} else if (mnem!=op_fif)
			popfk(2);	/* pop 2 words */
		coco = fake;
		break;
	/*
	 * FLOATING POINT ARITHMETIC
	 */
	case op_fad:
	case op_fsb:
	case op_fmu:
	case op_fdv:
		gen_flt(mnem);
		break;
	/*
	 * CONVERSION GROUP
	 */
	case op_cid:
	case op_cif:
		cif_cid(mnem);
		break;
	case op_cdi:
	case op_cfi:
	case op_cfd:
	case op_cdf:
		gen_cnv(mnem);
		break;
	/*
	 * BOOLEAN GROUP
	 */
	case op_and:
	case op_ior:
	case op_xor:
		if (off == 2) {
			if ((mnm=(fwp=forward())->instr_num&0377)
			        == op_zeq || mnm==op_zne){
				gen_bra(mnm,fwp->ad.ad_lp->l_val,2,mnem);
				nextline = fwp;
			} else if (mnm==op_teq||mnm==op_tne)
				gen_cmp(mnem);
			else if (mnem==op_ior)
				add_sub(BIS);
			else if (mnem==op_and)
				and_xor(BIC);
			else
				and_xor(XOR);
			break;
		}
	case op_ans:
	case op_ios:
	case op_xos:
		gen_boo(mnem,off);
		break;
	case op_com:
		if (off==2)
			goto caseop_com2;
		off =>> 1;
		ftop = to_reg0(0,off,imm(off));
		gen2(MOV,SPX,R1);
		plabel(TMP1);
		gen1(COM,autdec(REG1));
		gen2(SOB,R0,B1);
		coco = fake;
		break;
	case op_cos:
		ftop = to_reg0(1,ALL,0);
		extsubr(".com");
		coco = fake;
		break;
	/*
	 * SET GROUP
	 */
	case op_inn:
	case op_ins:
		if (mnem==op_inn)
			ftop = to_reg0(1,off,imm(off));
		else
			ftop = to_reg0(2,ALL,0);
		gen_inn(mnem,ftop,off);
		break;
	case op_set:
	case op_ses:
		if (off==2){
			make_int(1,EMPTY_FAKE);
			copyf(fsp,&f);
			fsp->type = CONS;
			fsp->flags = INT;
			fsp->offset = 1;
			fsp->index = 0;
			pshfk(&f);
			gen_ash(op_shl);
		} else {
			if (mnem==op_set)
				ftop = to_reg0(1,ALL,imm(off));
			else
				ftop = to_reg0(2,ALL,0);
			mv_to_reg(ftop,REG1);	/* bit nr to r1 */
			extsubr(".set");
			iregs[REG1] = FREE;
			coco = fake;
		}
		break;
	/*
	 * ARRAY GROUP
	 */
	case op_aar:
	case op_lar:
	case op_sar:
		if (alnp->type1==GLOSYM && alnp->ad.ad_gp->g_rom)
			/* : a 'ROM' glosym: pass globlabel pointer */
			arrspc(mnem,alnp->ad.ad_i);
		else
			gen_arr(mnem,to_reg0(2,ALL,adrext(off)));
		break;
	case op_aas:
	case op_las:
	case op_sas:
		gen_arr(mnem,to_reg0(3,ALL,0));
		break;
	/*
	 * COMPARISON GROUP
	 */
	case op_cmi:
		gen_cmp(mnem);
		break;
	case op_cmd:
		empty_fake(4);
		extsubr(".cmd");
		popfk(4);
		f.index=REG0;
		pshfk(&f);	/* test result in r0 */
		coco = fsp;
		break;
	case op_cmf:
		gen_cmp(op_cmf);
		break;
	case op_cmu:
	case op_cms:
		if (off==2)
			gen_cmp(op_cmu);
		else {
			if (mnem==op_cmu)
				ftop = to_reg0(0,off,imm(off));
			else
				ftop = to_reg0(1,ALL,0);
			extsubr(".cmu");
			popfk(off);	/* pop two groups of off words each */
			f.index = REG0;
			f.offset = 0;
			pshfk(&f);	/* test result in r0 */
			coco = fsp;
		}
		break;
	case op_cmp:
		gen_cmp(op_cmu);	/* same as CMU 2 */
		break;
	case op_tlt:
	case op_tle:
	case op_teq:
	case op_tne:
	case op_tge:
	case op_tgt:
		gen_tst(mnem);
		break;
	/*
	 * BRANCH GROUP
	 */
	case op_brf:
	case op_brb:
		gen_bra(mnem,(lbp_cast off)->l_val,0,0);
		break;
	case op_blt:
	case op_ble:
	case op_beq:
	case op_bne:
	case op_bge:
	case op_bgt:
		gen_bra(mnem,(lbp_cast off)->l_val,2,op_cmi);
		break;
	case op_zlt:
	case op_zle:
	case op_zeq:
	case op_zne:
	case op_zge:
	case op_zgt:
		gen_bra(mnem,(lbp_cast off)->l_val,1,0);
		break;
	/*
	 * PROCEDURE CALL GROUP
	 */
	case op_mrk:
	case op_mrs:
		empty_fake(ALL);
		if (mnem==op_mrk)
			gen_mrk(off);
		else {
			gen2(MOV,LB,PSH);
			coco = fake;
		}
		break;
	case op_cal:
		empty_fake(ALL);
		gen2(JSR,PC,procdesc[off].p_name);
		coco = fake;
		break;
	case op_cas:
		gen_loi(2);	/* one indirection more:
				cf. operation JSR instruction */
		ftop=fsp--;
		empty_fake(ALL);
		gen2(JSR,PC,str(ftop));
		free_reg(ftop);
		coco = fake;
		break;
	case op_ret:
		if (off =>> 1)
			set_to_stk(off);
		switch (off){
		case 0: extjump(".ret0");
			break;
		case 1: make_int(1,SAVE_FAKE);
			if (fsp->type==STK || fsp->flags & CONV)
				mv_to_reg(fsp,ANY);
					/* save top (result) word */
			gen_ret(1);
			break;
		case 2: make_dbl(1);
			if (fsp->type==STK || fsp->flags & CONV){
				f.flags = f.offset = 0;
				fsp->index = 0;
				move(fsp,&f);
				/* save top ('double' result) in fr0 */
			}
			gen_ret(2);
			break;
		default:ftop = to_reg0(0,off,imm(off<<1));
			extjump(".ret");
		}
		fsp = fake; /* just put fake to empty!! */
		clearegs();
		coco = fake;
		break;
	case op_res:
		ftop = to_reg0(1,ALL,0);
		extjump(".ret");
		fsp = coco = fake;
		clearegs();
		break;
	/*
	 * INCREMENT/DECREMENT/ZERO GROUP
	 */
	case op_inl:
	case op_del:
	case op_zrl:
		f.type = LOCL;
		empty_to(&f);
		gen1(mnem,str(&f));
		coco = fsp;
		break;
	case op_ine:
	case op_dee:
	case op_zre:
		f.type = EXT;
		empty_to(&f);
		gen1(mnem,str(&f));
		coco = fsp;
		break;
	/*
	 * MISCELLANEOUS
	 */
	case op_beg:
		empty_fake(ALL);
		switch (off) {
		case 2: gen1(TST,PSH);
			break;
		case -2:gen1(TST,POP);
			break;
		case 4: gen2(op_cmi,PSH,PSH);
			break;
		case -4:gen2(op_cmi,POP,POP);
			break;
		default:gen2(op_add,imm(off),SPX);
		}
		/*
		 * No SP - check
		 */
		coco = fake;
		break;
	case op_bes:
		make_int(1,EMPTY_FAKE);
		ftop = fsp--;
		empty_fake(ALL);
		mv_to_reg(ftop,ANY);
		gen2(op_add,str(ftop),SPX);
		if (ftop->type==REG)
			iregs[ftop->index] = FREE;
		coco = fake;
		break;
		/***
	case op_rcs:
	case op_rck:
		if (mnem==op_rck) {
			f.index = REG0;
			f.offset = 0;
			getreg(&f,ONLY_REG);
			gen2(MOV,adrext(off),R0);
			iregs[REG0] = &f;
			make_int(1,SAVE_FAKE);
		} else {
			make_int(2,SAVE_FAKE);
			mv_to_reg(fsp--,REG0);
		}
		mv_to_reg(fsp,REG1);
		extsubr(".rck");
		iregs[REG0] = FREE;
		break;
		***/
	case op_rcs:
		make_int(1,SAVE_FAKE);
		popfk(1);
		break;
	case op_rck:
	case op_nop:
		break;
	case op_blm:
	case op_bls:
		gen_blm(mnem,off);
		coco = fake;
		break;
	case op_lin:
		gen2(MOV,imm(off),"eb");
		coco = fake;
		break;
	case op_lni:
		gen1(op_ine,"eb");
		coco = fake;
		break;
	case op_dup:
		if (off<=0)
			break;
		if (off==2) {
			dupspc();
			break;
		}
	case op_dus:
		if (mnem==op_dup)
			ftop = to_reg0(0,ALL,imm(off));
		else
			ftop = to_reg0(1,ALL,0);
		extsubr(".dup");
		coco = fake;
		break;
	case op_csa:
	case op_csb:
		empty_fake(ALL);
		extjump(mnem==op_csa ? ".csa" : ".csb");
		break;
	case op_lor:
	case op_str:
		gen_rgs(mnem,off);
		break;
	case op_hlt:
		empty_fake(ALL);
		extjump(".hlt");
		break;
	/*
	 * TRAP HANDLING
	 */
	case op_rtt:
		empty_fake(ALL);
		extjump(".rtt");
		break;
	case op_sig:
	case op_trp:
		empty_fake(ALL);
		sb[0] = '.';
		strcpy(&sb[1],mnemon[mnem].m_name);
		extsubr(sb);
		break;
	/*
	 * MONITOR GROUP
	 */
	/* STU,RTI, .... */
	case op_nul:
	case op_min:
		return;
	default:
		error("illegal EM1 instruction in PDP",0);
	}
}
