#include	"../h/local.h"
#include "pdp00.h"
#include "pdpex.h"
#include "../h/em1.h"

/*
 * (c) copyright 1980 by the Vrije Universiteit, Amsterdam, The Netherlands.
 * Explicit permission is hereby granted to universities to use or duplicate
 * this program for educational or research purposes.  All other use or dup-
 * lication  by universities,  and all use or duplication by other organiza-
 * tions is expressly prohibited unless written permission has been obtained
 * from the Vrije Universiteit. Requests for such permissions may be sent to
 * 
 *      Dr. Andrew S. Tanenbaum
 *      Wiskundig Seminarium
 *      Vrije Universiteit
 *      Postbox 7161
 *      1007 MC Amsterdam
 *      The Netherlands
 * 
 * Organizations wishing to modify part of this software for subsequent sale
 * must  explicitly  apply  for  permission.  The exact arrangements will be
 * worked out on a case by case basis, but at a minimum will require the or-
 * ganization to include the following notice in all software and documenta-
 * tion based on our work:
 * 
 *           This product is based on the Pascal  system  developed  by
 *      Andrew  S.  Tanenbaum, Johan W. Stevenson and Hans van Staveren
 *      of the Vrije Universiteit, Amsterdam, The Netherlands.
 */
/*
**      Optimizing translator EM1 - UNIX-as
**
**      Written by Ard Verhoog
**                 Hans van Staveren
**                 Albert Montijn
**
**      Amsterdam, Apr 1979
**      Vrije Universiteit, vakgroep Informatika
**
*/

/*
** Main routine of EM1-PDP11-translator
*/

char *f_pdpcode;

main(argc, argv) int argc; char **argv; {

	progname = argv[0];
	arguments(argc, argv);
	init_vars();
	init_code();

	do
		translate();
	while (!eof_seen);
	finish_up();
}

/*
** process arguments
*/
arguments(argc, argv) int argc; char **argv; {
	register char	*argp;
	register fd;

	while (--argc && **++argv == '-'){
		argp = *argv;
		while (*++argp) {
			switch(*argp) {
			case 'd':
				dumps++;
				break;
			case 'o':
				f_pdpcode = *++argv;
				argc--;
				break;
			case '?':
				break; /* aid for calling C-program */
			default:
				fatal("only flags -[do] allowed");
			}
		}
	}
	if (argc>0) {
		if ((fd = open(argv[0],0)) < 0) /* compactcode input */
			fatal("cannot open input file");
	} else
		fd = 0;
	finit(&stdin,fd);
	if(readword()!=CCMAGIC)
		fatal("input file: bad format");
	if (f_pdpcode) {
		if ((fd = creat(f_pdpcode,0644)) < 0)
			fatal("cannot create output file");
	} else
		fd = 1;
	finit(&stdout,fd);
}

init_vars() {

	statd = -4;	/* !! NB. this variable MUST have the same
				  value as the assembly '.globl statd'.
				  See the startoffs for executable
				  em1 programs.
			!! */
	inpoff = -1;
	uniquelocs = 1;
	last_proc = procdesc-1;
}

init_code(){
	pputs(".globl eb,dynd,statd,statd2\nl=r4\ns=r5\n");
}

finish_up() {
	module[0]=0;
	pro_check();
	glo_check();
	flush();
	exit(error_count != 0);
}
