/ (c) copyright 1980 by the Vrije Universiteit, Amsterdam, The Netherlands.
/ Explicit permission is hereby granted to universities to use or duplicate
/ this program for educational or research purposes.  All other use or dup-
/ lication  by universities,  and all use or duplication by other organiza-
/ tions is expressly prohibited unless written permission has been obtained
/ from the Vrije Universiteit. Requests for such permissions may be sent to
/ 
/      Dr. Andrew S. Tanenbaum
/      Wiskundig Seminarium
/      Vrije Universiteit
/      Postbox 7161
/      1007 MC Amsterdam
/      The Netherlands
/ 
/ Organizations wishing to modify part of this software for subsequent sale
/ must  explicitly  apply  for  permission.  The exact arrangements will be
/ worked out on a case by case basis, but at a minimum will require the or-
/ ganization to include the following notice in all software and documenta-
/ tion based on our work:
/ 
/           This product is based on the Pascal  system  developed  by
/      Andrew  S.  Tanenbaum, Johan W. Stevenson and Hans van Staveren
/      of the Vrije Universiteit, Amsterdam, The Netherlands.


/------------------------------------------------------------------------------
/	This is an interpreter for EM1 programs with no virtual memory
/
/	Author:	Hans van Staveren
/		Vrije Universiteit
/		Amsterdam
/
/	Memory layout:
/
/	|text|data|      bss      |  unused  |          stack             |
/	___________________________________________________________________
/	|            |       |    |          | |    |     |            |  |
/	|            |       |    |          | |    |     |            |  |
/	|      1     |   2   |  3 |          |4|  5 |  6  |      7     | 8|
/	|            |       |    |          | |    |     |            |  |
/	|____________|_______|____|__________|_|____|_____|____________|__|
/
/	1:	Interpreter text+data
/	2:	EM1 global data area
/	3:	EM1 local data area
/	4:	interpreter stack
/	5:	EM1 heap data area
/	6:	flow/count/profile tables
/	7:	EM1 text
/	8:	Arguments to interpreter
/
/	Assembly time flags:
/	.debug : controls self checking and trace-printout
/	.test  : controls checking for undefined variables,nil pointers,
/		 array indices, etc....
/	.extra : controls checking for bad instruction arguments, and
/		 in general compiler errors
/	.prof  : controls generation of a runtime profile
/	.opfreq: controls runtime frequency count per opcode
/	.flow  : controls generation of a flow bitmap
/	.count : controls generation of a flow count
/	.last  : controls generation of file with last 64 lines executed
/
/	Register layout:
/	spx = EM1 stackpointer
/	pcx = EM1 programcounter
/	lb  = EM1 base-address
/	nxt = address of start of interpreter loop
/
/	The general structure of this interpreter is as follows:
/	The opcode byte of the instruction is placed in r0
/	with sign-extension and multiplied by 2.
/	If .opfreq is nonzero each occurence of each opcode is counted.
/	Then, if .prof is nonzero an estimation of the time required
/	to execute the instruction is added to a counter associated
/	with the source-line number. This estimation is roughly the
/	number of memory-cycles needed. At the end of this accounting
/	r1 points to the loword of the double precision counter.
/	This can be used by individual execution routines to add some
/	more to the counter depending on their operand.
/
/	NOTE: This interpreter can be loaded in separate I and D space
/	      except when assembled with .debug=1
/
/
/------------------------------------------------------------------------------
/	Declaring of some constants
/------------------------------------------------------------------------------

	.debug	= 0
	.opfreq	= 0
	.last	= 1

	spx	= r5
	nxt	= r4
	pcx	= r3
	lb	= r2

	statd	= -8.

	memincr	= 400		/ additional memory asked on stack overflow
	unixextra= 1280.	/ extra stack forced by UNIX at r6-stckovf
	und	= 100000	/ undefined memory pattern
	common	= 134.		/ common opcodes for different contexts
	.bigcomm= 1		/ set to 1 if common>127
	signext = 177400	/ high bits for signextension
	EINVAL	= 22.		/ UNIX error code for bad signal
	secret1	= 125252	/ alternating secret pattern
	secret2	= 052525	/ idem

/------------------------------------------------------------------------------
/	constants fm_xxx, for xxx some EM1-mnemonic, give the base of
/	the minis for that instruction. If the base is >= 128 the
/	constant signext must be added.
/	n.b. fm stands for "first mini"
/------------------------------------------------------------------------------

	fm_inl	= 188. + signext
	fm_ior	= 157. + signext
	fm_lae	= 100.
	fm_laes	= 113.
	fm_lal	= 92.
	fm_ldl	= 148. + signext
	fm_loc	= 1.
	fm_loe	= 56.
	fm_lof	= 80.
	fm_loi	= 123.
	fm_lol	= 39.
	fm_stf	= 209. + signext
	fm_stl	= 217. + signext
/
/------------------------------------------------------------------------------
/	The constants ac_xxx, for xxx some EM1-mnemonic, give the extra
/	number of memory cycles needed for an increase of the parameter
/	of the instruction by one.
/	Usage:	mov	$ac_xxx,-(sp);	jsr	pc,account
/------------------------------------------------------------------------------

	ac_loi	= 4
	ac_sti	= 4
	ac_cmu	= 5
	ac_and	= 6
	ac_ior	= 4
	ac_xor	= 5
	ac_com	= 3
	ac_dup	= 4
	ac_blm	= 4
	ac_mrk	= 4
	ac_beg	= 3
	ac_ret	= 4
	ac_lex	= 4
	ac_set	= 3
	ac_lai	= 4
	ac_sai	= 4

/------------------------------------------------------------------------------
/	EM1 machine errors (in the range 0-63)
/------------------------------------------------------------------------------

	ESTACK	= 0.
	EHEAP	= 1.
	EILLINS	= 2.
	EODDZ	= 3.
	ECASE	= 4.
	ESET	= 5.
	EARRAY	= 6.
	ERANGE	= 7.
	EIOVFL	= 8.
	EDOVFL	= 9.
	EFOVFL	= 10.
	EFUNFL	= 11.
	EIDIVZ	= 12.
	EFDIVZ	= 13.
	EIUND	= 14.
	EDUND	= 15.
	EFUND	= 16.
	ECFI	= 17.
	ECFD	= 18.
	ECDI	= 19.
	EFPP	= 20.
	ELIN	= 21.
	EMON	= 22.
	ECAL	= 23.
	ELAE	= 24.
	EMEMFLT	= 25.
	EPTR	= 26.
	EPROC	= 27.
	EPC	= 28.

/------------------------------------------------------------------------------
/	Declaring of some instructions unknown to the assembler
/------------------------------------------------------------------------------

	next	= 10407		/ = mov nxt,pc; jump to appropriate decode loop
	rti	= 2		/ return from interrupt
	iot	= 4		/ force core dump
	stst	= 170300^tst	/ store floating point status
	indir	= 0		/ for sys indir
	exit	= 1
	fork	= 2
	read	= 3
	write	= 4
	open	= 5
	close	= 6
	creat	= 8.
	break	= 17.
	alarm	= 27.
	pause	= 29.
	sleep	= 35.
	signal	= 48.

/------------------------------------------------------------------------------
/	External references
/------------------------------------------------------------------------------

	.globl	_end

/
/------------------------------------------------------------------------------
/	Now the real program starts
/------------------------------------------------------------------------------

startoff:
	mov	sp,r0
	mov	sp,pcxlim
	dec	(r0)
	mov	(r0)+,argc	/ pass to userprogram later
	jle	noarg
	tst	(r0)+		/ skip interpreter name
	mov	r0,argv		/ pass to userprogram later
	mov	(r0),2f+2
.if V7
1:	tst	(r0)+
	bne	1b
	mov	r0,environ
.endif
	sys	indir;2f
	.data
2:	sys	open;0;0
	.text
	jes	badarg
	mov	r0,r5		/ save filedescriptor
	sys	read;header;16.	/ skip first header
	jes	badarg
	mov	r5,r0
	sys	read;header;16.	/ read second header
	jes	badarg		/ failed
	cmp	r0,$16.		/ long enough ?
	jne	badarg		/ no.
	sub	txtsiz,sp	/ reserve space for code
	tst	(sp)		/ notify system
	mov	sp,pb		/ set up procedure base
	mov	txtsiz,1f+4	/ set up for read
	mov	sp,1f+2		/ almost done
	mov	r5,r0		/ done !
	sys	indir;1f	/ this is it folks
	.data
1:	sys	read;0;0	/ read call
	.text
	jes	badarg		/ read failed
	cmp	r0,txtsiz	/ all code available ?
	jne	badarg		/ no
	mov	nprocs,r4
	ash	$2,r4		/ number of bytes
	sub	r4,sp		/ reserve space
	mov	sp,pd		/ base of descriptors (later)
	sub	$518.,sp	/ reserve space for input buffer
	mov	sp,r4		/ r4=pointer to input buffer
	tst	(sp)		/ get core from system
	mov	r5,(r4)		/ filedescriptor
	clr	2(r4)		/ number of words left in buffer
	add	$memincr,sybreak+2 / a bit extra for the stack
	sys	indir;sybreak	/ Ask for the core
	jes	toolarge	/ Too much, sorry
	mov	$_end,spx	/ setup stack pointer
	mov	spx,eb		/ setup external base
	sys	signal;11.;sig11	/ catch segmentation violation
	sys	signal;12.;sig12	/ catch bad system calls
.if .float
.if 1 - HARDWARE_FP
	.globl	fptrap
	sys	signal;4;fptrap
.endif
.if SFLOAT
	ldfps	$7400
.endif
.if 1 - SFLOAT
	ldfps	$7600
.endif
	sys	signal;8.;sig8	/ catch floating exception
.endif
	jsr	pc,readdata	/ read in datasegment
	mov	nprocs,r2	/ count
	mov	pd,r1		/ base for descriptors
1:	jsr	pc,getword	/ number of bytes of parameters
	mov	r0,(r1)+
	jsr	pc,getword	/ offset from pb
	add	pb,r0
	mov	r0,(r1)+
	sob	r2,1b

	mov	(r4),r0		/ filedescriptor of input
	sys	close
	add	$518.,sp	/ remove buffer
	mov	eb,r0
	clr	(r0)+		/ linenumber
	mov	argc,(r0)+
	mov	argv,(r0)+
	mov	environ,(r0)+

.if .prof + .flow + .count
	mov	sp,r4		/ save previous stackpointer
.if .prof
	mov	nlines,r0
	inc	r0
	asl	r0
	asl	r0
	sub	r0,sp
	mov	r0,profsiz
	mov	sp,ltime	/ set up pointer
.endif
.if .flow
	mov	nlines,r0
	ash	$-3,r0		/ divide by 8
	add	$2,r0
	bic	$1,r0		/ Rounded up to an integral number of words
	