#include	"../h/local.h"
#include	"ass00.h"
#include	"assex.h"
#include	"../h/em1.h"
/*
** Pass 5 of EM1 assembler/loader
** Fix reloc tables
** Write out code
*/

pass_5() {
	register line_t	*lnp;
	register mnem_t	*mnp;
	int off1;
	char defined,opc;
	int afterlength,ope;

	pass = 5;
	afterlength = 0;
	for (lnp=line,line_num=1;lnp<=last_line;lnp++,line_num++) {
		off1 = offset(lnp,&defined);
		ope  = lnp->instr_num&0377;
		mnp  = &mnemon[ope];
		if (defined != 2)	/* check and manipulate parameter */
		    switch (mnp->m_flags&MNXYZ) {
		    case MN0:	break;
		    case MNY:	if (off1==1)
					    off1=0;
				else {
		    case MNX:	    if (odd(off1))
					    error("No odd address allowed here",0);
				    off1 =>> 1;
				}
				break;
		    case MNZ:	break;
		    }
		switch (lnp->format) {
		case F00:case FNN:case FEN:case FNL:case FEL:
			opc=mnp->m_obase;
			break;
		case FNS:case FES:
			opc=mnp->m_sbase;
			break;
		case FNM:
			opc=mnp->m_mbase;
			break;
		default:
			fatal("bad format during table-lookup");
		}
		afterlength =+ lnp->length;

		/* 
		 * Change absolute offset to a relative for branches.
		 */



		if ((mnp->m_flags&MNABCEM)==MNB) {
			off1 =- afterlength;
			if (ope == op_brb)
				off1 = -off1;
			if (off1<0)
				error("negative branch",0);
		}


		/*
		 * Real code generation.
		 */

		switch (lnp->format) {
		case F00:	break;
		case FEN:	outbyte(ESC);
		case FNN:	outbyte(opc); break;
		case FEL:	outbyte(ESC);
		case FNL:	outbyte(opc);
				if (defined == 2) {
					text_reloc(lnp->ad.ad_gp,
					  textbytes+afterlength-2,
						mnp->m_flags&MNXYZ);
					outword(0);
				} else
					outword(off1);
				break;
		case FES:	outbyte(ESC);
		case FNS:	outword(off1 + (opc<<8));
				break;
		case FNM:	if (mnp->m_flags&MNO)
					--off1;
				outbyte(opc+off1); break;
		default:fatal("Bad format during codegen");
		} /* end switch */
	} /* end forloop */

	patchcase();
	textbytes =+ prog_size;

} /* end pass_5 */

patchcase() {
	register relc_t  *r;
	register locl_t *k;

	for(r=datareloc; r < nxdatareloc; r++)
		if (r->r_typ == RELLOC) {
			r->r_typ = RELCON;
			k = r->r_val.rel_lp;
			if (k->l_defined)
				r->r_val.rel_i = k->l_val;
			else
				error("case label undefined",0);
		}
}
