#

# include	"mas0.h"



char	*mas2	"/lib/mas2";		/* mod016 */
char	*symtmp, *fbtmp;
int	sfile, fbfile;

char	*itmp, *atmp, *etmp;
int	afile, efile, ifile;
int	acount, icount;

char	*ltmp;

extern	struct aform abuf[];
extern	struct iform ibuf[];
struct	aform *abptr;
struct	iform *iptr;

FILE * input;
char	*fins;
FILE	*tsav;				/* mod12 */
int	tsavlc;
char	*tsavfn;
extern	struct symbol symtab[];
extern	hashtab[];
extern	mnemlook();

struct	evalx r;

extern	struct fb fbtable[];

struct	expr exptab[10];


struct	segment segopt;



extern	curfb[];
int	nextfb;
int	lc,errc,err2;
int	eis;				/* mod016 */

int	ppc,pc_def;
int	numsym;
char	tch;
int	lab;
int	accvalid;
int	gargc;
char	**gargv;
extern	char symbuf[];
jmp_buf env;

mexit()				/* mod002 */
{
	signal(2,1);
	signal(3,1);
	unlink(ltmp);
	unlink(symtmp);
	unlink(fbtmp);
	unlink(itmp);
	unlink(atmp);
	unlink(etmp);
	exit();
}

main(argc, argv)
char **argv;
{
register char c;
register *n, l;		/* mod005 */

	gargc = argc -1;	/* mod016 - used by argproc & newfile */
	gargv = &argv[1];	/* mod016 */
	argproc();		/* mod016 */

	signal(2,mexit);
	signal(3,mexit);	/* mod002 */

	input = NULL;		/* so that i-o channels not closed */	/* mod007 */
	if (newfile() == 0) exit();

	ltmp = "/tmp/motma.5";	/* lock file */
	c = 'a';
	while (creat(ltmp, 0000) == -1)
		if ((ltmp[9] = ++c) > 'z') help();

	symtmp = "/tmp/motmx.0"; symtmp[9] = c;
	fbtmp = "/tmp/motmx.1";  fbtmp[9] = c;
	itmp = "/tmp/motmx.2";   itmp[9] = c;
	atmp = "/tmp/motmx.3";   atmp[9] = c;
	etmp = "/tmp/motmx.4";   etmp[9] = c;

	if ((afile = creat(atmp,0600)) == -1 ||		/* NOTE : ONLY OPENED FOR WRITING */
	     (efile = creat(etmp,0600)) == -1 ||
	     (ifile = creat(itmp,0600)) == -1)  help();

	close(afile); close(efile);
	if ((afile = open(atmp,2)) == -1 ||		/* now readable too */
	     (efile = open(etmp,2)) == -1)  help();

	abptr = abuf; iptr = ibuf;

	numsym = 1;
	pc_def = ABS;
	nextfb = 20;

	for (l=0; l<20; l++) curfb[l] = l;		/* mod005 */

	if ((c = getch()) == '#')		/* mod005 */
	{
		lc++;
		while ((c = getch()) == SP || c == TAB);
		if (getsym(c) != 3 || mnemlook() != o_SEG || tch != SP && tch != TAB) segerr();
		while (((c = getch()) == SP) || (c == TAB));
		if ((l = getsym(c)) == 0)
		{
			if (tch != MINUS || (l = getsym(0)) == 0) segerr();
			segopt.segtype = 2;
		}
		else segopt.segtype = 1;

		if (l != 1) segerr();
		c = symbuf[0];
		if (DIGIT(c)) segerr();
		segopt.segchar = c;
		segopt.segcount++;
		getcomm();
	}
	else
	{

		ungetc(c, input);
	}

	setjmp(env);
	for(;;)			/* start of main loop when NL read */
	{
		lc++;
		lab = 0;
		if ((c = getch()) == EOF)
		{
			if (newfile()) continue;
			break;
		}
		if (c == NL) continue;
		if (c == STAR)
		{
			tch = c;
			getnl();		/* no return */
		}
		if (c != SP && c != TAB && (c = getlabel(c)) == NL) continue;
		while (((c = getch()) == SP) || (c == TAB));
		if (c == NL) continue;
		if (c == EOF) eoferr();
		getmnem(c);	/* read operator field */
		getcomm();
	}

	pass1a();		/* pass1 completed */
	newif(i_REL);

	if (err2) mexit();	/* don't run pass2 if errors */	/* mod002 */

	close(afile); unlink(atmp);
	close(efile); unlink(etmp);

	write(ifile, ibuf, icount<<2);		/* write rest of long form */
	close(ifile);

	if ((sfile = creat(symtmp,0600)) == -1 ||
		(fbfile = creat(fbtmp,0600)) == -1) help();
	write(fbfile, fbtable, nextfb<<2 );
	write(sfile, hashtab, 256);
	write(sfile, symtab, numsym * sizeof symtab[0]);	/* mod006 */

	close(fbfile); close(sfile);

	argv[argc] = 0;
	argv[0][0] = ltmp[9];
	execv(mas2, argv);
	printf("%s is missing !!\n", mas2);
	mexit();			/* mod002 */
}



argproc()		/* mod016 */
{
	register fcnt;
	register char c, **i;
	static char usage[] "Usage: mas [-e] [-l[name]] [-o[name]] files\n";

	fcnt = 0;
	i = gargv;
	while (*i != 0)
	{
		if (i[0][0] == '-')
		{
			if ((c = i[0][1]) == 'e') eis = 1;
			else if (c == 'x')
				if (i[0][2]) mas2 = &i[0][2];
				else mas2 = "mas2";
			else if (c != 'l' && c != 'o')
			{
				printf(usage);
				exit(1);
			}
		}
		else fcnt++;
		i++;
	}
	if (fcnt == 0)
	{
		printf(usage);
		exit(1);
	}
}



newfile()				/* mod016 */
{
	register *ip, *tp;

	if(input != NULL)
		fclose(input);				/* mod005, mod011 */
	if (tsav != NULL)
	{
		input = tsav;
		fins = tsavfn;
		lc = tsavlc;
		errc = 0;
		tsav = NULL;
		return(1);
	}
	while (gargc--)
	{
		fins = *gargv++;
		if (*fins == '-') continue;
		if ((input = fopen(fins, "r")) == NULL)
		{
			printf("Cannot open: %s\n", fins);
			continue;
		}
		lc = 0;
		errc = 0;
		return(1);
	}
	return(0);
}



getlabel(ch)
char ch;
{
	register char c;
	register l;

	if ((l = getsym(c = ch)) == 0) syntax();
	if (DIGIT(c))
	{
		if (l != 1) syntax();
		deffb(c - '0');
	}
	else if (accsym(l,c)) error("acc symbol"); else defsym();

	if ((c = tch) == NL || c == TAB || c == SP || c == COLON) return c;
	syntax();
}



getmnem(ch)
char ch;
{
	register char acc;
	register n;

	if ((n = getsym(ch)) == 4)
	{
		if ((acc = accsym(1, symbuf[3])) == 0) syntax();
		symbuf[3] = 0;
	}
	else if (n != 3) syntax(); else acc = 0;

	if ((n = mnemlook()) == -1)			/* mod017 */
	{
		error("mnemonic");
		getnl();		/* no return */
	}

	if (n < 0)			/* 6801 instruction */
	{
		if (! eis) weis();
		n =& 0x7f;
	}
	if (acc && (n > o_PUSH)) syntax();

	switch (n)
	{
    case o_INH:		if (acc || (tch > SP)) syntax();
			ppc++;
			return;

    case o_DUAL:	if (!acc) acc = getacc();
			if (acc > B) syntax();
			getimm(2);
			return;

    case o_ADDD:	if (!acc) acc = getacc();	/* add, sub */
			if (acc <= B) getimm(2);
			else if (acc == D) getimm(3);
			else syntax();
			return;

    case o_STA:		if (!acc) acc = getacc();		/* sta ONLY */
			if (acc > B) syntax();
			getdirec(0);
			return;

    case o_AEI:		if (acc)
			{
				if (acc > B) syntax();
				ppc++;
			}
			else
			{
				accvalid = n;
				getind(0);
				accvalid = 0;
			}
			return;

    case o_LSLD:	if (acc)			/* lsl, lsr, asl */
			{
				if (acc == X) syntax();
				ppc++;
			}
			else
			{
				accvalid = n;
				getind(0);
				accvalid = 0;
			}
			return;

    case o_PUSH:	if (!acc) acc = getacc();	/* psh and pul */
			if (acc == D) syntax();
			ppc++;
			return;

    case o_IDEI:	getimm(3);	/* ldx, lds & ldd - 16 bit immediate operand */
			return;

    case o_DEI:		getdirec(0);		/* stx, sts & std */
			return;

    case o_JMPS:	getind(0);
			return;

    case o_BNCH:	getexpr(0);
			ppc =+ 2;
			return;

    default:		if (n > 50)		/* assembler directive */
			{
				pseudop(n);
				return;
			}
			getexpr(0);		/* else o_JBRS, o_JEQS */
			if (n == o_JBRS)
			{
				outaform(a_JBRS);
				ppc =+ 3;
			}
			else
			{
			 	outaform(a_JEQS);
				ppc =+ 5;
			}
			pc_def = EST;
	}
}




outaform(at)
{
	register n;
	register struct expr *x;
	register struct aform *ab;

	ab = abptr;
	ab->a_pc = ppc;
	ab->a_def = n = at;
	if (n >= a_EQU || n == a_JEQS || n == a_JBRS)
	{
		for (x = exptab; x->e_rator; x++);
		x++;
		write(efile, &exptab[0], (x-&exptab[0]) << 2);
	}

	abptr++;
	if (++acount == 128)
	{
		write(afile, abuf, 512);
		acount = 0;
		abptr = abuf;
	}
}



defsym()
{
	register struct symbol *sym;

	sym = &symtab[(lab = lookup())];
	if (sym->s_def) error("multiply defined label");
	else
	{
		sym->s_def = pc_def;
		sym->s_pc = ppc;
	}
}



deffb(ind)
{
	register struct fb *fbp;
	register i, n;

	if (nextfb >= NFB-1) fberr();		/* mod008 */
	i = ind;
	n = curfb[i] = curfb[i+10];
	fbp = &fbtable[n];
	fbp->fb_pc = ppc;
	fbp->fb_def = pc_def;
	n = curfb[i+10] = nextfb++;
	fbp = &fbtable[n];
	fbp->fb_lab = i;
}



txterr()
{
	error("included file"); mexit();	/* mod011 */
}



segerr()
{
	error("seg"); mexit();		/* mod002 */
}



syntax()
{
	error("syntax"); getnl();
}



numerr()
{
	error("number"); getnl();
}


charerr()
{
	error("illegal char"); getnl();
}


parerr()
{
	error("')' missing"); getnl();
}



eoferr()
{
	error("eof ?"); mexit();	/* mod002 */
}



help()
{
	printf("help: can't open temp files\n"); mexit();		/* mod002 */
}



error(s)
char *s;
{
	if (errc++ == 0) printf("%s:\n", fins);
	printf("%5d\t%s\n", lc, s);
	err2++;
}


syserr(n)							/* mod018 */
{
	if (errc == 0) printf("%s:\n", fins);
	printf("%5d\tassembler error %d\n", lc, n);
	mexit();
}



relerr(s)
char *s;
{
	error(s); mexit();		/* mod002 */
}


symtblerr()					/* mod008 */
{
	error("symbol table overflow"); mexit();
}


fberr()						/* mod008 */
{
	error("temp. symbol table overflow"); mexit();
}


weis()					/* mod016 */
{
	error("WARNING: 6801 instruction");
}


