# include <stdio.h>
# include "signal.h"

# include "mfile1"

int proflag;
int strftn = 0;
#ifndef DELETE
int longftn = 0;
#endif
FILE *tmpfile;
FILE *outfile = stdout;

branch( n ){
	/* output a branch to label n */
	/* exception is an ordinary function branching to retlab: then, return */
	if( n == retlab && !strftn  ){
		PRINTF("\ttfr\tu,s\n");
		PRINTF("\tpuls\ty,u\n");
		PRINTF("\trts\n");
		}
	else PRINTF( "\tjbr\tL%d\n", n );
	}

int lastloc = PROG;

defalign(n) {
	/* cause the alignment to become a multiple of n */
	n /= SZCHAR;
/*
	if( lastloc != PROG && n > 1 ) PRINTF( "	.even\n" );
*/
	}

locctr( l ){
	register temp;
	/* l is PROG, ADATA, DATA, STRNG, ISTRNG, or STAB */

	if( l == lastloc ) return(l);
	temp = lastloc;
	lastloc = roflag? PROG:l;
	switch( l ){

	case PROG:
		outfile = stdout;
		PRINTF( "\t.text\n" );
		break;

	case DATA:
	case ADATA:
		outfile = stdout;
		if(temp != DATA || temp != ADATA)
			if(roflag)
				PRINTF("\t.text\n");
			else
				PRINTF( "\t.data\n" );
		break;

	case STRNG:
	case ISTRNG:
		outfile = tmpfile;
		if(roflag)
			fprintf(outfile, "\t.text\n");
		else
			fprintf(outfile, "\t.data\n");
		break;

	case STAB:
		cerror( "locctr: STAB unused" );
		break;

	default:
		cerror( "illegal location counter" );
		}

	return( temp );
	}

deflab( n ){
	/* output something to define the current position as label n */
	OUTPRINTF( "L%d:\n", n );
	}

int crslab = 10;

getlab(){
	/* return a number usable for a label */
	return( ++crslab );
	}

efcode(){
	/* code for the end of a function */

	if( strftn ){  
		register struct symtab *p;
		register int stlab;
		int size;

		p = &stab[curftn];

		deflab( retlab );

		stlab = getlab();
		PRINTF( "\ttfr\td,y\n");
		size = tsize( DECREF(p->stype), p->dimoff, p->sizoff ) / SZCHAR;
		PRINTF( "\tldx\t#0\n");
		PRINTF( "1:\tldb\t,y+\n");
		PRINTF( "\tstb\tL%d,x\n", stlab);
		PRINTF( "\tleax\t1,x\n");
		PRINTF( "\tcmpx\t#%d\n", size);
		PRINTF( "\tblo\t1b\n");
		PRINTF( "\tldd\t#L%d\n", stlab);
		PRINTF( "\t.bss\n" );
		PRINTF( "L%d:\trmb\t%d\n", stlab, size );
		PRINTF( "\t.text\n" );
		/* turn off strftn flag, so return sequence will be generated */
		strftn = 0;
		}
	branch( retlab );
#ifdef ONEPASS
	eobl2();
#else
	printf("]\n");
#endif
	}


bfcode( a, n ) int a[]; {
	/* code for the beginning of a function; a is an array of
		indices in stab for the arguments; n is the number */
	register i;
	register temp;
	register struct symtab *p;
	int off;

	locctr( PROG );
	p = &stab[curftn];
	defnam( p );
	temp = p->stype;
	temp = DECREF(temp);
	strftn = (temp==STRTY) || (temp==UNIONTY);

	retlab = getlab();

	/* routine prolog */

	PRINTF("\tpshs\ty,u\n");
	PRINTF("\ttfr\ts,u\n");
	/* adjust stack for autos */
	PRINTF("\tleas\tF%d,s\n", ftnno);

	off = ARGINIT;

	for( i=0; i<n; ++i ){
		p = &stab[a[i]];
		if( p->sclass == REGISTER ){
			temp = p->offset;  /* save register number */
			p->sclass = PARAM;  /* forget that it is a register */
			p->offset = NOOFFSET;
			oalloc( p, &off );
			PRINTF("\tldy\t%d,u\n", (int)p->offset/SZCHAR );
			p->offset = temp;  /* remember register number */
			p->sclass = REGISTER;   /* remember that it is a register */
			}
		else {
			if( oalloc( p, &off ) ) cerror( "bad argument" );
			}

	}

}
bccode(){ /* called just before the first executable statment */
		/* by now, the automatics and register variables are allocated */
	SETOFF( autooff, SZCHAR );
	/* set aside store area offset */
#ifdef ONEPASS
	p2bbeg( autooff, regvar );
#else
		printf("[\t%d\t%d\t%d\t\n", ftnno, autooff, regvar);
#endif
	}

#ifndef DELETE
ejobcode( flag ){
	/* called just before final exit */
	/* flag is 1 if errors, 0 if none */
	}

aobeg(){
	/* called before removing automatics from stab */
	}

aocode(p) struct symtab *p; {
	/* called when automatic p removed from stab */
	}

aoend(){
	/* called after removing all automatics from stab */
	}
#endif

defnam( p ) register struct symtab *p; {
	/* define the current location as the name p->sname */

	if( p->sclass == EXTDEF ){
		PRINTF( "\t.globl	%s\n", exname( p->sname ) );
		}
	if( p->sclass == STATIC && p->slevel>1 ) deflab( p->offset );
	else PRINTF( "%s:\n", exname( p->sname ) );

	}

bycode( t, i ){
	/* put byte i+1 in a string */

	i &= 07;
	if( t < 0 ){ /* end of the string */
		if( i != 0 )fprintf(outfile,  "\n" );
		}

	else { /* stash byte t into string */
		if( i == 0 )  OUTPRINTF( "%s", "\tfcb\t");
		else fprintf(outfile, ",");
		fprintf( outfile, "0%o", t );
		if( i == 07 ) fprintf(outfile,  "\n" );
		}
	}

zecode( n ){
	/* n integer words of zeros */
	OFFSZ temp;

	if( n <= 0 ) return;
	PRINTF("\tzmb\t%d\n", n*SZINT/SZCHAR);
	temp = n;
	inoff += temp*SZINT;
	}

fldal( t ) unsigned t; { /* return the alignment of field of type t */
	uerror( "illegal field type" );
	return( ALCHAR );
	}

#ifndef DELETE
fldty( p ) struct symtab *p; { /* fix up type of field p */
	}
#endif

where(c){ /* print location of error  */
	/* c is either 'u', 'c', or 'w' */
	fprintf( stderr, "%s, line %d: ", ftitle, lineno );
	}

char *tmpname = "/tmp/pcXXXXXX";

main( argc, argv ) char *argv[]; {
	int dexit();
	register int c;
	register int i;
	int r;

	for( i=1; i<argc; ++i )
		if( argv[i][0] == '-' && argv[i][1] == 'X' && argv[i][2] == 'p' ) {
			proflag = 1;
			}

	mktemp(tmpname);
	if(signal( SIGHUP, SIG_IGN) != SIG_IGN) signal(SIGHUP, dexit);
	if(signal( SIGINT, SIG_IGN) != SIG_IGN) signal(SIGINT, dexit);
	if(signal( SIGTERM, SIG_IGN) != SIG_IGN) signal(SIGTERM, dexit);
	tmpfile = fopen( tmpname, "w" );

	r = mainp1( argc, argv );

	tmpfile = freopen( tmpname, "r", tmpfile );
	if( tmpfile != NULL )
		while((c=getc(tmpfile)) != EOF )
			putchar(c);
	else cerror( "Lost temp file" );
	unlink(tmpname);
	return( r );
	}

dexit( v ) {
	unlink(tmpname);
	exit(1);
	}

genswitch(p,n) register struct sw *p;{
	/*	p points to an array of structures, each consisting
		of a constant value and a label.
		The first is >=0 if there is a default label;
		its value is the label number
		The entries p[1] to p[n] are the nontrivial cases
		*/
	register i;
#ifndef DELETE
	register CONSZ  range;
#endif
	register unsigned	max, min;

#ifndef DELETE
	range = p[n].sval-p[1].sval;
#endif
	max = min = p[1].sval;
	for(i = 1; i <= n; i++)
		if(max < p[i].sval)
			max = p[i].sval;
		else
			if(min > p[i].sval)
				min = p[i].sval;

	if((2*(max-min) + 14) <= (5*n))
	{
		register i, j, x;

		/* bubble sort it */
		for(i = 1; i != n; i++)
			for(j = n; j != i; j--)
				if(p[j-1].sval > p[j].sval)
				{
					x = p[j].sval;
					p[j].sval = p[j-1].sval;
					p[j-1].sval = x;
				}

		if(p->slab >= 0)
			x = p->slab;
		else
			x = getlab();
		PRINTF("\tcmpb\t#0%o\n", min&0377);
		PRINTF("\tjlo\tL%d\n", x);
		PRINTF("\tcmpb\t#0%o\n", max&0377);
		PRINTF("\tjhi\tL%d\n", x);
		PRINTF("\tclra\n");
		PRINTF("\taslb\n");
		PRINTF("\trola\n");
		i = getlab();
		PRINTF("\taddd\t#L%d-0%o\n", i, min);
		PRINTF("\tpshs\td\n");
		PRINTF("\tjmp\t[,s++]\n");
		deflab(i);
		for(i = 1; i <= n; i++)
		{
			j = p[i].sval+1;
			PRINTF("\tfdb\tL%d\n", p[i].slab);
			if(i < n)
				while(j != p[i+1].sval)
				{
					PRINTF( "\tfdb\tL%d\n", x);
					j++;
				}
		}
		if(p->slab <= 0)
			deflab(x);
	}
	else
	{
		for(i=1; i<=n; i++)
		{
			PRINTF("\tcmpb\t#0%o\n", (short)(p[i].sval));
			PRINTF("\tjeq\tL%d\n", p[i].slab);
		}
		if( p->slab>=0 ) 
			PRINTF("\tjbr\tL%d\n", p->slab);
	}
}
