h14362
s 00019/00021/00216
d D 1.3 80/04/11 14:07:41 bin 3 2
c Convert to UNIX Edition 7.
e
s 00001/00001/00236
d D 1.2 79/07/20 17:51:46 sys 2 1
c Use anallocated radix-50 symbol for '_'.
e
s 00237/00000/00000
d D 1.1 79/07/20 17:51:07 sys 1 0
e
u
U
t
T
I 1
#
/*
 * UNIX fortran/macro linker cross reference
 */

I 3
#include <stdio.h>

E 3
#define	QUABS	102
#define	GOBBLE	512
#define	SCSYM	8
#define	SCRLIST	8
#define	NIL	0
#define	T	01
#define	A	02
#define	S	04
#define	F	010

struct	crdata	{
D 3
	int	*crname[2];
	int	*crmod[2];
E 3
I 3
	unsigned crname[3];
	unsigned crmod[2];
E 3
	int	crflag;
};

struct	crlist	{
D 3
	int	*mname[2];
E 3
I 3
	unsigned mname[2];
E 3
	int	mdef;
	struct	crlist	*mp;
};

struct	csym	{
D 3
	int	*cname[2];
E 3
I 3
	unsigned cname[2];
E 3
	struct	crlist	*ccp;
	struct	csym	*cnext;
};

char	*memlow;
char	*memhigh;
D 3
int	fout;
E 3
int	infile;
int	flags;

struct csym *chead	NIL;

main(argc,argv)
char **argv;
{
	int	ibuf[QUABS * 5];
	register int i;
	register struct crdata *ccr;
	register char *rcp;

	memhigh = ((memlow = sbrk(GOBBLE)) + GOBBLE);
	if(memlow == -1)
D 3
		ferror("Cref core exceeded.");
E 3
I 3
		lerror("Cref core exceeded.");
E 3
	infile = *argv[2] - '0';
D 3
	fout = *argv[3] - '0';
E 3
I 3
	fileno(stdout) = *argv[3] - '0';
E 3

	rcp = argv[1];
	while(*rcp)
		switch(*rcp++) {

		case ':' :	break;
		case 'f' :	flags =| F;
				break;
		case 't' :	flags =| T;
				flags =& ~S;
				break;
		case 'a' :	flags =| A;
				break;
		case 's' :	flags =| S;
				flags =& ~T;
				break;
D 3
		default:	fout = 2;
E 3
I 3
		default:	fileno(stdout) = 2;
E 3
				printf("Unknown cref option ignored: %c\n",rcp[-1]);
D 3
				fout = *argv[3] - '0';
E 3
I 3
				fileno(stdout) = *argv[3] - '0';
E 3

		}
	while(i = read(infile,ibuf,QUABS * 10)) {
		ccr = ibuf;
		do
			adsym(ccr++);
		while(i =- 10);
	}
	prcref();
	exit(0);
}

prcref()
{
	register struct csym *cp;
	register struct crlist *crp;
	register int i;

	cp = chead;
	printf("\n\n\n\n\n********** Global Cross Reference\n\n\n\n");
	while(cp) {
		crp = cp->ccp;
		if(
D 3
			((flags&F) && (ldiv(0,cp->cname[1],1600) == 033 || ldiv(0,cp->cname[0],1600) == 033)) ||
E 3
I 3
			((flags&F) && ((cp->cname[1]/1600)==033 || (cp->cname[0]/1600)==033)) ||
E 3
			((crp->mp==NIL) && ((flags&T) || ((flags&S) && (crp->mdef))))
		  ) {
			cp = cp->cnext;
			continue;
		}
		radout(cp->cname);
		printf("    ");
		i = 6;
		while(crp)  {
			if(i == 0) {
				i = 6;
				printf("\n\t  ");
			}
			radlout(crp->mname);
			putchar((crp->mdef) ? '#' : ' ');
			printf("   ");
			i--;
			crp = crp->mp;
		}
		cp = cp->cnext;
		putchar('\n');
	}
	printf("\n\n\n");
D 3
	flush();
E 3
}

radcon(rad,asc)
int	*rad;
char	*asc;
{
D 3
	register int w,c1;
E 3
I 3
	register unsigned int w, c1;
E 3
	int cc;
	register char *s;
	char *ss;
D 3
	extern int ldivr;
E 3
	s = asc;
D 2
	ss = " abcdefghijklmnopqrstuvwxyz$.0123456789";
E 2
I 2
	ss = " abcdefghijklmnopqrstuvwxyz$._0123456789";
E 2
	cc = 2;
	do {
		w = *rad++;
D 3
		c1 = lrem(0,w,050);
		w  = ldiv(0,w,050);
		w  = ldiv(0,w,050);
		*s++ = ss[w];
		*s++ = ss[ldivr];
E 3
I 3
		c1 = (w / (050*050)) % 050;
E 3
		*s++ = ss[c1];
I 3
		c1 = (w / 050) % 050;
		*s++ = ss[c1];
		c1 = w % 050;
		*s++ = ss[c1];
E 3
	} while(--cc);
}

radout(p)
int *p;
{
	char rasc[6];
	radcon(p,rasc);
	printf("%.6s",rasc);
}

radlout(p)
int *p;
{
	char rasc[6];
	register char *s;
	register int i,j;
	radcon(p,rasc);
	j = i = 6;
	while(i) 
		if(rasc[--i] == ' ') {
			rasc[i] = 0;
			j = i;
		}
	printf("      " + j);
	printf("%.6s",rasc);
}

char *getcore(n)
{
	register char *w;
	if(memhigh - memlow <= n) {
		if(sbrk(GOBBLE) == -1)
D 3
			ferror("Cref core exceeded");
E 3
I 3
			lerror("Cref core exceeded");
E 3
		memhigh =+ GOBBLE;
	}
	w = memlow;
	memlow =+ n;
	return(w);
}

adsym(cccp)
struct crdata *cccp;
{
	register char *rr1,*rr2,*rr3;
	int *cp1;
	cp1 = &chead;
	rr1 = chead;
	rr2 = cccp;
	for(;;) {
		if(rr1==NIL||rr2->crname[0]<rr1->cname[0]||(rr2->crname[0]==rr1->cname[0]&&rr2->crname[1]<rr1->cname[1])) {
			rr3 = getcore(SCSYM);
			rr3->cname[0] = rr2->crname[0];
			rr3->cname[1] = rr2->crname[1];
			rr3->cnext = *cp1;
			*cp1 = rr3;
			rr3 = rr3->ccp = getcore(SCRLIST);
			rr3->mname[0] = rr2->crmod[0];
			rr3->mname[1] = rr2->crmod[1];
			rr3->mdef = rr2->crflag;
			return;
		}
		if(rr1->cname[0]==rr2->crname[0] && rr1->cname[1]==rr2->crname[1]) {
			cp1 = &(rr1->ccp);
			rr1 = rr1->ccp;
			while(rr1) {
				if((flags&A) && (rr1->mname[0]>rr2->crmod[0] ||
					(rr1->mname[0]==rr2->crmod[0]&&rr1->mname[1]>rr2->crmod[1])))
					break;
				cp1 = &(rr1->mp);
				rr1 = *cp1;
			}
			rr1 = getcore(SCRLIST);
			rr1->mp = *cp1;
			*cp1 = rr1;
			rr1->mname[0] = rr2->crmod[0];
			rr1->mname[1] = rr2->crmod[1];
			rr1->mdef = rr2->crflag;
			return;
		}

		cp1 = &(rr1->cnext);
		rr1 = *cp1;
	}
}


D 3
ferror(s)
E 3
I 3
lerror(s)
E 3
char *s;
{
	printf("%s\n");
D 3
	flush();
E 3
	exit(1);
}
E 1
