h22944
s 00030/00045/00195
d D 1.2 80/04/09 08:07:52 bin 2 1
c Convert to V7.
e
s 00240/00000/00000
d D 1.1 79/09/06 17:13:25 craig 1 0
e
u
U
t
T
I 1
#
/* general nonsense overlay program
 * J. N. Rottman
 */

I 2
#include <stdio.h>
#undef	ferror
E 2

int	ofile;			/*overlay descriptor file */
int	ovfile;			/*overlay output file */
D 2
int	blkpnt	0;		/*current block pointer in overlay file */
int	rempnt	0;		/*current rem pointer in file */
E 2
I 2
long	filpnt	=0;		/* current pointer in overlay file */
E 2
char	root[30];		/*name of root file (without extension) */
char	ovn[25][30];		/*overlay file names */

struct	otable	{
D 2
	int	oblk;
	int	orem;
E 2
I 2
	long	oposn;
E 2
	int	ocnt;
} otable[25];

struct	otable	*opnt otable;

D 2
int	msize	0;		/* max size of overlay region */
E 2
I 2
unsigned int	msize	0;		/* max size of overlay region */
E 2
int	rootsize;		/* size of root */
int	bflag 0;

main(argc,argv)
int argc;
char *argv[];
{
	int	i,nov;
	if(argc==3) {
		bflag++;
		argc--;
	}

	if(argc != 2)
		ferror("Arg count");
	ofile = open(argv[1],0);
	if(ofile == -1)
		ferror("Cannot open descriptor file");

	readln(root);

	nov = 0;

	while(readln(ovn[nov]))
		nov++;

	ovfile=creat("ov.out",0600);

	if(ovfile == -1)
		ferror("Cannot create output file");

	sizeroot();
	for(i = 0; i < nov; i++)
		linkit(i);

	maktab();

	close(ovfile);
	close(ofile);
}
ferror(s)
char *s;
{
	printf("%s\n",s);
	close(ovfile);
	unlink("ov.out");
	exit(1);
}

readln(s)
char *s;
{
	register char *s1;
	register int bc;
	char	cc;
	s1=s;
	while((bc=read(ofile,&cc,1)) && cc != '\n')
		*s1++ = cc;
	*s1 = '\0';
	return(bc);
}

linkit(i)
int i;
{
D 2
	extern int ldivr;
	register int size;
E 2
I 2
	register unsigned int size;
E 2
	int k,magic[8];
D 2
	extern int ldivr;
E 2

	callsys(2,"/bin/link",root,ovn[i]);

	k = open(ext(root,".out"),0);

	if(k == -1)
		ferror("Cannot open object");

	read(k,magic,16);
	if(magic[0] != 0407)
		ferror("Not magic");
	if(magic[1] != 0)
		ferror("Not null text");
	if(magic[3] != 0)
		ferror("Not null bss");

	/* set up descriptor in otable */


	size = magic[2] - rootsize;

D 2
	seek(k,rootsize,1);
E 2
I 2
	lseek(k,(long)rootsize,1);
E 2

D 2
	opnt->oblk = blkpnt;
	opnt->orem = rempnt;
E 2
I 2
	opnt->oposn = filpnt;
E 2
	opnt->ocnt = size;
	
	tran(k,ovfile,size);

	close(k);

	msize = max(size,msize);
D 2
	size = ldiv(0,size,512);
	blkpnt =+ size;
	rempnt =+ ldivr;
	if(rempnt >= 512) {
		rempnt =- 512;
		blkpnt++;
	}
	if(bflag&&rempnt) {
		blkpnt++;
		rempnt=0;
	}
E 2
I 2
	filpnt += size;
	if (bflag)
		filpnt = ((filpnt + 511) / 512)*512;
E 2
	opnt++;
}

tran(in,out,count)
I 2
unsigned int count;
E 2
{
	char	buffer[512];
	int	block,remn;
D 2
	extern	ldivr;
E 2

D 2
	block = ldiv(0,count,512);
	remn  = ldivr;
E 2
I 2
	block = count / 512;
	remn = count % 512;
E 2

	while(block--) {
		read(in,buffer,512);
		write(out,buffer,512);
	}
	if(remn) {
		read(in,buffer,remn);
		write(out,buffer,(bflag ? 512 : remn));
	}
}

ext(s1,s2)
char *s1,*s2;
{
	static	char	s3[50];
	register char	*r1,*r2,*r3;

	r1 = s1;
	r2 = s2;
	r3 = s3;

	while(*r3 = *r1++) r3++;
	while(*r3++ = *r2++);
	return(s3);
}

sizeroot()
{
	int	rfile,magic[8];
	callsys(1,"/bin/link",root);
	rfile = open(ext(root,".out"));
	if(rfile == -1)
		ferror("Cannot open root file");
	read(rfile,magic,16);
	if(magic[0] != 0407)
		ferror("Root not magic");
	if(magic[1] != 0)
		ferror("Non-null root text");
	if(magic[3])
		ferror("Non-null root bss");
	rootsize = magic[2];
	close(rfile);
}
callsys(n,s1,s2,s3)
int n;
char *s1,*s2,*s3;
{
	int	d;
	d = fork();
	if(d==0) {
		if(n=2)
			execl(s1,s1,s2,s3,0);
		else
			execl(s1,s1,s2,0);
		ferror("Bad fork");
	} else
		wait(&d);
}


max(a,b)
I 2
unsigned int a;
unsigned int b;
E 2
{
	return(a>b? a : b);
}

maktab()
{
	register	struct	otable	*op;
D 2
	register	int	k;
	extern		int	fout;
E 2
I 2
	register FILE *f;
E 2

D 2
	k = creat("otable.m11",0600);
	if(k == -1)
E 2
I 2
	f = fopen("otable.m11", "w");
	if (f == NULL)
E 2
		ferror("Cannot create otable");
D 2
	fout = k;
	printf("\n\n\t.title\totable\n\t.psect\totable,ovr\n");
E 2
I 2
	fprintf(f, "\n\n\t.title\totable\n\t.psect\totable,ovr\n");
E 2
	
	for(op = otable; op < opnt; op++) 
D 2
		printf("\t.word\t%o,%o,%o\n",
			op->oblk,
			op->orem,
E 2
I 2
		fprintf(f, "\t.word\t%o,%o,%o\n",
			op->oposn,	/* nasty - 2 arguments */
E 2
			op->ocnt);

D 2
	printf("\n\n\t.psect\tobuff,con\n");
	printf("\t.blkb\t%o\n",msize);
	printf("\n\t.end\n");
E 2
I 2
	fprintf(f, "\n\n\t.psect\tobuff,con\n");
	fprintf(f, "\t.blkb\t%o\n",msize);
	fprintf(f, "\n\t.end\n");
E 2

D 2
	flush();
E 2
I 2
	fclose(f);
E 2

D 2
	fout = 1;

	close(k);
E 2
	callsys(2,"/bin/macro","-xs:10","otable.m11");
	callsys(2,"/bin/link",root,"otable");
}
E 1
