MODULE t8b1;
  CONST m = 8;   (* no. of vehicles on screen *)
  VAR i, x0, y0: integer;
      scrsig, pensig: signal;
      x, y:   ARRAY 1:m OF integer;   (* coordinates *)
      dx, dy: ARRAY 1:m OF integer;   (* increments *)
      del:    ARRAY 1:m OF integer;   (* delay steps *)

DEVICE MODULE display [4];
  USE x, y, dx, dy, del, pensig, scrsig, m;
  CONST n = 8;   (* no. of commands *)
  VAR mode: (frame, figure, command);
      i: integer;
      z: integer; (* index of currently identified vehicle *)
      dpc [172000B]: integer; (* display program counter *)
      frm: ARRAY 0:17 OF integer;   (* frame display code *)
      fig: ARRAY 0:13 OF integer;   (* vehicle display code *)
      com: ARRAY 1:n, 0:15 OF integer;   (* command codes *)

  PROCESS screen [320B];
  BEGIN
    LOOP wait(scrsig);
      mode := frame;
      dpc := adr(frm); doio;
      mode := figure; i := m;
      REPEAT fig[1] := x[i]; fig[2] := y[i];
        fig[11] := 64 + i;
        IF i=z THEN fig[10] := 103630B   (* blink on *)
               ELSE fig[10] := 103620B   (* blink off *)
        END;
        dpc := adr(fig); doio; dec(i)
      UNTIL i = 0;
      mode := command; i := n;
      REPEAT dpc := adr(com[i]); doio; dec(i)
      UNTIL i = 0
    END
  END screen;

  PROCESS pen [324B];
    VAR d: integer;
  BEGIN
    LOOP frm[0] := 117164B; doio;   (* wait until pen signals *)
         frm[0] := 117124B;
      IF mode = figure THEN z := i
      ELSIF mode = command THEN
        CASE i OF
          1: BEGIN inc(dx[z]) END;
          2: BEGIN inc(dy[z]) END;
          3: BEGIN dec(dx[z]) END;
          4: BEGIN dec(dy[z]) END;
          5: BEGIN inc(del[z]) END;
          6: BEGIN dec(del[z]) END;
          7: BEGIN dx[z] := 0; dy[z] := 0; del[z] := 0;
               IF z = 1 THEN halt(0) END
             END;
          8: BEGIN dx[z] := -dx[z]; dy[z] := -dy[z] END
        END
      END;
      dpc := adr(frm);   (* restart display *)
      d := 25;
      REPEAT wait(pensig); dec(d) UNTIL d = 0
    END
  END pen;

BEGIN (* display module *)
  frm[00] := 117124B; frm[01] := 000000B; frm[02] := 000000B;
  frm[03] := 110000B; frm[04] := 041777B; frm[05] := 000000B;
  frm[06] := 040000B; frm[07] := 001377B; frm[08] := 061777B;
  frm[09] := 000000B; frm[10] := 040000B; frm[11] := 021377B;
  frm[12] := 000000B; frm[13] := 000200B; frm[14] := 041777B;
  frm[15] := 000000B; frm[16] := 173400B;
  fig[00] := 117024B; fig[01] := 000000B; fig[02] := 000000B;
  fig[03] := 104000B; fig[04] := 050000B; fig[05] := 040040B;
  fig[06] := 070000B; fig[07] := 040140B; fig[08] := 130000B;
  fig[09] := 002206B; fig[10] := 103620B; fig[11] := 000000B;
  fig[12] := 173400B;
  com[1,0] := 117024B; com[1,1] := 001000B; com[1,2] := 000100B;
  com[1,3] := 104000B; com[1,4] := 056000B; com[1,5] := 062010B;
  com[1,6] := 040120B; com[1,7] := 042010B; com[1,8] := 173400B;
  com[2,0] := 117024B; com[2,1] := 001000B; com[2,2] := 000100B;
  com[2,3] := 104000B; com[2,4] := 040070B; com[2,5] := 062110B;
  com[2,6] := 044000B; com[2,7] := 062010B; com[2,8] := 173400B;
  com[3,0] := 117024B; com[3,1] := 001000B; com[3,2] := 000100B;
  com[3,3] := 104000B; com[3,4] := 076000B; com[3,5] := 042010B;
  com[3,6] := 040120B; com[3,7] := 062010B; com[3,8] := 173400B;
  com[4,0] := 117024B; com[4,1] := 001000B; com[4,2] := 000100B;
  com[4,3] := 104000B; com[4,4] := 040170B; com[4,5] := 062010B;
  com[4,6] := 044000B; com[4,7] := 062110B; com[4,8] := 173400B;
  com[5,0] := 117620B; com[5,1] := 000300B; com[5,2] := 000070B;
  com[5,3] := 100000B; com[5,4] := 046123B; com[5,5] := 053517B;
  com[5,6] := 173400B; com[5,7] := 000000B; com[5,8] := 000000B;
  com[6,0] := 117620B; com[6,1] := 000500B; com[6,2] := 000070B;
  com[6,3] := 100000B; com[6,4] := 040506B; com[6,5] := 052123B;
  com[6,6] := 173400B; com[6,7] := 000000B; com[6,8] := 000000B;
  com[7,0] := 117620B; com[7,1] := 001200B; com[7,2] := 000070B;
  com[7,3] := 100000B; com[7,4] := 040510B; com[7,5] := 052114B;
  com[7,6] := 173400B; com[7,7] := 000000B; com[7,8] := 000000B;
  com[8,0] := 117620B; com[8,1] := 001500B; com[8,2] := 000070B;
  com[8,3] := 100000B; com[8,4] := 040502B; com[8,5] := 045503B;
  com[8,6] := 173400B; com[8,7] := 000000B; com[8,8] := 000000B;
  mode := frame; z := 1; screen; pen
END display;

DEVICE MODULE timing [6];
  DEFINE tick;
  VAR tick: signal;
      lcs [177546B]: bits;

  PROCESS clock [100B];
  BEGIN lcs[6] := true;
    LOOP doio;
      WHILE awaited(tick) DO send(tick) END
    END
  END clock;

BEGIN clock
END timing;

PROCESS vehicle(i: integer);
  VAR d: integer;
BEGIN
  LOOP d := del[i];
    REPEAT wait(tick); dec(d)
    UNTIL d < 0;
    inc(x[i], dx[i]);
    IF (x[i] < 0) OR (x[i] > 1740B) THEN
       dx[i] := -dx[i]; inc(x[i], dx[i])
    END;
    inc(y[i], dy[i]);
    IF (y[i] < 200B) OR (y[i] > 1340B) THEN
       dy[i] := -dy[i]; inc(y[i], dy[i])
    END
  END
END vehicle;

PROCESS clock;
BEGIN
  LOOP wait(tick); send(scrsig); send(pensig)
  END
END clock;

BEGIN (* spacerace *)
  i := m;
  x0 := 2000B/(m+1); y0 := 220B;
  REPEAT x[i] := i*x0; y[i] := y0;
    dx[i] := 0; dy[i] := 0; del[i] := 0;
    vehicle(i); dec(i)
  UNTIL i = 0;
  clock
END t8b1.
{
.bp
}
