#


#include	"mash.c"


#define IMMED	000
#define DIRECT	020
#define INDEX	040
#define EXTEND	060



extern char symbuf[];
extern curfb[];
extern spc;
extern struct symbol *symtab;
extern struct fb *fbtable;
extern char *linep;
extern char tch;
extern ofstbts, postbyte, regi;
extern char line[];


extern char inbuf[], *nextch;
extern findes;
extern lfile;
extern undef;
extern nchar, operand;

int accum;
char  peekc;		/*  used  in  getch  and  fcchar  */


getch()
{
register char c;

	if ( peekc ) {
		c = peekc;
		peekc = 0;
		return(c);
	}
	if ( nextch >= inbuf+nchar )
		return(0);
	c = *nextch++;
	if ( (nextch >= inbuf+nchar) && (nchar == 512) )
		nchar = read(findes, nextch=inbuf, 512);
	if( lfile && (linep < &line[l_EOL]))
		*linep++ = c;
	return(c);
}




getsym(ch)
char ch;
{
register char c, *s;
register n;

	if ( (c = ch) == '\0' )
		c = getch();
	s = symbuf;
	n = 0;
	for (;;) {
		if ( (c >='a') || digit(c) || (c == '_') || (c == '.') || (c == '^')
					|| ((c >= 'A') && (c <= 'Z'))) {
			if( n++ < 8 )
				*s++ = c;
			c = getch();
		}
		else {
			tch = c;
			*s = '\0';
			return(n);
		}
	}
}




getnonbl()
{
register char c;
	while ( ((c = getch()) == SP) || (c == TAB) );
	return(c);
}



getacc()
{
register char c;
register char *l;
	c = getnonbl();
	tch = getch();
	c =| 040;
	return(c - 0140);
}



getitem(ch)
char ch;
{
register char c;
register n, rator;
char c1;
int total;

	accum = undef = total = rator = n = 0;
	if ( (c = ch) == MINUS ) {
		rator = c;
		c = getch();
	}

	for (;;) {

	if ( getsym(c) == 0 ) {
		c = tch;
		if ( c == STAR ) {
			tch = getch();
			n = spc;
		}
		else
		if ( c == QUOTE ) {
			if ( getsym(0) == 0 ) {
				n = tch;
				getsym(0);
				if ( n == BACKSL )
					n = spech(symbuf[0]);
			}
			else
				n = symbuf[0];
		}
		else
		if ((c == PERCEN) || (c == DOLLAR) || (c == AT)) {
			n = getnum(c);
		}
		else
			return(0);
	}

	else {
		c = symbuf[0];
		if ( tch == QUOTE ) {
			n = getnum(c);
			if ( tch == QUOTE ) {
				tch = getch();
			}
		}
		else
		if ( digit(c) ) {
			c1 = symbuf[1] | 040;
			if ( (c1 == 'f') || (c1 == 'b') ) {
				if ( c1 == 'f' )
					c =+ 10;
				n = curfb[c-'0'];
				if ( fbtable[n].fb_def == UND ) {
					if ( fbtable[n].fb_pc ) {
						fbund();
						fbtable[n].fb_pc = 0;
					}
					n = 0;
					undef++;
				}
				n = fbtable[n].fb_pc;
			}
			else
				n = getdec();
		}
		else
		if ( accsym() ) {
			accum = 1;
			return(-1);
		}
		else {
			n = lookup();	/* symbol table index */
			if ( symtab[n].s_def == UND ) {
				if ( symtab[n].s_pc ) {
					symtab[n].s_pc = 0;
					underr();
				}
				n = 0;
				undef++;
			}
			else
				n = symtab[n].s_pc;
		}
	}

	switch ( rator ) {
	case 0:
		total = n;
		break;

	case PLUS:
		total =+ n;
		break;

	case MINUS:
		total =- n;
		break;

	case SLASH:
		total =/ n;
		break;

	case STAR:
		total =* n;
		break;
	case AMPER:
		total =& n;

	case LTHAN:
		total =<< n;
		break;

	case GTHAN:
		total =>> n;
		break;

	}

	switch ( c = tch ) {
	case PLUS:
	case MINUS:
	case STAR:
	case SLASH:
	case AMPER:
	case LTHAN:
	case GTHAN:
		rator = c;
		c = 0;
		continue;

	default:
		if ( undef )
			return(0);
		return(total);
	}

	}
}




getnum(ch)
char ch;
{
register char *s;
register char c;
register number;
int fac;

	number = fac = 0;
	s = symbuf;
	switch ( ch ) {
	case DOLLAR:
	case 'x':
	case 'X':
		s =+ getsym(0);
		while ( --s >= symbuf ) {
			if ( digit(c = *s) )
				number =+ (c-'0') << fac;
			else {
				c =| 040;
				number =+ (c-'W') << fac;
			}
			fac =+ 4;
		}
		break;

	case PERCEN:
	case 'b':
	case 'B':
		s =+ getbin();
		while ( --s >= symbuf ) {
			number =+ (*s-'0') << fac;
			fac++;
		}
		break;

	case 'AT':
	case 'o':
	case 'O':
		s =+ getsym(0);
		while ( --s >= symbuf ) {
			number =+ (*s-'0') << fac;
			fac =+ 3;
		}
	}

	return(number);
}




getbin()
{
register char *s, c;
register n;

	s = symbuf;
	n = 0;
	c = getch();
	for (;;) {
		if ( (c == '1') || (c == '0') ) {
			n++;
			*s++ = c;
			c = getch();
		}
		else {
			tch = c;
			*s = '\0';
			return(n);
		}
	}
}



getdec()
{
register char *s;
register n, fac;

	s = symbuf;
	while ( *s++ );
	--s;
	n = 0;
	fac = 1;
	while ( --s >= symbuf ) {
		n =+ (*s-'0') * fac;
		fac =* 10;
	}
	return(n);
}



char bits[]{
	0x06,	0x10,	0x20,	0x40,	0x40,	0x80,	0x00,	0x00,
	0x02,	0x04,	0x01,	0x08};



getPP()
{
register n;
char c;
	if (((c = getnonbl()) == HATCH) || (c == EQUAL)) {
		postbyte = getitem(getch());
		return(0);
	}
	else {
		n = gettreg(c);
		postbyte = bits[n];
		while (tch == COMMA) {
			n = gettreg(0);
			postbyte =| bits[n];
		}
		return(0);
	}
}

gettreg(c)
{
int n;
	if ( (n = getsym(c)) == 1){
		switch (symbuf[0]){
		case 'd':	return(0);
		case 'x':	return(1);
		case 'y':	return(2);
		case 'u':	return(3);
		case 's':	return(4);
		case 'a':	return(8);
		case 'b':	return(9);
		default:	return(-1);
		}
	}
	else
	if (n == 2) {
		if ((symbuf[0] == 'p') && (symbuf[1] == 'c'))
			return(5);
		else
		if ((symbuf[0] == 'c') && (symbuf[1] == 'c'))
			return(10);
		else
		if ((symbuf[0] == 'd') && (symbuf[1] == 'p'))
			return(11);
		else	
			return(-1);
	}
	else
		return(-1);
}


getregop()
{
char c;
	c = getnonbl();
	postbyte = gettreg(c);
	postbyte =<< 4;
	postbyte =| gettreg(0);
}

getoper()
{
char c;
long n;

	ofstbts = 0;

	switch ( c = getnonbl()){

	case HATCH:
	case EQUAL:
		operand = getitem(getch());
		return(m_IM1);
	case LTHAN:
		operand = getitem(getch());
		return(m_DIR);
	case COMMA:
		if ( (c=getch()) == MINUS ) {
			if ((c=getch()) == MINUS) {
				getreg(0);
				postbyte = 0x83 | (regi << 5);
				return(m_IND);
			}
			else {
				getreg(c);
				postbyte = 0x82 | (regi << 5);
				return(m_IND);
			}
		}
		else {
			getreg(c);
			if (tch <= SP)  {
				postbyte = 0x84 | (regi << 5);
				return(m_IND);
			}
			else  {
				getsym(0);
				if (tch == PLUS)
					postbyte = 0x81;
				else
					postbyte = 0x80;
				postbyte =| (regi << 5);
				return(m_IND);
			}
		}
	case LPAR:
		if((c=getch()) == COMMA) {
			if ((c=getch()) == MINUS) {
				c = getch();
				getreg(0);
				postbyte = 0x93 | (regi << 5);
				return(m_IND);
			}
			else {
				getreg(c);
				if (tch == RPAR) {
					postbyte = 0x94 | (regi << 5);
					return(m_IND);
				}
				else {
					getch();
					getch();
					postbyte = 0x91 | (regi << 5);
					return(m_IND);
				}
			}
		}
		else {
			n = operand = getitem(c);
			if (!accum) {
				if (tch == COMMA) {
					if(getreg(0) == m_PCR)
					{
						if(iins(i_O8))
						{
							postbyte = 0x9c;
							ofstbts = 1;
							return(m_PCR);
						}
						if(iins(i_O16))
						{
							postbyte = 0x9d;
							ofstbts = 2;
							return(m_PCR);
						}
						write(2, "[n,pcr]\n", 8);
						syserr();
					}
					if(iins(i_O16))
					{
						postbyte = 0x99;
						ofstbts = 2;
					}
					else if(iins(i_O8))
					{
						postbyte = 0x98;
						ofstbts = 1;
					}
					else if(iins(i_O0))
					{
						if(n == 0)
						{
							postbyte = 0x94;
							ofstbts = 0;
						}
						else
						{
							write(2, "indx [0,R]\n",11);
							syserr();
						}
					}
					else
					{
						write(2, "indx [n,R]\n", 11);
						syserr();
					}
					postbyte =| (regi << 5);
					return(m_IND);
				}
				else {
					if (tch == RPAR) {
						postbyte = 0x9f;
						ofstbts = 2;
						return(m_IND);
					}
				}
			}
			else { /*accu*/
				switch (symbuf[0]) {
				case 'a':
					postbyte = 0x96;
					goto abd;
				case 'b':
					postbyte = 0x95;
					goto abd;
				case 'd':
					postbyte = 0x9b;
				abd:
					getreg(0);
					postbyte =| (regi << 5);
					return(m_IND);
				}
			}
		}
	default:
		n = operand = getitem(c);
		if (!accum) {
			if (tch == COMMA) {
					if(getreg(0) == m_PCR)
					{
						if(iins(i_O8))
						{
							postbyte = 0x8c;
							ofstbts = 1;
							return(m_PCR);
						}
						if(iins(i_O16))
						{
							postbyte = 0x8d;
							ofstbts = 2;
							return(m_PCR);
						}
						write(2, "n,pcr\n", 6);
						syserr();
					}
					if(iins(i_O16))
					{
						postbyte = 0x89;
						ofstbts = 2;
					}
					else if(iins(i_O8))
					{
						postbyte = 0x88;
						ofstbts = 1;
					}
					else if(iins(i_O5))
					{
						if(n == 0)
						{
							postbyte = 0x84;
							ofstbts = 0;
						}
						else
						{
							postbyte = n & 037;
							ofstbts = 0;
						}
					}
					else
					{
						write(2, "indx n,R\n", 9);
						syserr();
					}
				postbyte =| (regi << 5);
				return(m_IND);
			}
			else  {
			return(m_EXT);
			}
		}
		else {
			switch (symbuf[0]){


			case 'a':
				postbyte = 0x86;
				goto abc;
			case 'b':
				postbyte = 0x85;
				goto abc;
			case 'd':
				postbyte = 0x8b;
			abc:
				getreg(0);
				postbyte =| (regi << 5);
				return(m_IND);
			}
		}
	}
}




getreg(c)
register char c;
{
	getsym(c);
	switch (symbuf[0]){
		case 'x':
			regi = 0;
			break;
		case 'y':
			regi = 1;
			break;
		case 'u':
			regi = 2;
			break;
		case 's':
			regi = 3;
			break;
		case 'p':
			regi = 4;
			if(symbuf[1] == 'c') /* should be enough */
			{
				regi = -1;
				return(m_PCR);
			}
			break;
		default:
			regi = -1;
	}
	return(0);
}



getexpr()
{
	return( getitem( getnonbl() ) );
}




spech(ch)
char ch;
{
	switch ( ch ) {
	case BACKSL:
		return(BACKSL);

	case 'b':
		return(BS);
	case 'n':
		return(NL);
	case 'r':
		return(CR);

	case 's':
		return(SP);

	case 't':
		return(TAB);

	case '0':
		return('\0');
	}

	return(BACKSL);
}



accsym()
{
register char c;

	if ( symbuf[1] == '\0' ) {
		if ( (c == 'a') || (c == 'b') || (c == 'd') )
			return(1);
	}
	return(0);
}



digit(ch)
char ch;
{
register char c;
	if ( ((c = ch) >= '0') && (c <= '9') )
		return(1);
	return(0);
}
