#include "../em1.h"
{
  (c) copyright 1978 by the Vrije Universiteit, Amsterdam, The Netherlands.
  Explicit permission is hereby granted to universities to use or duplicate
  this program for educational or research purposes.  All other use or dup-
  lication  by universities,  and all use or duplication by other organiza-
  tions is expressly prohibited unless written permission has been obtained
  from the Vrije Universiteit. Requests for such permissions may be sent to
       Dr. Andrew S. Tanenbaum
       Wiskundig Seminarium
       Vrije Universiteit
       Postbox 7161
       1007 MC Amsterdam
       The Netherlands
}
{if next line is included the compiler itself is written in standard pascal}
{#define	STANDARD	1}
{temporary kludge for the EM1 cse/csa/csb instruction}
#define	OLDCASE		1

{Author:	Johan Stevenson			Version:	26}
{$l- : no source line numbers}
{$r- : no subrange checking}
{$a- : no assertion checking}
program pem(input,output,em1);
{This Pascal compiler  produces EM1 code as described in
   - A.S.Tanenbaum, J.W.Stevenson & H. van Staveren,
	"Description of a experimental machine architecture for use of
	 block structured languages" Informatika rapport xx.
  A description of Pascal is given in
   - K.Jensen & N.Wirth, "PASCAL user manual and report", Springer-Verlag.
  Several options may be given in the normal pascal way. Moreover,
  a positive number may be used instead of + and -. The options are:
	a:	interpret assertions (+);
	c:	C-type strings allowed (-);
	i:	controls the number of bits in integer sets (16);
	l:	insert code to keep track of source lines (+);
	o:	optimize (+);
	r:	check subranges (+);
	s:	accept only standard pascal programs (-);
	t:	trace procedure entry and exit (-);
	v:	produce code for 24 bit addresses (-);
}
{===================================================================}
#ifdef STANDARD
label 9999
#endif
const
{sizes of standard types}
  {The sizes are set to fit the EM1 machine architecture. Sizes and
    addresses are expressed in bytes (1 byte = 8 bits). All objects
    must have an even size, with the exception of small scalars
    fitting in one byte.
    EM1 requires each object of more than one byte to start on an even
    address. Default the same is true for objects of one byte. However
    the 'packed' qualifier turns this alignment off, both for arrays
    and for records. Strings are packed arrays.
    The size of pointers depends on vopt, indicating
    segmented memory with 24 bits addresses.
    Two words (1 word = 2 bytes) are used for reals.
    The routines involved with alignment are even, address and arraysize.
  }
  charsize=1;
  boolsize=1;
  intsize =2;
  realsize=4;
  maxsetsz=32;		{maximum number of bytes for a set}
  {see handleopts for ptrsize}
{other sizes}
  pdsize=2;		{size of procedure descriptors}
  buffersize=512;	{size of file buffer}
{maximal indices}
  idmax=8;		smax=72;		rmax=72;
{value of nil (2 words) }
  nil1=0;		nil2=0;
{value of real zero (2 words) }
  real1=0;		real2=0;
{opt values}
  off=0;		on=1;
{for push and pop: }
  global=false;		local=true;
{integer bounds}
  minint=-32767;	maxint=32767;
{set bounds}
  minsetint=0;		maxsetint=15;		{default}
  maxsetwd=16;		{maxsetsz div 2}
  maxwbit=15;		{maximal word bit number}
  bytebits=8;		{number of bits in a byte}
{constants describing the compact EM1 code}
  {magic word}
  MAGICLOW	= 172;		MAGICHIGH	= 0;
{miscellaneous}
  maxsg=127;		{maximal segment number}
  maxcharord=127;	{maximal ordinal number of chars}
  maxargc=13;		{maximal index in argv}
  rwlim=34;		{number of reserved words}
#ifdef OLDCASE
  cixmax=256;
#endif
  spaces='        ';

{-------------------------------------------------------------------}
type
{scalar types}
  symbol=	(comma,semicolon,colon1,colon2,notsy,lbrack,ident,intcst,
		 charcst,realcst,stringcst,nilcst,minsy,plussy,lparent,
		 arrow,arraysy,recordsy,setsy,filesy,packedsy,progsy,
		 labelsy,constsy,typesy,varsy,procsy,funcsy,beginsy,
		 gotosy,ifsy,whilesy,repeatsy,forsy,withsy,casesy,
		 becomes,starsy,divsy,modsy,slashsy,andsy,orsy,
		 eqsy,nesy,gtsy,gesy,ltsy,lesy,insy,
		 endsy,elsesy,untilsy,ofsy,dosy,downtosy,tosy,
		 thensy,rbrack,rparent,period
		);			{the order is important}
  chartype=	(undscore,lower,upper,digit,layout,tabch,quotech,dquotech,
		   colonch,periodch,lessch,greaterch,lparentch,lbracech,
						{different entries}
		 rparentch,lbrackch,rbrackch,commach,semich,arrowch,
		   plusch,minch,slash,star,equal,
						{also symbols}
		 others
		);
  standpf=	(pread,preadln,pwrite,pwriteln,pput,pget,
		 preset,prewrite,pnew,pdispose,ppack,punpack,
		 pmark,prelease,ppage,phalt,
						{all procedures}
		 feof,feoln,fabs,fsqr,ford,fchr,fpred,fsucc,fodd,
		 ftrunc,fround,fsin,fcos,fexp,fsqrt,fln,farctan
						{all functions}
		);			{the order is important}
  libmnem=	(OPN ,GETX,RDI ,RDC ,RDR ,RLN ,ELN ,EFL ,CLS ,
						{on inputfiles}
		 CRE ,PUTX,WRI ,WSI ,WRC ,WSC ,WRS ,WSS ,WRB ,
		 WSB ,WRR ,WSR ,WRF ,WRZ ,WSZ ,WLN ,PAG ,
				{on outputfiles, order important}
		 ABR ,RND ,SIN ,COS ,EXPX,SQT ,LOG ,ATN ,
						{floating point}
		 ABI ,BCP ,BTS ,NEWX,SAV ,RST ,INI ,HLT ,
		 ASS ,GTO ,PAC ,UNP, DIS
						{miscellaneous}
		);
  structform=	(scalar,subrange,pointer,power,files,arrays,
		 records,variant,tag);		{order important}
  structflag=	(spack,withfile);
  varflag=	(refer,used,assigned);
  idclass=	(types,konst,vars,field,proc,func);
  kindofpf=	(standard,formal,actual,extrn,forwrd);
  where=	(blck,rec,crec,vrec);
  attrkind=	(cst,direct,indirect,indexed,expr);
  twostruct=	(eq,subeq,ir,ri,es,se,noteq);  {order important}

{subrange types}
  sgrange=	0..maxsg;
  idrange=	1..idmax;
  rwrange=	0..rwlim;
  byte=		0..255;

{pointer types}
  sp=	^structure;
  ip=	^identifier;
  lp=	^labl;
  bp=	^blockinfo;
  np=	^nameinfo;

{set types}
  sos=		set of symbol;
  setofids=	set of idclass;
  formset=	set of structform;
  sflagset=	set of structflag;
  vflagset=	set of varflag;

{array types}
  alpha =packed array[idrange] of char;

{record types}
  position=record		{the addr info of certain variable}
    ad:integer;			{for locals it is the byte offset}
    lv:integer;			{the level of the beast}
    sg:sgrange			{only relevant for globals (lv=0) }
  end;

{records of type attr are used to remember qualities of
  expression parts to delay the loading of them.
  Reasons to delay the loading of one word constants:
	- bound checking
	- set building.
  Reasons to delay the loading of direct accessible objects:
	- efficient handling of read/write
	- efficient handling of the with statement.
}
  attr=record
    asp:sp;				{type of expression}
    case ac:attrkind of			{access method}
      expr:	();
      cst:	(intval:integer);	{one word value of constant}
      direct:	(pos:position);		{sg,lv and ad}
      indirect:	(pk:boolean);		{packed or not}
      indexed:	(arpk:boolean;		{packed or not}
		 arno:integer)		{descriptor number}
  end;

  nameinfo=record		{one for each separate name space}
    nlink:np;			{one deeper}
    fname:ip;			{first name; root of tree}
    case occur:where of
      blck:();
      rec: ();
      crec:(cpos:position);	{for records with known address}
      vrec:(vdspl:integer;	{offset of local pointer to record}
	    rcpk:boolean	{packed or not}
	   )
  end;

  blockinfo=record	{all info of the current procedure}
    nextbp:bp;		{pointer to blockinfo of surrounding proc}
    lc:integer;		{data location counter (from begin of proc) }
    ilbno:integer;	{number of last local label}
    forwcount:integer;	{number of not yet specified forward procs}
    lchain:lp;		{first label; header of chain}
  end;

  structure=record
    size:integer;			{size of structure in bytes}
    sflag:sflagset;			{flag bits}
    case form:structform of
      scalar  :(scalno:integer;		{number of range descriptor}
		fconst:ip		{names of constants}
	       );
      subrange:(min,max:integer;	{lower and upper bound}
		rangetype:sp;		{type of bounds}
		subrno:integer		{number of subr descriptor}
	       );
      pointer :(eltype:sp);		{type of pointed object}
      power   :(elset:sp);		{type of set elements}
      files   :(filtype:sp);		{type of file elements}
      arrays  :(aeltype:sp;		{type of array elements}
		inxtype:sp;		{type of array index}
		arrno:integer		{number of array descriptor}
	       );
      records :(fstfld:ip;		{points to first field}
		tagsp:sp		{points to tag if present}
	       );
      variant :(varval:integer;		{tag value for this variant}
		nxtvar:sp;		{next equilevel variant}
		subtsp:sp		{points to tag for sub-case}
	       );
      tag     :(fstvar:sp;		{first variant of case}
		tfldsp:sp		{type of tag}
	       )
  end;

  identifier=record
    idtype:sp;				{type of identifier}
    name:alpha;				{name of identifier}
    llink,rlink:ip;			{see enterid,searchid}
    next:ip;				{used to make several chains}
    case klass:idclass of
      types    :();
      konst   :(value:integer);		{for integers the value is
		  computed and stored in this field;
		  For strings and reals an assembler constant is
		  defined labeled '.1', '.2', ...  This '.' number is then
		  stored in value. For reals value may be negated to
		  indicate that the opposite of the assembler constant
		  is needed. }
      vars    :(vflag:vflagset;		{flag bits}
		vpos:position		{position of var}
	       );
      field   :(foffset:integer);	{offset to begin of record}
      proc,func:
	(case pfkind:kindofpf of
	   standard:(key:standpf);	{identification}
	   formal,actual,forwrd,extrn:
	     (pflag:vflagset;		{flag bits}
	      pfpos:position;		{lv gives declaration level;
			sg gives instruction segment of this proc and
			ad is relevant for formal pf's and for
			functions (no conflict!!);
			for functions: ad is the result address;
			for formal pf's: ad is the address of the
			descriptor }
	      pfno:integer;		{unique pf number}
	      parhead:ip;		{head of parameter list}
	      headlc:integer		{lc when heading scanned}
	     )
	)
  end;

  labl=record
    nextlp:lp;		{chain of labels}
    seen:boolean;
    labval:integer;	{label number given by the programmer}
    labname:integer;	{label number given by the compiler}
    labdlb:integer	{zero means only locally used;
			  otherwise dlbno of label information}
  end;

{-------------------------------------------------------------------}
var  {the most frequent used externals are declared first}
  sy:symbol;		{last symbol}
  a:attr;		{type,access method,position,value of expr}
{returned by insym}
  ch:char;		{last character}
  chsy:chartype;	{type of ch; used by insym}
  val:integer;		{if last symbol is an constant }
  ix:integer;		{string length}
  zerostring:boolean;	{true for strings in " "}
  id:alpha;		{if last symbol is an identifier}
{blockinfo}
  b:blockinfo;		{all info to be stacked at pfdeclaration}
{some counters}
  linecount:integer;	{line number on input file; (1..n) }
  chcnt:integer;	{char count on current input line; (1..n) }
  lino:integer;		{line number on code file; (1..n) }
  dlbno:integer;	{number of last global number}
  lcmax:integer;	{keeps track of maximum of lc}
  level:integer;	{current static level}
  ptrsize:integer;
  fhsize:integer;	{size of file info}
  argc:integer;		{index in argv}
  lastpfno:integer;	{unique pf number counter}
  copt:integer;		{C-type strings allowed if on}
  iopt:integer;		{number of bits in sets with base integer}
  sopt:integer; 	{standard option}
  vopt:integer;		{two word addresses if on}
{pointers pointing to standard types}
  realptr,intptr,textptr,emptyset,boolptr,charptr,nilptr,stringptr:sp;
{opts}
  giveline:boolean;	{give source line number at next statement}
  eofexpected:boolean;	{quit without error if true (nextch) }
  main:boolean;		{complete programme or a module}
  intypedec:boolean;	{true if nested in typedeclaration}
  fltused:boolean;	{true if floating point instructions are used}
  seconddot:boolean;	{indicates the second dot of '..'}
{pointers}
  fwptr:ip;		{head of chain of forward reference pointers}
  progp:ip;		{program identifier}
  top:np;		{pointer to the most recent name space}
  lastnp:np;		{pointer to nameinfo of last searched ident }
{records}
  fa:attr;		{attr for current file name}
{arrays}
  strbuf:array[1..smax] of char;
  iop:array[boolean] of ip;
			{false:standard input; true:standard output}
  rw:array[rwrange] of alpha;
			{reserved words}
  frw:array[0..idmax] of integer;
			{indices in rw}
  rsy:array[rwrange] of symbol;
			{symbol for reserved words}
  cs:array[char] of chartype;
			{chartype of a character}
  csy:array[rparentch..equal] of symbol;
			{symbol for single character symbols}
  lmn:array[libmnem] of packed array[1..4] of char;
			{mnemonics of pascal library routines}
  opt:array['a'..'z'] of integer;
  forceopt:array['a'..'z'] of boolean;
			{26 different opts}
  undefip:array[idclass] of ip;
			{used in searchid}
  argv:array[0..maxargc] of
	 record name:alpha; ad:integer end;
			{save here the external heading names}
{files}
  em1:file of byte;	{the EM1 code is put there}
{===================================================================}

procedure gen2bytes(b:byte; i:integer);
var b1,b2:byte;
begin
  if i<0 then
    if i<minint then begin b1:=0; b2:=128 end
    else begin i:=-i-1; b1:=255 - i mod 256; b2:=255 - i div 256 end
  else begin b1:=i mod 256; b2:=i div 256 end;
  write(em1,b,b1,b2)
end;

procedure gencst(i:integer);
begin
  if (i>=0) and (i<sp_ncst0) then write(em1,i+sp_fcst0)
  else gen2bytes(sp_cst2,i)
end;

procedure genclb(i:integer);
begin if i<256 then write(em1,sp_ilb1,i) else gen2bytes(sp_ilb2,i) end;

procedure genilb(i:integer);
begin lino:=lino+1;
  if i<sp_nilb0 then write(em1,i+sp_filb0) else genclb(i);
end;

procedure gendlb(i:integer);
begin if i<256 then write(em1,sp_dlb1,i) else gen2bytes(sp_dlb2,i) end;

procedure gen0(b:byte);
begin write(em1,b); lino:=lino+1 end;

procedure gen1(b:byte; i:integer);
begin gen0(b); gencst(i) end;

procedure gend(b:byte; d:integer);
begin gen0(b); gendlb(d) end;

procedure genident(nametype:byte; var a:alpha);
var i,j:integer;
begin i:=idmax;
  while (a[i]=' ') and (i>1) do i:=i-1;
  write(em1,nametype,i);
  for j:=1 to i do write(em1,ord(a[j]))
end;

procedure gensp(m:libmnem);
var i:integer;
begin gen0(op_cal); write(em1,sp_pnam,4);
  for i:=1 to 4 do write(em1,ord(lmn[m][i]))
end;

procedure genpnam(b:byte; fip:ip);
var n:alpha; i,j:integer;
begin
  if fip^.pfpos.lv<=1 then n:=fip^.name else
    begin n:='_       '; j:=1; i:=fip^.pfno;
      while i<>0 do
	begin j:=j+1; n[j]:=chr(i mod 10 + ord('0')); i:=i div 10 end;
    end;
  gen0(b); genident(sp_pnam,n)
end;

procedure genend;
begin write(em1,sp_cend) end;

procedure genlin;
begin giveline:=false;
  if opt['l']<>off then if main then gen1(op_lin,linecount)
end;

{===================================================================}

procedure error(e:integer);
{as you will notice, all error numbers are preceded by '+' and '0' to
  ease their renumbering in case of new errornumbers.
}
begin writeln(e,linecount,chcnt-1); if e>0 then gen1(ps_mes,0) end;

procedure teststandard;
begin if sopt<>off then error(-(+01)) end;

procedure errid(e:integer; var id:alpha);
begin write(id); error(e) end;

procedure errint(e:integer; i:integer);
begin write(i:8); error(e) end;

procedure enterid(fip: ip);
{enter id pointed at by fip into the name-table,
  which on each declaration level is organised as
  an unbalanced binary tree}
var nam:alpha; lip,lip1:ip; lleft:boolean;
begin nam:=fip^.name;
  lip:=top^.fname;
  if lip=nil then top^.fname:=fip else
    begin
      repeat lip1:=lip;
	if lip^.name>nam then
	  begin lip:=lip^.llink; lleft:=true end
	else
	  begin if lip^.name=nam then errid(+02,nam);  {name conflict}
	    lip:=lip^.rlink; lleft:=false;
	  end;
      until lip=nil;
      if lleft then lip1^.llink:=fip else lip1^.rlink:=fip
    end;
  fip^.llink:=nil; fip^.rlink:=nil
end;

procedure initpos(var p:position);
begin p.lv:=level; p.sg:=0; p.ad:=0 end;

function newip(kl:idclass; n:alpha; idt:sp; nxt:ip):ip;
var p:ip;
begin
  case kl of
    types:
      new(p,types);
    konst:
      begin new(p,konst); p^.value:=0 end;
    vars:
      begin new(p,vars); p^.vflag:=[used,assigned]; initpos(p^.vpos) end;
    field:
      begin new(p,field); p^.foffset:=0 end;
    proc,func:
      begin new(p,proc,actual); p^.pfkind:=actual; p^.pflag:=[];
	initpos(p^.pfpos); p^.pfno:=0; p^.parhead:=nil; p^.headlc:=0
      end
  end;
  p^.name:=n; p^.klass:=kl; p^.idtype:=idt; p^.next:=nxt;
  p^.llink:=nil; p^.rlink:=nil; newip:=p
end;

procedure init1;
var c:char;
begin
{initialize the first name space}
  new(top,blck); top^.occur:=blck; top^.nlink:=nil; top^.fname:=nil;
  level:=0;
{reserved words}
  rw[ 0]:='if      ';	rw[ 1]:='do      ';	rw[ 2]:='of      ';
  rw[ 3]:='to      ';	rw[ 4]:='in      ';	rw[ 5]:='or      ';
  rw[ 6]:='end     ';	rw[ 7]:='for     ';	rw[ 8]:='nil     ';
  rw[ 9]:='var     ';	rw[10]:='div     ';	rw[11]:='mod     ';
  rw[12]:='set     ';	rw[13]:='and     ';	rw[14]:='not     ';
  rw[15]:='then    ';	rw[16]:='else    ';	rw[17]:='with    ';
  rw[18]:='case    ';	rw[19]:='type    ';	rw[20]:='goto    ';
  rw[21]:='file    ';	rw[22]:='begin   ';	rw[23]:='until   ';
  rw[24]:='while   ';	rw[25]:='array   ';	rw[26]:='const   ';
  rw[27]:='label   ';	rw[28]:='repeat  ';	rw[29]:='record  ';
  rw[30]:='downto  ';	rw[31]:='packed  ';	rw[32]:='program ';
  rw[33]:='function';	rw[34]:='procedur';
{corresponding symbols}
  rsy[ 0]:=ifsy;	rsy[ 1]:=dosy;		rsy[ 2]:=ofsy;
  rsy[ 3]:=tosy;	rsy[ 4]:=insy;		rsy[ 5]:=orsy;
  rsy[ 6]:=endsy;	rsy[ 7]:=forsy;		rsy[ 8]:=nilcst;
  rsy[ 9]:=varsy;	rsy[10]:=divsy;		rsy[11]:=modsy;
  rsy[12]:=setsy;	rsy[13]:=andsy;		rsy[14]:=notsy;
  rsy[15]:=thensy;	rsy[16]:=elsesy;	rsy[17]:=withsy;
  rsy[18]:=casesy;	rsy[19]:=typesy;	rsy[20]:=gotosy;
  rsy[21]:=filesy;	rsy[22]:=beginsy;	rsy[23]:=untilsy;
  rsy[24]:=whilesy;	rsy[25]:=arraysy;	rsy[26]:=constsy;
  rsy[27]:=labelsy;	rsy[28]:=repeatsy;	rsy[29]:=recordsy;
  rsy[30]:=downtosy;	rsy[31]:=packedsy;	rsy[32]:=progsy;
  rsy[33]:=funcsy;	rsy[34]:=procsy;
{indices into rw to find reserved words fast}
  frw[0]:= 0; frw[1]:= 0; frw[2]:= 6; frw[3]:=15; frw[4]:=22;
  frw[5]:=28; frw[6]:=32; frw[7]:=33; frw[8]:=35;
{char types}
  for c:=chr(0) to chr(maxcharord) do cs[c]:=others;
  for c:='0' to '9' do cs[c]:=digit;
  for c:='A' to 'Z' do cs[c]:=upper;
  for c:='a' to 'z' do cs[c]:=lower;
  for c:=chr(10) to chr(13) do cs[c]:=layout;	{lf,ht,ff,cr}
{characters with corresponding chartype in ASCII order}
  cs['	']:=tabch;	cs[' ']:=layout;	cs['"']:=dquotech;
  cs['''']:=quotech;
  cs['(']:=lparentch;	cs[')']:=rparentch;	cs['*']:=star;
  cs['+']:=plusch;	cs[',']:=commach;	cs['-']:=minch;
  cs['.']:=periodch;	cs['/']:=slash;		cs[':']:=colonch;
  cs[';']:=semich;	cs['<']:=lessch;	cs['=']:=equal;
  cs['>']:=greaterch;	cs['[']:=lbrackch;	cs[']']:=rbrackch;
  cs['^']:=arrowch;	cs['_']:=undscore;	cs['{']:=lbracech;
{single character symbols in chartype order}
  csy[rparentch]:=rparent;	csy[lbrackch]:=lbrack;
  csy[rbrackch]:=rbrack;	csy[commach]:=comma;
  csy[semich]:=semicolon;	csy[arrowch]:=arrow;
  csy[plusch]:=plussy;		csy[minch]:=minsy;
  csy[slash]:=slashsy;		csy[star]:=starsy;
  csy[equal]:=eqsy;
end;

procedure init2;
var s:sp; p,q:ip; k:idclass;
begin
{undefined identifier pointers used by searchid}
  for k:=types to func do
    undefip[k]:=newip(k,spaces,nil,nil);
{standard type pointers}
  new(s,scalar); s^.form:=scalar; s^.sflag:=[];
    s^.size:=intsize; s^.scalno:=0; s^.fconst:=nil; intptr:=s;
  new(s,scalar); s^.form:=scalar; s^.sflag:=[];
    s^.size:=realsize; s^.scalno:=0; s^.fconst:=nil; realptr:=s;
  new(s,scalar); s^.form:=scalar; s^.sflag:=[];
    s^.size:=charsize; s^.scalno:=0; charptr:=s;
  new(s,scalar); s^.form:=scalar; s^.sflag:=[];
    s^.size:=boolsize; s^.scalno:=0; boolptr:=s;
  new(s,pointer); s^.form:=pointer; s^.sflag:=[];
    s^.eltype:=nil; nilptr:=s;  {size set in handleopts}
  new(s,files); s^.form:=files; s^.sflag:=[withfile];
    s^.filtype:=charptr; textptr:=s;  {see handleopts}
  new(s,power); s^.form:=power; emptyset:=s; s^.size:=intsize;
    s^.elset:=nil; s^.sflag:=[];
  new(s,pointer); s^.form:=pointer; s^.sflag:=[];
    s^.eltype:=nil; stringptr:=s;  {see handleopts}
{standard type names}
  enterid(newip(types,'integer ',intptr,nil));
  enterid(newip(types,'real    ',realptr,nil));
  enterid(newip(types,'char    ',charptr,nil));
  enterid(newip(types,'boolean ',boolptr,nil));
  enterid(newip(types,'text    ',textptr,nil));
{standard constant names}
  q:=nil; p:=newip(konst,'false   ',boolptr,q); enterid(p);
  q:=p; p:=newip(konst,'true    ',boolptr,q); p^.value:=1; enterid(p);
  boolptr^.fconst:=p;
  p:=newip(konst,'maxint  ',intptr,nil); p^.value:=maxint; enterid(p);
  p:=newip(konst,spaces,charptr,nil); p^.value:=maxcharord;
  charptr^.fconst:=p;
end;

procedure init3;
var j:standpf; p:ip; q:np;
    pfn:array[standpf] of alpha;
    ftype:array[feof..farctan] of sp;
begin
{names of standard procedures/functions}
  pfn[pread	]:='read    ';	pfn[preadln	]:='readln  ';
  pfn[pwrite	]:='write   ';	pfn[pwriteln	]:='writeln ';
  pfn[pput	]:='put     ';	pfn[pget	]:='get     ';
  pfn[ppage	]:='page    ';	pfn[preset	]:='reset   ';
  pfn[prewrite	]:='rewrite ';	pfn[pnew	]:='new     ';
  pfn[pdispose	]:='dispose ';	pfn[ppack	]:='pack    ';
  pfn[punpack	]:='unpack  ';	pfn[pmark	]:='mark    ';
  pfn[prelease	]:='release ';	pfn[phalt	]:='halt    ';
  pfn[feof	]:='eof     ';	pfn[feoln	]:='eoln    ';
  pfn[fabs	]:='abs     ';	pfn[fsqr	]:='sqr     ';
  pfn[ford	]:='ord     ';	pfn[fchr	]:='chr     ';
  pfn[fpred	]:='pred    ';	pfn[fsucc	]:='succ    ';
  pfn[fodd	]:='odd     ';	pfn[ftrunc	]:='trunc   ';
  pfn[fround	]:='round   ';	pfn[fsin	]:='sin     ';
  pfn[fcos	]:='cos     ';	pfn[fexp	]:='exp     ';
  pfn[fsqrt	]:='sqrt    ';	pfn[fln		]:='ln      ';
  pfn[farctan	]:='arctan  ';
{parameter types of standard functions}
  ftype[feof	]:=nil;		ftype[feoln	]:=nil;
  ftype[fabs	]:=nil;		ftype[fsqr	]:=nil;
  ftype[ford	]:=nil;		ftype[fchr	]:=intptr;
  ftype[fpred	]:=nil;		ftype[fsucc	]:=nil;
  ftype[fodd	]:=intptr;	ftype[ftrunc	]:=realptr;
  ftype[fround	]:=realptr;	ftype[fsin	]:=realptr;
  ftype[fcos	]:=realptr;	ftype[fexp	]:=realptr;
  ftype[fsqrt	]:=realptr;	ftype[fln	]:=realptr;
  ftype[farctan	]:=realptr;	
{standard procedure/function identifiers}
  for j:=pread to phalt do
    begin new(p,proc,standard); p^.klass:=proc;
      p^.name:=pfn[j]; p^.pfkind:=standard; p^.key:=j; enterid(p);
    end;
  for j:=feof to farctan do
    begin new(p,func,standard); p^.klass:=func; p^.idtype:=ftype[j];
      {idtype is used not for result type but for parameter type !! }
      p^.name:=pfn[j]; p^.pfkind:=standard; p^.key:=j; enterid(p);
    end;
{program identifier}
  progp:=newip(proc,'_main   ',nil,nil);
{new name space for user externals}
  new(q,blck); q^.occur:=blck; q^.nlink:=top; q^.fname:=nil; top:=q;
end;

procedure init4;
var c:char;
begin
{pascal library mnemonics}
  lmn[OPN ]:='_opn';	lmn[GETX]:='_get';	lmn[RDI ]:='_rdi';
  lmn[RDC ]:='_rdc';	lmn[RDR ]:='_rdr';	lmn[RLN ]:='_rln';
  lmn[ELN ]:='_eln';	lmn[EFL ]:='_efl';
  lmn[CLS ]:='_cls';
  lmn[CRE ]:='_cre';	lmn[PUTX]:='_put';	lmn[WRI ]:='_wri';
  lmn[WSI ]:='_wsi';	lmn[WRC ]:='_wrc';	lmn[WSC ]:='_wsc';
  lmn[WRS ]:='_wrs';	lmn[WSS ]:='_wss';	lmn[WRB ]:='_wrb';
  lmn[WSB ]:='_wsb';	lmn[WRR ]:='_wrr';	lmn[WSR ]:='_wsr';
  lmn[WRF ]:='_wrf';	lmn[WRZ ]:='_wrz';	lmn[WSZ ]:='_wsz';
  lmn[WLN ]:='_wln';	lmn[PAG ]:='_pag';
  lmn[ABR ]:='_abr';	lmn[RND ]:='_rnd';	lmn[SIN ]:='_sin';
  lmn[COS ]:='_cos';	lmn[EXPX]:='_exp';	lmn[SQT ]:='_sqt';
  lmn[LOG ]:='_log';	lmn[ATN ]:='_atn';	lmn[ABI ]:='_abi';
  lmn[BCP ]:='_bcp';	lmn[BTS ]:='_bts';	lmn[NEWX]:='_new';
  lmn[SAV ]:='_sav';	lmn[RST ]:='_rst';	lmn[INI ]:='_ini';
  lmn[HLT ]:='_hlt';	lmn[ASS ]:='_ass';	lmn[GTO ]:='_gto';
  lmn[PAC ]:='_pac';	lmn[UNP ]:='_unp';	lmn[DIS ]:='_dis';
{opts}
  for c:='a' to 'z' do begin opt[c]:=0; forceopt[c]:=false end;
  opt['a']:=on;
  opt['i']:=maxsetint+1;
  opt['l']:=on;
  opt['o']:=on;
  opt['r']:=on;
  sopt:=off;
{scalar variables}
  b.nextbp:=nil;
  b.lc:=intsize;  {word 0 for line numbers}
  b.ilbno:=0;
  b.forwcount:=0;
  b.lchain:=nil;
  lino:=0;
  dlbno:=0;
  argc:=1;
  lastpfno:=0;
  giveline:=true;
  eofexpected:=false;
  intypedec:=false;
  fltused:=false;
  seconddot:=false;
  iop[false]:=nil;
  iop[true]:=nil;
end;

procedure handleopts;
begin
  copt:=opt['c'];
  iopt:=opt['i'];
  sopt:=opt['s'];
  vopt:=opt['v'];
  ptrsize:=2; if vopt<>off then ptrsize:=ptrsize+2;
  fhsize:=6*intsize + 2*ptrsize;
  nilptr^.size:=ptrsize; textptr^.size:=fhsize+buffersize;
  stringptr^.size:=ptrsize;
  progp^.headlc:=intsize+ptrsize;
  if sopt<>off then begin cs['_']:=others; copt:=off end;
  if copt<>off then enterid(newip(types,'string  ',stringptr,nil));
  if opt['o']=off then gen1(ps_mes,1);
  if vopt<>off then gen1(ps_mes,2);
end;

{===================================================================}

procedure trace(tname:alpha; fip:ip; var namdlb:integer);
var i:integer;
begin
  if opt['t']<>off then
    begin
      if namdlb=0 then
	begin dlbno:=dlbno+1; namdlb:=dlbno; gendlb(