#
/*
 *
 *	This is a program to analyse the contents
 *	of the proc array, found in a dump of memory
 *	after a crash.
 *
 *	P. Ivanov.	UNSW.	14-4-77.
 *
 *	C. McGregor.	UNSW.	Jan-77.
 */

#define	UNSW
#define	UNSWPAGED
#include <param.h>
#include <proc.h>
#include <tty.h>
#include <user.h>
#include <inode.h>
#include <file.h>


#define	NOSTAT	7		/* number of status codes possible */
#define	NOFLAG	8		/* number of flag codes possible */
#define	NOTTYFLG	16	/* number of stty flag codes */
#define	NOTTYIST	16	/* number of tty internal states */
#define	U_PTAB	"%5t%r"
#define	S_PTAB	"          %r"	/* stack trace indent */
#define	SS_PTAB	"%50t%r"	/* secondary stack indent - local variables */
#define	Y_PTAB	"     %r"	/* ttydecode indent */
#define	C_PTAB	"          %r"	/* char list decode indent */
#define	DEBUG	if (dflg)
#define	WARNING	if (!wflg)
#define	LINEWIDTH	132	/* line size for line and star */
#define	TAB	"     %r"	/* tab indent */
#define	USERADR	0140000		/* present user start address */
#ifdef	UNSWPAGED
#define	PAGEADR	0120000		/* start address of re-mapped page */
#define	KISA5	0172352
#endif

char	*stat[];
char	*flag[NOFLAG];
char	*signals[NSIG+1];

struct	regs {
	int	r_word0;
	int	r_word1;
	int	r_reg[7];
	int	r_kisa6;
#ifdef	UNSWPAGED
	int	r_kisa5;
#endif
	} regs;

struct	symbol {
	char	s_symbol[8];
#ifndef	UNSWPAGED
	int	s_symflg;
#endif
#ifdef	UNSWPAGED
	char	s_symflg;
	char	s_symseg;
#endif
	char	*s_symval;
	} names;

#ifdef	UNSWPAGED
#define	MAXSEG	30
int	segbase[MAXSEG];
int	maxseg;
#endif

char	wkbuf[512];
int	*regbuf;		/* equivalenced to wkbuf */
int	corefd;
int	namefd;

int	aflg, bflg, cflg, dflg;
int	fflg, gflg;
int	capfflg;
int	iflg;
int	kflg, lflg;
int	nflg;
int	oflg, pflg;
int	sflg, tflg, uflg;
int	wflg, xflg, yflg, zflg;

/*
 *	flags:
 *	a - dump in ascii
 *	b - dump in bytes
 *	c - dump in chars
 *	d - debugging output flag
 *	f - decode file structure references
 *	F - (capital F) full dump flag
 *	i - decode inode structure references
 *	k - expects ka6 and aps values to be given	(not yet implemented)
 *	l - list all process slots, even unassigned ones
 *	n - give alternate namelist file (default /unix) as last arg
 *	o - dump in octal
 *	p - followed by digits dumps only that process
 *	s - user structure stack trace
 *	t - examine forking trees
 *	u - dump user area, including ka6 if given
 *	w - warnings off  flag
 *	x - dump only text structures
 *	y - dump only tty structures
 *	z - do it all baby (very wordy)
 */

/* other random declarations */

struct {
	int	hiword;
	int	loword;
	};

struct {
	unsigned unsign;
	};

struct symbol	nullnum;
