#
/*
 * getty -- adapt to terminal speed on dialup, and call login
 */

/*
 *	Modified 10/77 Piers Lauder
 *	changes:
 *		generally tidied up
 *		new terminal types
 */

/*
#define	NEW_ACCT
	/*
	 *	piers lauder 	oct '77
	 *
	 *	"login" incorporated into "getty"
	 *	( users must now type CTRL-d at end of session
	 *	  to allow "init" to collect statistics )
	 */

/*
 * terminals
 */
#define	LA36		'd'
#define	VT05		'v'
#define	VT52		'V'
#define	TEKTRONICS	'g'
#define	TELERAY		'W'
#define	QUME		'q'
#define	TRANSDATA	'T'
/*
#define	IBM2741		'1'
#define	DIAL_IN		'0'
#define	ASR33		'-'
#define	NCR260		'N'
#define	IMLAC		'i'
#define	DIABLO		'd'
#define	CDC713		'c'
 */

/*
 * tty flags
 */
#define	HUPCL 01
#define	XTABS	02
#define	LCASE	04
#define	ECHO	010
#define	CRMOD	020
#define	RAW	040
#define	ODDP	0100
#define	EVENP	0200
#define	ANYP	0300
#define	INVCASE	04000
#define FLOWCNTRL 0100000

/*
 * Delay algorithms
 */
#define	NL1	000400
#define	NL2	001000
#define	NL3	001400
#define	TAB1	002000
#ifndef	INVCASE
#define	TAB2	004000
#define	TAB3	006000
#endif
#define	CR1	010000
#define	CR2	020000
#define	CR3	030000
#define	FF1	040000
#ifndef	FLOWCNTRL
#define	BS1	0100000
#endif

#define	ERASE	'#'
#define	KILL	'@'

/*
 * speeds
 */
#define	B110	3
#define B134_5	4
#define	B150	5
#define	B300	7
#define	B600	8
#define B1200	9
#define B2400	11
#define B4800	12
#define	B9600	13

#define	SIGINT	2
#define	SIGQIT	3

struct	sgtty {
	char	sgispd, sgospd;
	char	sgerase, sgkill;
	int	sgflag;
} tmode;

char	nlbel[]	"\r\n\007";

struct	tab {
	char	tname;		/* this table name */
	char	nname;		/* successor table name */
	int	iflags;		/* initial flags */
	int	fflags;		/* final flags */
	char	ispeed;		/* input speed */
	char	ospeed;		/* output speed */
	char	*message;	/* login message */
} itab[] {

#ifdef	DIAL_IN
/* table '0'-1-2 300,150,110 */

  {	'0', 1,
	ANYP+RAW+NL1+CR1, ANYP+CR1+ECHO+XTABS,
	B300, B300,
	"\n\r\033;\007"
  },

  {	1, 2,
	EVENP+RAW+NL1+CR1, EVENP+ECHO+FF1+CR2+TAB1+NL1,
	B150, B150,
	"\n\r\033:\006\006\017"
  },

  {	2, '0',
	ANYP+RAW+NL1+CR1, ANYP+ECHO+XTABS+CR1,
	B110, B110,
	nlbel
  },
#endif

#ifdef	ASR33
/* table '-' -- ASR33 110 */
  {	'-', '-',
	ANYP+RAW+NL1+CR1, ANYP+ECHO+XTABS+CR1,
	B110, B110,
	nlbel
  },
#endif

#ifdef	IBM2741
/* table '1' -- 134_5 */
  {	'1', '1',
	EVENP+RAW+NL1, EVENP+NL1,
	B134_5, B134_5,
	"\n"
  },
#endif

#ifdef	UFO
/* table '9' -- 9600 */
  {	'9', '9',
	ANYP+RAW+NL1+CR1, ANYP+XTABS+ECHO+FF1,
	B9600, B9600,
	"\n\r\033;"
  },
#endif

#ifdef	VT05
/* table 'v' -- vt05 */
  {	'v','v',
	ANYP+RAW+NL2, ANYP+NL2+XTABS+ECHO,
	B4800, B4800,
	"\035\035\035\035\037\037\037\037"
  },
#endif

#ifdef	LA36
/* tabde 'd' -- LA36 */
  {	'd', 'd',
	ANYP+RAW, ANYP+XTABS+ECHO,
	B300, B300,
	nlbel
  },
#endif

#ifdef	VT52
/* table 'v' -- vt52/5 */
  {	'v', 'v',
	ANYP+RAW, ANYP+ECHO,
	B4800, B4800,
	nlbel
  },
#endif

#ifdef	TELERAY
/* table 'W' -- for TELERAY at 4800 */
  {	'W', 'W',
	ANYP+RAW, ANYP+ECHO+XTABS,
	B4800, B4800,
	nlbel
  },
#endif

#ifdef	DIABLO
/* table 'd'-'D' -- Diablo Hyterm at 1200-300 baud */
  {	'd', 'D',
	EVENP+RAW, EVENP+FLOWCNTRL,
	B1200, B1200,
	"\033B\r\n"
  },

  {	'D', 'd',
	EVENP+RAW, EVENP,
	B300, B300,
	"\033B\r\n"
  },
#endif

#ifdef	IMLAC
/* table 'i'-9-10 -- IMLAC 9600-4800-300 baud */
  {	'i', 9,
	ANYP+RAW, ANYP+XTABS,
	B9600, B9600,
	nlbel
  },

  {	9, 10,
	ANYP+RAW, ANYP+XTABS,
	B4800, B4800,
	nlbel
  },

  {	10, 'i',
	ANYP+RAW, ANYP+XTABS,
	B300, B300,
	nlbel
  },
#endif

#ifdef	NCR260
/* table 'N' -- NCR260 needs inverted case and special delays */
  {	'N', 'N',
	EVENP+RAW+NL2+CR3+INVCASE, EVENP+XTABS+ECHO+NL2+CR3+INVCASE,
	B300, B300,
	nlbel
  },
#endif

#ifdef	CDC713
/* table 'c' -- CDC713 */
  {	'c', 'c',
	EVENP+RAW, EVENP+XTABS,
	B300, B300,
	nlbel
  },
#endif

#ifdef	TEKTRONICS
/* table 't' -- tektronics at 4800bd */
  {	'g', 'g',
	ANYP+RAW+CR1, ANYP+ECHO+XTABS+CR1,
	B4800, B4800,
	nlbel
  },
#endif

#ifdef	QUME
/* table 'q' -- qume sprint printer at 300bd */
  {	'q', 'q',
	ANYP+RAW, ANYP+ECHO+XTABS,
	B300, B300,
	nlbel
  },
#endif

#ifdef	TRANSDATA
/* table 'T'-'t' -- transdata at 300-4800bd */
  {	't', 'T',
	EVENP+RAW, EVENP+ECHO+XTABS,
	B300, B300,
	nlbel
  },
  {	'T', 't',
	EVENP+RAW, EVENP+ECHO+XTABS,
	B4800, B4800,
	nlbel
  },
#endif
};

#define	NITAB	sizeof itab/sizeof itab[0]

char	name[16];
int	crmod;
int	upper;
int	lower;

main(argc, argv)
char **argv;
{
	register struct tab *tabp;
	register tname;
	register i;

/*
	signal(SIGINT, 1);
	signal(SIGQIT, 0);
*/
	tname = '0';
	if (argc > 1)
		tname = *argv[1];
	for (;;) {
		for(tabp = itab; tabp < &itab[NITAB]; tabp++)
			if(tabp->tname == tname)
				break;
		if(tabp >= &itab[NITAB])
			tabp = itab;
		tmode.sgispd = tabp->ispeed;
		tmode.sgospd = tabp->ospeed;
		tmode.sgflag = tabp->iflags;
		stty(0, &tmode);
		puts(tabp->message);
#ifdef	NEW_ACCT
loop:
#endif
		puts( "login: " );
		if(getname()) {
#ifdef	DIABLO
			if ( tname == 'D' || tname == 'd' )  {		/* set tab stops */
				puts( "\0332\033\t\001\0339" );
				for ( i = 9 ; i < 132 ; i =+ 8 )  {
					puts( "\033\t" );
					putc( i );
					puts( "\0331" );
				}
				putc( '\r' );
			}
#endif
			tmode.sgerase = tname == '-' ? '#' : ERASE;
			tmode.sgkill = KILL;
			tmode.sgflag = tabp->fflags;
			if(crmod)
				tmode.sgflag =| CRMOD;
			if(upper)
#ifdef	INVCASE
				if ( !(tabp->iflags & INVCASE) )
#endif
				tmode.sgflag =| LCASE;
			if(lower)
				tmode.sgflag =& ~LCASE;
			stty(0, &tmode);
#ifndef	NEW_ACCT
			execl("/bin/login", "login", name, 0);
			exit(1);
#endif
#ifdef	NEW_ACCT
			if ( !login() )
				goto loop;
#endif
		}
		tname = tabp->nname;
	}
}

getname()
{
	register char *np;
	register c;
	static cs;

	crmod = 0;
	upper = 0;
	lower = 0;
	np = name;
	do {
		if (read(0, &cs, 1) <= 0)
			exit(0);
		if ((c = cs&0177) == 0)
			return(0);
		putc( c );
		if (c>='a' && c <='z')
			lower++;
		else if (c>='A' && c<='Z') {
			upper++;
			c =+ 'a'-'A';
		} else if (c==ERASE) {
			if (np > name)
				np--;
			continue;
		} else if (c==KILL) {
			np = name;
			continue;
		}
		*np++ = c;
	} while (c!='\n' && c!='\r' && np <= &name[16]);
	*--np = 0;
	if (c == '\r') {
		putc( '\n' );
		crmod++;
	} else
		putc( c );
	return(1);
}

puts(s)
register char *s;
{
	register c;

	while ( c = *s++ )
		putc( c );
}


putc( c )
{
  write( 1 , &c , 1 );
}
