#

	/*
	 *	TEKTRONIX OUTPUT MODULE
	 */

#include "../gpac.h"
#include "tek.h"


int Gtekmode MLTO;

Gtekout(word)
	int word;
	{
	register int w;
	static int lword, gotone;
	static charcnt;

	w = word;
	if(Gtekmode == CHAR)
		{
		Gputc(w & 0377);
		Gputc((w>>8) & 0377);
		if((charcnt =- 2) <= 0)
			{
			Gtekmode = MLTO;
			Gtekmoveto(Gtxabs, Gtyabs);
			}
		}
	   else
		if(!gotone)
			{
			if((w & 0177400) == CHARACTER_COMMAND)
				{
				Gtekmode = CHAR;
				charcnt = (w & 0377) << 1;
				Gputc(ENTER_ALPHA);
				}
			   else
				{
				lword = w;
				gotone++;
				}
			}
		   else
			{
			Gtekmlto(lword, w);
			gotone = 0;
			}
	}


Gtekmlto(word1, word2)
	int word1, word2;
	{
	register x, y;

	x = (word1 & 07777)>>2;
	y = (word2 & 07777)>>2;
	if(y > 779)
		y = 779;
	if(x == Gtxabs && y == Gtyabs)
		return;
	if(word1 < 0)
		Gtekmoveto(x, y);
	   else
		Gteklineto(x, y);
	}


Gtekmoveto(x, y)
	int x, y;
	{

	Gputc(ENTER_GRAPH);
	Gteklineto(x, y);
	}


Gteklineto(x, y)
	int x, y;
	{
	register hix, hiy;
	register codes;
	int loy, lox;

	hix = (x>>5) | HIX;
	hiy = (y>>5) | HIY;
	lox = (x&037) | LOX;
	loy = (y&037) | LOY;
	codes = 0;
	if(hix != Glhix)
		codes =| 016;
	if(hiy != Glhiy)
		codes =| 01;
	if(lox != Gllox)
		codes =| 010;
	if(loy != Glloy)
		codes =| 012;
	if(codes&01)
		Gputc(hiy);
	if(codes&02)
		Gputc(loy);
	if(codes&04)
		Gputc(hix);
	if(codes&010)
		Gputc(lox);
	if(!codes)
		Gputc(lox);
	Glhiy = hiy;
	Glloy = loy;
	Glhix = hix;
	Gllox = lox;
	Gtxabs = x;
	Gtyabs = y;
	}


Gtekclear()
	{

	Gputc(CLEAR1);
	Gputc(CLEAR2);
	}



Gtekinitialize()
	{

	Gdev_file = open("/dev/tty", 2);
	Gtekclear();
	Gtekmoveto(0, 760);
	Gputc(ENTER_ALPHA);
	}


Gputc(c)
	char c;
	{

	write(Gdev_file, &c, 1);
	}
