#

	/*
	 *	GPAC TABLET GW ROUTINES
	 */


#include "../gpac.h"
#include "../error_codes.h"
#include "tek.h"
#include "tab.h"

Gdissa_ink()
	{
	int npts, ncurves, x, y, format, i;
	register *dfptr, *bptr, *vptr;

	if(Gtablet.edge_vec != 0)
		{
		free(Gtablet.edge_vec);
		free(Gtablet.bptr);
		}
	npts = 0;
	ncurves = 0;
	for(dfptr = Gtablet.buf_addr+1; *dfptr != TERM ; dfptr =+ 2)
		{
		if(*dfptr < 0)
			ncurves++;
		npts++;
		}
	if((i = alloc((ncurves+1)<<1)) == -1)
		return(Gerror(ALLOC_ERR, "inking"));
	vptr =  Gtablet.edge_vec = i;
	*vptr++ = ncurves;
	if((i = alloc((ncurves+(npts<<1))<<1)) == -1)
		return(Gerror(ALLOC_ERR, "inking"));
	bptr = Gtablet.bptr = i;
	ncurves = 0;
	npts = 0;
	for(dfptr = Gtablet.buf_addr+1; *dfptr != TERM; dfptr =+ 2)
		{
		if(*dfptr < 0)
			{
			if(ncurves != 0)
				*(bptr-2*npts-1) = npts;
			*vptr++ = bptr;
			bptr++;
			ncurves++;
			npts = 0;
			}
		*bptr++ = ((*dfptr)>>2)&01777;
		*bptr++ = (*(dfptr+1)>>2)&01777;
		npts++;
		}
	if(ncurves != 0)
		*(bptr-2*npts-1) = npts;
	Gevent.ink_ptr = Gtablet.edge_vec;
	GOOD_RETURN;
	}
