#
/*
 | DZ-11	8 line Asynchronous multiplexor
 |
 |		supports up to 8 dz's.
 */
#include "../param.h"
#include "../conf.h"
#include "../user.h"
#include "../tty.h"
#include "../proc.h"

int *DZADDR[]	{0160020, 0};
#define dzaddr(_x_)	(DZADDR[(_x_>>3) & 017])
struct {
	int	dzcsr;	/* control & status */
	int	dzlpr;	/* line parameter (write only)*/
	char	dztcr;	/* trans. control */
	char	dzdtr;	/* data term. ready */
	char	dztbuf;	/* trans. buff (write only) */
	char	dzbrk;	/* Break (write only) */
};
#define dzrbuf	dzlpr	/* rec. buf (read only) */
#define dzring	dztbuf	/* ring (read only) */
#define dzcar	dzbrk	/* carrier detc. (read only) */


#define NDZ11	1	/* number of dz11's */
#define BUFCHK	04000	/* check ring flag -- buffer overflow */
int	dzdly	0177;	/* delay for buffer full */

struct tty dz11[NDZ11 * 8];

/*	--	line parameter -- comm. options */
#define BITS7	020	/* char. length 7 bits */
#define BITS8	030	/*  "      "    8  "   */
#define TWOSTP	040	/* 2 stop bits */
#define EVENP	0100	/* even parity */
#define ODDP	0200	/* odd    " */
#define RCVON	010000	/* receiver on */

#define SSPEED	7	/* 300 bauds. default */

/*	--	control & status */
#define	RESET	020	/* clear & reset all */
#define MSE	040	/* Master Scan Enable */
#define RIE	0100	/* rec. int. enable */
#define SIE	010000	/* Silo alarm int. enable */
#define TIE	040000	/* Trans. int. enable */
#define IENABLE	(RIE|TIE)

/*	--	receiver buffer */
#define OVRN	040000	/* overrun */
#define FERR	020000	/* framming error */
#define PERR	010000	/* parity error */

#define dzbar(lineno)	(1 << (lineno & 07))
#define MMODEM	0100	/* flag for monitor modem */
#define HOLD	0200	/* new state flag: hold output */

int dzspd[] {
	   -1,	/* -- */
	    0,	/* 50 bauds */
	 0400,	/* 75 */
	01000,	/* 110	*/
	01400,	/* 134.5*/
	02000,	/* 150	*/
	   -1,	/* 200 -- not supported */
	02400,	/* 300	*/
	03000,	/* 600	*/
	03400,	/* 1200	*/
	04000,	/* 1800	*/
	05000,	/* 2400	*/
	06000,	/* 4800 */
	07000,	/* 9600 */
	   -1,	/* XA  -- not supported */
	   -1,	/* XB      "      "     */
	04400,	/* 2000 */
	05400,	/* 3600 */
	06400,	/* 7200 */
};


/*
 | enable a dz11 line
 | If modem control is requested, then will wait
 | till carrier is present;
 */
dzopen(dev, flag) {
	register struct tty *tp;
	register n;
	extern dzstart();

	if((n= (dev.d_minor)) >= NDZ11 * 8) {
		u.u_error = ENXIO;
		return;
	}
	tp = &dz11[n];
	tp->t_addr = dzstart;
	tp->t_dev  = dev;
	tp->t_state =| SSTART;
	if((tp->t_state & ISOPEN) == 0) {
		tp->t_erase = CERASE;
		tp->t_kill  = CKILL;
		tp->t_speeds= SSPEED | (SSPEED<<8);
		tp->t_flags = ECHO;
		dzparam(tp);
	}
	if(!(dev.d_minor & MMODEM))
		tp->t_state =| CARR_ON;
	tp->t_state =| ISOPEN;
	if(u.u_procp->p_ttyp == 0)
		u.u_procp->p_ttyp = tp;
}

dzclose(dev) {
	register struct tty *tp;
	register lpr, *addr;

	tp = &dz11[dev.d_minor];
	tp->t_state =& (CARR_ON|SSTART);
	wflushtty(tp);
	addr = dzaddr(tp->t_dev.d_minor);
	lpr = tp->t_dev.d_minor & 07;
	addr->dzlpr = lpr;
	addr->dzdtr =& ~dzbar(lpr);
}

/*
 | read interface
 */
dzread(dev) {
	ttread(&dz11[dev.d_minor]);
}

/*
 | write interface
 */
dzwrite(dev) {
	ttwrite(&dz11[dev.d_minor]);
}
/*
 | stty/gtty interface
 */
dzsgtty(dev, av)
int *av; {
	register struct tty *tp;

	tp = &dz11[dev.d_minor];
	if(ttystty(tp, av))
		return;
	dzparam(tp);
}

/*
 | sets the communication options
 | into the hardware.
 | called by open or stty.
 */
dzparam(atp)
struct tty *atp; {
	register struct tty *tp;
	register *addr, lpr;

	tp =atp;
	addr = dzaddr(tp->t_dev.d_minor);
	spl5();
	lpr = tp->t_dev.d_minor & 07;
	if(tp->t_speeds.lobyte == 0) {	/* hung up line */
		tp->t_flags =| HUPCL;
		addr->dzdtr =& ~dzbar(lpr);
		return;
	}
	if(tp->t_flags & EVENP)
		if(tp->t_flags & ODDP)
			lpr =| BITS8; else
			lpr =| BITS7 | EVENP;
					else
		lpr =| BITS7 | EVENP | ODDP;
	lpr =| RCVON;
	if(((lpr =| dzspd[tp->t_speeds.lobyte % 18]) < 0) ||
	    (tp->t_speeds.lobyte != tp->t_speeds.hibyte)) {
		/* ignore bad speed setting */
		spl0();
		return;
	}
	/*
	 | cdc terminal require 2 stop bits when set to 9600
	 */
	if(tp->t_speeds.lobyte == 13)	
		lpr =| TWOSTP;
	addr->dzlpr = lpr;
	addr->dzcsr =| IENABLE | MSE;
	addr->dzdtr =| dzbar(tp->t_dev.d_minor);
	if(addr->dzcar & dzbar(tp->t_dev.d_minor))
		tp->t_state =| CARR_ON;
	spl0();
}

/*
 | receiver interrupt
 */
dzrint(dev) {
	register struct tty *tp;
	register c, *addr;

	addr = DZADDR[dev];
loop:
	while((c = addr->dzrbuf) < 0) {	/* data available */
		tp = &dz11[((c>>8) & 07) + dev*8];
		if((tp->t_state&ISOPEN)==0 || (c&PERR)) {
			if(addr->dzcar & dzbar(c>>8))
				tp->t_state =| CARR_ON;
			wakeup(tp);
			continue;
		}
		if(c & FERR)	/* break char -- wrong speed? */
			if(tp->t_flags&RAW)
				c = 0;		/* null (for getty) */
			else
				c = 0177;	/* DEL (intr) */
		if(tp->t_flags & BUFCHK)
		switch(c & 0177) {
		case 023:	/* hold printout */
			tp->t_state =| HOLD;
			addr->dztcr =& ~dzbar(c>>8);
			goto loop;
		case 021:	/* restart printout */
			tp->t_state =& ~HOLD;
			addr->dztcr =| dzbar(c>>8);
			goto loop;
		}
		ttyinput(c, tp);
	}
}

dzxint(dev) {
	register struct tty *tp;
	register ln, *addr;
	int c;
	extern ttrstrt();

	addr = DZADDR[dev];
	ln = (addr->dzcsr>>8) & 07;
	tp = &dz11[ln + dev*8];
#ifdef CCHECK
	if((tp->t_flags & BUFCHK) && ((addr->dzring & dzbar(ln))
	    || !(addr->dzcar & dzbar(ln)))) {
		c = dzdly;
		goto timo;
	}
#endif
	if((c = getc(&tp->t_outq)) >= 0) {
		if(c < 0200 || (tp->t_flags & SUPRAW)) {
			addr->dztbuf = c;
			goto out;
		}
		else {
	timo:
			timeout(ttrstrt, tp, (c & 0177)+6);
			tp->t_state =| TIMEOUT;
		}
	}
	/*
	 | we finished trans. on this line.
	 */
	addr->dztcr =& ~dzbar(ln);
out:
	if(tp->t_outq.c_cc <= TTLOWAT && tp->t_state & ASLEEP) {
		tp->t_state =& ~ASLEEP;
		wakeup(&tp->t_outq);
	}
}

/*
 | start/restart output on a given line
 | actually all it sets the bit for this line
 | in the Trans. control reg. the rest
 | is done by the interrupt routine
 */
dzstart(atp)
struct tty *atp; {
	register struct tty *tp;
	register bar, addr;
	int sps;
	extern ttrstrt();

	tp = atp;
	if(tp->t_state & (TIMEOUT | HOLD)) 
		return;
	sps = PS->integ;
	spl5();
	bar = dzbar(tp->t_dev.d_minor);
	addr = dzaddr(tp->t_dev.d_minor);
	if((tp->t_dev & MMODEM) && (addr->dzcar & bar) == 0) {
		/* no carrier detected */
	/* ---------------
		if(tp->t_state & CARR_ON)
			signal(tp, SIGHUP);
		flushtty(tp);
	------------------ */
		tp->t_state =& ~CARR_ON;
	}
	else {
		/*
		 | turn scanner on for this line
		 */
		addr->dztcr =| bar;
	}
	PS->integ = sps;
}
