#

	/*
	 * CODE GENERATOR MODULE FOR GPAC
	 */

#include "../gpac.h"
#include "../error_codes.h"


Ginsert_code(code)
	{

	*Gcodep++ = code;
	Gblksize--;
	}


Gmake_room(n)
	int n;
	{

	if(n > Gblksize)
		if(Gnewblk() == ERROR)
				ERROR_RETURN;
	GOOD_RETURN;
	}


Gadd_queue(type, x, y)
	int type, x, y;
	{
	register struct code_queue *p;
	register t;

	t = type;
	if(t & (VECTOR|BVECTOR))
		{
		p = &Gcode_queue[Gq_ptr-1];
		if(Gq_ptr && (p->xpos == x) && (p->ypos == y))
			return;
		}
	   else
		{
		for(p = &Gcode_queue[Gq_ptr-1]; p >= &Gcode_queue[0] &&
						!(p->c_type & (VECTOR|BVECTOR)); p--)
			if(p->c_type == t)
				goto overlay;
		}
	if(Gq_ptr >= CODE_Q_LEN)
		Ggenerate(1);
	p = &Gcode_queue[Gq_ptr++];
	p->c_type = t;
overlay :
	p->xpos = x;
	p->ypos = y;
	}


Ggenerate(n)
	int n;
	{
	register struct code_queue *a, *b;

	if(n == 0) return;
	n = Ggencode(n);
	a = &Gcode_queue[0];
	b = &Gcode_queue[n];
	for(;b < &Gcode_queue[Gq_ptr]; b++)
		{
		a->c_type = b->c_type;
		a->xpos = b->xpos;
		a->ypos = b->ypos;
		a++;
		}
	Gq_ptr =- n;
	}
