/*
 search a file in tape directory to be read on CYBER

 input: tape directory on "dir".
 parameters: file name, 2nd file if 1st is archive.
 output: SCOPE job to read the file
 */ 

struct tent {
	/* tape entry */ 
	char pathname[32];
	int mode;
	char uid, gid;
	char spare, size0;
	int size1;
	int time[2];
	int tapea;
	int unused[8];
	int chksum;
} *dp;
char tpentry[512], *func "chdmp", *tfil "tmp";
int dcnt, dir;

main(c, v)
	int c;
	char **v;
{
	char register *p;
	int skip, copy, head;
	dcnt = 0;
	head = 0;
	if((dir = open("dir", 0)) < 0) {
		printf("cant open dir\n");
		exit();
	}
	printf("taaa,t15,cm40000,ms500,io100.skip-copy\n");
	printf("taaa,809910,comp\n");
	printf("attach(u,unix3,id=cs)\n");
	p = *++v;
	/* optional '-' parameter to use "conv" instead of "chdump" */ 
	if(*p == '-') {
		func = "conv";
		c--;
		p = *++v;
	}
	if(srchd(p)) {
		notfnd(p);
		exit();
	}
	skip = dp->tapea-head;
	if(skip)
		printf("skip%c(u,%d,0)\n", skip > 0?'f':'b', abs(skip));
	copy = ((dp->size1>>9)&0177)+1+(dp->size0<<7);
	printf("copybr(u,tmp,%d)\nrewind(tmp)\n", copy);
	printf("map(off)\n");
	p = *++v;
	/* activate "arcx" if 2 arguments */ 
	if(c > 2) {
		printf("attach,arcx,id=cs.\nl,name.%s\n", hex(p));
		printf("arcx(name,tmp,tmp1)\nrewind(tmp1)\n");
		tfil = "tmp1";
	}
	printf("route(unx,dc=pr,def,l=0,tid=cs,fc=d1)\n");
	printf("attach(%s,id=cs)\n%s(%s,unx)\n", func, func, tfil);
}
/*
 search tape directory for file
 */ 
srchd(s)
	char *s;
{
	while(rdir())
		if(compar(dp->pathname, s))
			return(0);
	return(1);
}
rdir() {
	if((dcnt++%8) == 0) {
		if(read(dir, tpentry, 512) <= 0) {
			printf("cant read dir\n");
			return(0);
		}
		dp = tpentry;
	}
	else
		dp++;
	if(dp->tapea == 0)
		return(0);
	return(1);
}
compar(a, b)
	char *a, *b;
{
	char register *x, *y;
	x = a;
	y = b;
	while(*x || *y)
		if(*x++ != *y++)
			return(0);
	return(1);
}
notfnd(a)
	char *a;
{
	int register n;
	for(n = 0; a[n]; n++)
		;
	write(2, a, n);
	write(2, " not found\n", 11);
}
/*
 translate file name to hex to be used by "arcx"
 */ 
char hname[28] "0000000000000000000000000000", tab[16] "0123456789ABCDEF";
hex(s)
	char *s;
{
	register char *p, *h, c;
	p = s;
	h = hname;
	while(c = *p++) {
		*h++ = tab[c>>4];
		*h++ = tab[c&017];
	}
	return(hname);
}
