#
#include "../param.h"
#include "../file.h"
#ifdef	ONCE
#include "../conf.h"
#include "../filsys.h"
#include "../tty.h"
#include "../buf.h"
#endif
#include "../user.h"
#include "../systm.h"
#include "../proc.h"
#include "../text.h"
#include "../inode.h"
#include "../seg.h"

#define	CLOCK1	0177546
#define	CLOCK2	0172540
/*
 * Icode is the octal bootstrap
 * program executed in user mode
 * to bring up the system.
 */
int	icode[]
{
	0104413,	/* sys exec; init; initp */
	0000014,
	0000010,
	0000777,	/* br . */
	0000021,	/* initp: init+5; 0 
			   use init as name -> looks nicer on ps */
	0000000,
	0062457,	/* init: </etc/init\0> */
	0061564,
	0064457,
	0064556,
	0000164,
};

#ifdef	BIG_UNIX
extern	char	eto[], eu[];
#endif

/*
 * Initialization code.
 * Called from m40.s or m45.s as
 * soon as a stack and segmentation
 * have been established.
 * Functions:
 *	clear and free user core
 *	find which clock is configured
 *	hand craft 0th process
 *	call all initialization routines
 *	fork - process 0 to schedule
 *	     - process 1 execute bootstrap
 *
 * panic: no clock -- neither clock responds
 * loop at loc 6 in user mode -- /etc/init
 *	cannot be executed.
 */
main()
{
	extern schar;
	register i, *p;

	/*
	 * zero and free all of core
	 */

	updlock = 0;
#ifndef	BIG_UNIX
	i = *ka6 + USIZE;
#endif
#ifdef	BIG_UNIX
	i = eu + USIZE;
#endif
	UISD->r[0] = 077406;
	for(;;) {
		UISA->r[0] = i;
		if(fuibyte(0) < 0)
			break;
#ifndef	BIG_UNIX
		clearseg(i);
#endif
		maxmem++;
#ifndef	BIG_UNIX
		mfree(coremap, 1, i);
#endif
		i++;
	}
#ifdef	BIG_UNIX
	mfree( coremap , maxmem, eu + USIZE );
#endif
#ifdef	_1170
	if(cputype == 70)
	for(i=0; i<62; i=+2) {
		UBMAP->r[i] = i<<12;
		UBMAP->r[i+1] = 0;
	}
#endif
	printf("       mem = %lKb\n\n", maxmem/16);				/* fix011 */
/*	printf("RESTRICTED RIGHTS\n\n");				fix012 */
/*	printf("Use, duplication or disclosure is subject to\n");	fix012 */
/*	printf("restrictions stated in Contract with Western\n");	fix012 */
/*	printf("Electric Company, Inc.\n");				fix012 */

	maxmem = min(maxmem, MAXMEM);
	mfree(swapmap, nswap, swplo);

	/*
	 * determine clock
	 */

	UISA->r[7] = ka6[1]; /* io segment */
	UISD->r[7] = 077406;
#ifndef	PROG_CLOCK
	lks = CLOCK1;
	if(fuiword(lks) == -1) {
#endif
		lks = CLOCK2;
		if(fuiword(lks) == -1)
			panic("no clock");
#ifndef	PROG_CLOCK
	}
#endif

#ifdef	STACK_LIMIT
	/*
	 *	if stack-limit register exists
	 *	use it !!
	 */

	if( fuiword(SLR) != -1)
	{	i = &u ;
		SLR->integ = i + sizeof u;
	}

#endif

	/*
	 * set up system process
	 */

	proc[0].p_addr = *ka6;
	proc[0].p_size = USIZE;
	proc[0].p_stat = SRUN;
	proc[0].p_flag =| SLOAD|SSYS;
	u.u_procp = &proc[0];

	/*
	 * set up 'known' i-nodes
	 */

	*lks = 0115;
	cinit();
	binit();
	iinit();
	rootdir = iget(rootdev, ROOTINO);
	rootdir->i_flag =& ~ILOCK;
	u.u_cdir = iget(rootdev, ROOTINO);
	u.u_cdir->i_flag =& ~ILOCK;

	/*
	 * make init process
	 * enter scheduling loop
	 * with system process
	 */

	if(newproc()) {
		expand(USIZE+1);
		estabur(0, 1, 0, 0);
#ifndef	_1170 | _1145
		copyout(icode, 0, sizeof icode);
#endif
#ifdef	_1170 | _1145
		copyout(icode, 0, sizeof icode, SEG_USD);
#endif
		/*
		 * Return goes to loc. 0 of user init
		 * code just copied out.
		 */
		return;
	}
	sched();
}

#ifndef	ONCE
#include "../estabur.h"
#endif

#ifdef	ONCE
#include "../iinit.h"

#include "../binit.h"

#include "../cinit.h"

#endif
